/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.config.Configuration;
import org.exist.config.ConfigurationException;
import org.exist.config.Configurator;
import org.exist.config.annotation.ConfigurationClass;
import org.exist.config.annotation.ConfigurationFieldAsAttribute;
import org.exist.config.annotation.ConfigurationFieldAsElement;
import org.exist.config.annotation.ConfigurationFieldClassMask;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.scheduler.JobDescription;
import org.exist.security.AbstractRealm;
import org.exist.security.Account;
import org.exist.security.AuthenticationException;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Principal;
import org.exist.security.SchemaType;
import org.exist.security.SecurityManager;
import org.exist.security.Session;
import org.exist.security.Subject;
import org.exist.security.internal.AccountImpl;
import org.exist.security.internal.GroupImpl;
import org.exist.security.internal.RealmImpl;
import org.exist.security.internal.SMEvents;
import org.exist.security.internal.SubjectAccreditedImpl;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.realm.Realm;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xmldb.XmldbURI;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@ConfigurationClass(value="security-manager")
public class SecurityManagerImpl
implements SecurityManager,
BrokerPoolService {
    public static final int MAX_USER_ID = 1048571;
    public static final int MAX_GROUP_ID = 1048572;
    public static final Logger LOG = LogManager.getLogger(SecurityManager.class);
    private Database db;
    protected PrincipalDbById<Group> groupsById = new PrincipalDbById();
    protected PrincipalDbById<Account> usersById = new PrincipalDbById();
    private final PrincipalLocks<Account> accountLocks = new PrincipalLocks();
    private final PrincipalLocks<Group> groupLocks = new PrincipalLocks();
    private SessionDb sessions = new SessionDb();
    @ConfigurationFieldAsAttribute(value="last-account-id")
    protected int lastUserId = 0;
    @ConfigurationFieldAsAttribute(value="last-group-id")
    protected int lastGroupId = 0;
    @ConfigurationFieldAsAttribute(value="version")
    private String version = "2.0";
    @ConfigurationFieldAsElement(value="authentication-entry-point")
    public static final String authenticationEntryPoint = "/authentication/login";
    private RealmImpl defaultRealm;
    @ConfigurationFieldAsElement(value="realm")
    @ConfigurationFieldClassMask(value="org.exist.security.realm.%1$s.%2$sRealm")
    private List<Realm> realms = new ArrayList<Realm>();
    @ConfigurationFieldAsElement(value="events")
    private SMEvents events = null;
    private org.exist.collections.Collection collection = null;
    private Configuration configuration = null;
    protected Subject systemSubject = null;
    protected Subject guestSubject = null;
    public static final long TIMEOUT_CHECK_PERIOD = 20000L;
    private Map<XmldbURI, Integer> saving = new HashMap<XmldbURI, Integer>();

    public SecurityManagerImpl(Database db) {
        this.db = db;
    }

    @Override
    public void prepare(BrokerPool brokerPool) throws BrokerPoolServiceException {
        try {
            this.defaultRealm = new RealmImpl(null, this, null);
            this.realms.add(this.defaultRealm);
        }
        catch (EXistException e) {
            throw new BrokerPoolServiceException(e);
        }
    }

    @Override
    public void startSystem(DBBroker systemBroker) throws BrokerPoolServiceException {
        try {
            this.attach(systemBroker);
        }
        catch (EXistException e) {
            throw new BrokerPoolServiceException(e);
        }
    }

    @Override
    public void startPreMultiUserSystem(DBBroker systemBroker) throws BrokerPoolServiceException {
        Properties params = new Properties();
        params.put(this.getClass().getName(), this);
        this.db.getScheduler().createPeriodicJob(20000L, new SessionsCheck(), 20000L, params, -1, false);
    }

    @Override
    public void attach(DBBroker broker) throws EXistException {
        Object object;
        Txn txn;
        this.db = broker.getDatabase();
        TransactionManager transaction = this.db.getTransactionManager();
        org.exist.collections.Collection systemCollection = null;
        try {
            txn = transaction.beginTransaction();
            object = null;
            try {
                systemCollection = broker.getCollection(XmldbURI.SYSTEM_COLLECTION_URI);
                if (systemCollection == null) {
                    systemCollection = broker.getOrCreateCollection(txn, XmldbURI.SYSTEM_COLLECTION_URI);
                    if (systemCollection == null) {
                        return;
                    }
                    systemCollection.setPermissions(493);
                    broker.saveCollection(txn, systemCollection);
                }
                transaction.commit(txn);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (txn != null) {
                    if (object != null) {
                        try {
                            txn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        txn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.debug("loading acl failed: " + e.getMessage());
        }
        try {
            txn = transaction.beginTransaction();
            object = null;
            try {
                this.collection = broker.getCollection(SECURITY_COLLECTION_URI);
                if (this.collection == null) {
                    this.collection = broker.getOrCreateCollection(txn, SECURITY_COLLECTION_URI);
                    if (this.collection == null) {
                        return;
                    }
                    this.collection.setPermissions(504);
                    broker.saveCollection(txn, this.collection);
                }
                transaction.commit(txn);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (txn != null) {
                    if (object != null) {
                        try {
                            txn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        txn.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.debug("loading configuration failed: " + e.getMessage());
        }
        Configuration _config_ = Configurator.parse(this, broker, this.collection, CONFIG_FILE_URI);
        this.configuration = Configurator.configure(this, _config_);
        for (Realm realm : this.realms) {
            realm.start(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateAccount(Account account) throws PermissionDeniedException, EXistException {
        if (account == null) {
            return false;
        }
        if (account.getRealmId() == null) {
            throw new ConfigurationException("Account must have realm id.");
        }
        ReentrantReadWriteLock.WriteLock lock = this.accountLocks.getWriteLock(account);
        lock.lock();
        try {
            boolean bl = this.findRealmForRealmId(account.getRealmId()).updateAccount(account);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateGroup(Group group) throws PermissionDeniedException, EXistException {
        if (group == null) {
            return false;
        }
        if (group.getRealmId() == null) {
            throw new ConfigurationException("Group must have realm id.");
        }
        ReentrantReadWriteLock.WriteLock lock = this.groupLocks.getWriteLock(group);
        lock.lock();
        try {
            boolean bl = this.findRealmForRealmId(group.getRealmId()).updateGroup(group);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteGroup(String name) throws PermissionDeniedException, EXistException {
        Group group = this.getGroup(name);
        if (group == null) {
            return false;
        }
        if (group.getRealmId() == null) {
            throw new ConfigurationException("Group must have realm id.");
        }
        ReentrantReadWriteLock.WriteLock lock = this.groupLocks.getWriteLock(group);
        lock.lock();
        try {
            boolean bl = this.findRealmForRealmId(group.getRealmId()).deleteGroup(group);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean deleteAccount(String name) throws PermissionDeniedException, EXistException {
        return this.deleteAccount(this.getAccount(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAccount(Account account) throws PermissionDeniedException, EXistException {
        if (account == null) {
            return false;
        }
        if (account.getRealmId() == null) {
            throw new ConfigurationException("Account must have realm id.");
        }
        ReentrantReadWriteLock.WriteLock lock = this.accountLocks.getWriteLock(account);
        lock.lock();
        try {
            boolean bl = this.findRealmForRealmId(account.getRealmId()).deleteAccount(account);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Account getAccount(String name) {
        for (Realm realm : this.realms) {
            Account account = realm.getAccount(name);
            if (account == null) continue;
            return account;
        }
        LOG.debug("Account for '" + name + "' not found!");
        return null;
    }

    @Override
    public final Account getAccount(int id) {
        return this.usersById.read(principalDb -> (Account)principalDb.get(id));
    }

    @Override
    public boolean hasGroup(String name) {
        for (Realm realm : this.realms) {
            if (!realm.hasGroup(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasGroup(Group group) {
        return this.hasGroup(group.getName());
    }

    @Override
    public Group getGroup(String name) {
        for (Realm realm : this.realms) {
            Group group = realm.getGroup(name);
            if (group == null) continue;
            return group;
        }
        return null;
    }

    @Override
    public final Group getGroup(int id) {
        return this.groupsById.read(principalDb -> (Group)principalDb.get(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAdminPrivileges(Account user) {
        ReentrantReadWriteLock.ReadLock lock = this.accountLocks.getReadLock(user);
        lock.lock();
        try {
            boolean bl = user.hasDbaRole();
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean hasAccount(String name) {
        for (Realm realm : this.realms) {
            if (!realm.hasAccount(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Subject authenticate(String username, Object credentials) throws AuthenticationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authentication try for '" + username + "'.");
        }
        if (username == null) {
            throw new AuthenticationException(0, "Account NULL not found");
        }
        if ("jsessionid".equals(username)) {
            if (this.getSystemSubject().getSessionId().equals(credentials)) {
                return this.getSystemSubject();
            }
            if (this.getGuestSubject().getSessionId().equals(credentials)) {
                return this.getGuestSubject();
            }
            Subject subject = this.sessions.read(db1 -> {
                Session session = (Session)db1.get(credentials);
                if (session == null) {
                    return null;
                }
                if (session.isValid()) {
                    return session.getSubject();
                }
                return null;
            });
            if (subject == null) {
                throw new AuthenticationException(3, "Session [" + credentials + "] not found");
            }
            if (this.events != null) {
                this.events.authenticated(subject);
            }
            return subject;
        }
        for (Realm realm : this.realms) {
            try {
                Subject subject = realm.authenticate(username, credentials);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authenticated by '" + realm.getId() + "' as '" + subject + "'.");
                }
                if (this.events != null) {
                    this.events.authenticated(subject);
                }
                return subject;
            }
            catch (AuthenticationException e) {
                if (e.getType() == 0) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Realm '" + realm.getId() + "' threw exception for account '" + username + "'. [" + e.getMessage() + "]");
                }
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Account '" + username + "' not found, throw error");
        }
        throw new AuthenticationException(0, "Account [" + username + "] not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject getSystemSubject() {
        if (this.systemSubject == null) {
            SecurityManagerImpl securityManagerImpl = this;
            synchronized (securityManagerImpl) {
                if (this.systemSubject == null) {
                    this.systemSubject = new SubjectAccreditedImpl(this.defaultRealm.ACCOUNT_SYSTEM, this);
                }
            }
        }
        return this.systemSubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject getGuestSubject() {
        if (this.guestSubject == null) {
            SecurityManagerImpl securityManagerImpl = this;
            synchronized (securityManagerImpl) {
                if (this.guestSubject == null) {
                    this.guestSubject = new SubjectAccreditedImpl((AccountImpl)this.defaultRealm.getAccount("guest"), this);
                }
            }
        }
        return this.guestSubject;
    }

    @Override
    public Group getDBAGroup() {
        return this.defaultRealm.GROUP_DBA;
    }

    @Override
    public Database getDatabase() {
        return this.db;
    }

    @Override
    public Database database() {
        return this.db;
    }

    private synchronized int getNextGroupId() {
        if (this.lastGroupId + 1 == 1048572) {
            throw new RuntimeException("System has no more group-ids available");
        }
        return ++this.lastGroupId;
    }

    private synchronized int getNextAccountId() {
        if (this.lastUserId + 1 == 1048571) {
            throw new RuntimeException("System has no more user-ids available");
        }
        return ++this.lastUserId;
    }

    @Override
    public List<Account> getGroupMembers(String groupName) {
        ArrayList<Account> groupMembers = new ArrayList<Account>();
        for (Realm realm : this.realms) {
            groupMembers.addAll(realm.getAccounts().stream().filter(account -> account.hasGroup(groupName)).collect(Collectors.toList()));
        }
        return groupMembers;
    }

    @Override
    public List<String> findAllGroupMembers(String groupName) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            userNames.addAll(realm.findAllGroupMembers(groupName));
        }
        return userNames;
    }

    @Override
    @Deprecated
    public Collection<Account> getUsers() {
        return this.defaultRealm.getAccounts();
    }

    @Override
    @Deprecated
    public Collection<Group> getGroups() {
        return this.defaultRealm.getGroups();
    }

    @Override
    public void addGroup(DBBroker broker, String name) throws PermissionDeniedException, EXistException {
        this.addGroup(broker, (Group)new GroupAider(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group addGroup(DBBroker broker, Group group) throws PermissionDeniedException, EXistException {
        if (group.getRealmId() == null) {
            throw new ConfigurationException("Group must have realm id.");
        }
        if (group.getName() == null || group.getName().isEmpty()) {
            throw new ConfigurationException("Group must have name.");
        }
        int id = group.getId() != -1 ? group.getId() : this.getNextGroupId();
        AbstractRealm registeredRealm = (AbstractRealm)this.findRealmForRealmId(group.getRealmId());
        if (registeredRealm.hasGroup(group.getName())) {
            throw new ConfigurationException("The group '" + group.getName() + "' at realm '" + group.getRealmId() + "' already exist.");
        }
        GroupImpl newGroup = new GroupImpl(broker, registeredRealm, id, group.getName(), group.getManagers());
        for (SchemaType metadataKey : group.getMetadataKeys()) {
            String metadataValue = group.getMetadataValue(metadataKey);
            newGroup.setMetadataValue(metadataKey, metadataValue);
        }
        ReentrantReadWriteLock.WriteLock lock = this.groupLocks.getWriteLock(newGroup);
        lock.lock();
        try {
            this.groupsById.modify(principalDb -> principalDb.put(id, newGroup));
            registeredRealm.registerGroup(newGroup);
            this.save(broker);
            newGroup.save(broker);
            GroupImpl groupImpl = newGroup;
            return groupImpl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final Account addAccount(Account account) throws PermissionDeniedException, EXistException {
        try (DBBroker broker = this.db.getBroker();){
            Account account2 = this.addAccount(broker, account);
            return account2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Account addAccount(DBBroker broker, Account account) throws PermissionDeniedException, EXistException {
        if (account.getRealmId() == null) {
            throw new ConfigurationException("Account must have realm id.");
        }
        if (account.getName() == null || account.getName().isEmpty()) {
            throw new ConfigurationException("Account must have name.");
        }
        int id = account.getId() != -1 ? account.getId() : this.getNextAccountId();
        AbstractRealm registeredRealm = (AbstractRealm)this.findRealmForRealmId(account.getRealmId());
        AccountImpl newAccount = new AccountImpl(broker, registeredRealm, id, account);
        ReentrantReadWriteLock.WriteLock lock = this.accountLocks.getWriteLock(newAccount);
        lock.lock();
        try {
            this.usersById.modify(principalDb -> principalDb.put(id, newAccount));
            registeredRealm.registerAccount(newAccount);
            this.save(broker);
            newAccount.save(broker);
            AccountImpl accountImpl = newAccount;
            return accountImpl;
        }
        finally {
            lock.unlock();
        }
    }

    private void save() throws PermissionDeniedException, EXistException {
        if (this.configuration != null) {
            this.configuration.save();
        }
    }

    private void save(DBBroker broker) throws PermissionDeniedException, EXistException {
        if (this.configuration != null) {
            this.configuration.save(broker);
        }
    }

    @Override
    public boolean isConfigured() {
        return this.configuration != null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void registerSession(Session session) {
        this.sessions.modify(db -> db.put(session.getId(), session));
    }

    @Override
    public Subject getSubjectBySessionId(String sessionId) {
        return this.sessions.read(db -> {
            Session session = (Session)db.get(sessionId);
            if (session != null) {
                return session.getSubject();
            }
            return null;
        });
    }

    private Realm findRealmForRealmId(String realmId) throws ConfigurationException {
        for (Realm realm : this.realms) {
            if (!realm.getId().equals(realmId)) continue;
            return realm;
        }
        throw new ConfigurationException("Realm id = '" + realmId + "' not found.");
    }

    @Override
    public void addGroup(int id, Group group) {
        this.groupsById.modify(principalDb -> principalDb.put(id, group));
    }

    @Override
    public void addUser(int id, Account account) {
        this.usersById.modify(principalDb -> principalDb.put(id, account));
    }

    @Override
    public boolean hasGroup(int id) {
        return this.groupsById.read(principalDb -> principalDb.containsKey(id));
    }

    @Override
    public boolean hasUser(int id) {
        return this.usersById.read(principalDb -> principalDb.containsKey(id));
    }

    @Override
    public List<String> findUsernamesWhereNameStarts(String startsWith) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            userNames.addAll(realm.findUsernamesWhereNameStarts(startsWith));
        }
        return userNames;
    }

    @Override
    public List<String> findUsernamesWhereUsernameStarts(String startsWith) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            userNames.addAll(realm.findUsernamesWhereUsernameStarts(startsWith));
        }
        return userNames;
    }

    @Override
    public List<String> findUsernamesWhereNamePartStarts(String startsWith) {
        ArrayList<String> userNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            userNames.addAll(realm.findUsernamesWhereNamePartStarts(startsWith));
        }
        return userNames;
    }

    @Override
    public List<String> findGroupnamesWhereGroupnameContains(String fragment) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            groupNames.addAll(realm.findGroupnamesWhereGroupnameContains(fragment));
        }
        return groupNames;
    }

    @Override
    public List<String> findGroupnamesWhereGroupnameStarts(String startsWith) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            groupNames.addAll(realm.findGroupnamesWhereGroupnameStarts(startsWith));
        }
        return groupNames;
    }

    @Override
    public List<String> findAllGroupNames() {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            groupNames.addAll(realm.findAllGroupNames());
        }
        return groupNames;
    }

    @Override
    public List<String> findAllUserNames() {
        ArrayList<String> userNames = new ArrayList<String>();
        for (Realm realm : this.realms) {
            userNames.addAll(realm.findAllUserNames());
        }
        return userNames;
    }

    @Override
    public void processPramatterBeforeSave(DBBroker broker, DocumentImpl document) throws ConfigurationException {
        XmldbURI uri = document.getCollection().getURI();
        boolean isRemoved = uri.endsWith(SecurityManager.REMOVED_COLLECTION_URI);
        if (isRemoved) {
            uri = uri.removeLastSegment();
        }
        boolean isAccount = uri.endsWith(SecurityManager.ACCOUNTS_COLLECTION_URI);
        boolean isGroup = uri.endsWith(SecurityManager.GROUPS_COLLECTION_URI);
        if (isAccount || isGroup) {
            Configuration conf = Configurator.parse(broker.getBrokerPool(), document);
            this.saving.put(document.getURI(), conf.getPropertyInteger("id"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPramatter(DBBroker broker, DocumentImpl document) throws ConfigurationException {
        XmldbURI uri = document.getCollection().getURI();
        boolean isRemoved = uri.endsWith(SecurityManager.REMOVED_COLLECTION_URI);
        if (isRemoved) {
            uri = uri.removeLastSegment();
        }
        boolean isAccount = uri.endsWith(SecurityManager.ACCOUNTS_COLLECTION_URI);
        boolean isGroup = uri.endsWith(SecurityManager.GROUPS_COLLECTION_URI);
        if (isAccount || isGroup) {
            uri = uri.removeLastSegment();
            String realmId = uri.lastSegment().toString();
            AbstractRealm realm = (AbstractRealm)this.findRealmForRealmId(realmId);
            Configuration conf = Configurator.parse(broker.getBrokerPool(), document);
            Integer id = -1;
            if (isRemoved) {
                id = conf.getPropertyInteger("id");
            }
            String name = conf.getProperty("name");
            if (isAccount) {
                if (isRemoved && id > 2 && !this.hasUser(id)) {
                    AccountImpl account = new AccountImpl(realm, conf);
                    account.removed = true;
                    this.addUser(account.getId(), account);
                } else if (name != null) {
                    if (realm.hasAccount(name)) {
                        Integer oldId = this.saving.get(document.getURI());
                        Integer newId = conf.getPropertyInteger("id");
                        if (!newId.equals(oldId)) {
                            Account current = realm.getAccount(name);
                            this.accountLocks.getWriteLock(current).lock();
                            try {
                                this.usersById.modify(principalDb -> {
                                    principalDb.remove(oldId);
                                    principalDb.put(newId, current);
                                });
                            }
                            finally {
                                this.accountLocks.getWriteLock(current).unlock();
                            }
                        }
                    } else {
                        AccountImpl account = new AccountImpl(realm, conf);
                        this.addUser(account.getId(), account);
                        realm.registerAccount(account);
                    }
                } else {
                    LOG.error("Account '" + name + "' pressent at '" + realmId + "' realm, but get event that new one created.");
                }
            } else if (isGroup) {
                if (isRemoved && id > 2 && !this.hasGroup(id)) {
                    GroupImpl group = new GroupImpl(realm, conf);
                    group.removed = true;
                    this.addGroup(group.getId(), (Group)group);
                } else if (name != null && !realm.hasGroup(name)) {
                    GroupImpl group = new GroupImpl(realm, conf);
                    this.addGroup(group.getId(), (Group)group);
                    realm.registerGroup(group);
                } else {
                    LOG.error("Group '" + name + "' pressent at '" + realmId + "' realm, but get event that new one created.");
                }
            }
            this.saving.remove(document.getURI());
        }
    }

    @Override
    public String getAuthenticationEntryPoint() {
        return authenticationEntryPoint;
    }

    @Override
    public Subject getCurrentSubject() {
        return this.db.getActiveBroker().getCurrentSubject();
    }

    @Override
    public final synchronized void preAllocateAccountId(SecurityManager.PrincipalIdReceiver receiver) throws PermissionDeniedException, EXistException {
        int id = this.getNextAccountId();
        this.save();
        receiver.allocate(id);
    }

    @Override
    public final synchronized void preAllocateGroupId(SecurityManager.PrincipalIdReceiver receiver) throws PermissionDeniedException, EXistException {
        int id = this.getNextGroupId();
        this.save();
        receiver.allocate(id);
    }

    protected static class PrincipalDbById<V extends Principal> {
        private final Int2ObjectHashMap<V> db = new Int2ObjectHashMap(65);
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

        protected PrincipalDbById() {
        }

        public <R> R read(Function<Int2ObjectHashMap<V>, R> readFn) {
            this.readLock.lock();
            try {
                R r = readFn.apply(this.db);
                return r;
            }
            finally {
                this.readLock.unlock();
            }
        }

        public final void modify(Consumer<Int2ObjectHashMap<V>> writeOp) {
            this.writeLock.lock();
            try {
                writeOp.accept(this.db);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    protected static class SessionDb {
        private final Map<String, Session> db = new HashMap<String, Session>();
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

        protected SessionDb() {
        }

        public <R> R read(Function<Map<String, Session>, R> readFn) {
            this.readLock.lock();
            try {
                R r = readFn.apply(this.db);
                return r;
            }
            finally {
                this.readLock.unlock();
            }
        }

        public final void modify(Consumer<Map<String, Session>> modifyFn) {
            this.writeLock.lock();
            try {
                modifyFn.accept(this.db);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private static class PrincipalLocks<T extends Principal> {
        private final Map<Integer, ReentrantReadWriteLock> locks = new HashMap<Integer, ReentrantReadWriteLock>();

        private PrincipalLocks() {
        }

        private synchronized ReentrantReadWriteLock getLock(T principal) {
            ReentrantReadWriteLock lock = this.locks.get(principal.getId());
            if (lock == null) {
                lock = new ReentrantReadWriteLock();
                this.locks.put(principal.getId(), lock);
            }
            return lock;
        }

        public ReentrantReadWriteLock.ReadLock getReadLock(T principal) {
            return this.getLock(principal).readLock();
        }

        public ReentrantReadWriteLock.WriteLock getWriteLock(T principal) {
            return this.getLock(principal).writeLock();
        }
    }

    public static class SessionsCheck
    implements JobDescription,
    Job {
        boolean firstRun = true;

        @Override
        public String getGroup() {
            return "eXist.Security";
        }

        @Override
        public String getName() {
            return "Sessions.Check";
        }

        @Override
        public void setName(String name) {
        }

        public final void execute(JobExecutionContext jec) throws JobExecutionException {
            JobDataMap jobDataMap = jec.getJobDetail().getJobDataMap();
            Properties params = (Properties)jobDataMap.get((Object)"params");
            if (params == null) {
                return;
            }
            SecurityManagerImpl sm = (SecurityManagerImpl)params.get(SecurityManagerImpl.class.getName());
            if (sm == null) {
                return;
            }
            sm.sessions.modify(db -> {
                Iterator it = db.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (entry != null && ((Session)entry.getValue()).isValid()) continue;
                    it.remove();
                }
            });
        }
    }
}

