/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal;

import org.exist.security.AbstractAccount;
import org.exist.security.AbstractSubject;

public final class SubjectImpl
extends AbstractSubject {
    private boolean authenticated = false;

    public SubjectImpl(AbstractAccount account, Object credentials) {
        super(account);
        this.authenticate(credentials);
    }

    @Override
    public boolean authenticate(Object credentials) {
        this.authenticated = this.account.checkCredentials(credentials);
        return this.authenticated;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isExternallyAuthenticated() {
        return this.isAuthenticated();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isAuthenticated()) {
            sb.append("[auth] ");
        } else {
            sb.append("[NOT auth] ");
        }
        sb.append(this.account.toString());
        return sb.toString();
    }
}

