/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal.aider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exist.config.Configuration;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.internal.RealmImpl;
import org.exist.security.realm.Realm;
import org.exist.storage.DBBroker;

public class GroupAider
implements Group {
    private final String realmId;
    private final String name;
    private final int id;
    private final List<Account> managers = new ArrayList<Account>();
    private final Map<SchemaType, String> metadataValues = new HashMap<SchemaType, String>();

    public GroupAider(int id) {
        this(id, null, null);
    }

    public GroupAider(String realmId, String name) {
        this(-1, realmId, name);
    }

    public GroupAider(int id, String realmId, String name) {
        this.id = id;
        this.name = name;
        this.realmId = realmId;
    }

    public GroupAider(String name) {
        this(RealmImpl.ID, name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean isConfigured() {
        return false;
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    @Override
    public String getRealmId() {
        return this.realmId;
    }

    @Override
    public void save() throws PermissionDeniedException {
    }

    @Override
    public void save(DBBroker broker) throws PermissionDeniedException {
    }

    @Override
    public boolean isManager(Account account) {
        for (Account manager : this.managers) {
            if (!manager.getName().equals(account.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addManager(Account account) throws PermissionDeniedException {
        if (!this.managers.contains(account)) {
            this.managers.add(account);
        }
    }

    @Override
    public void addManagers(List<Account> managers) throws PermissionDeniedException {
        for (Account manager : managers) {
            this.addManager(manager);
        }
    }

    @Override
    public List<Account> getManagers() throws PermissionDeniedException {
        return this.managers;
    }

    @Override
    public void removeManager(Account account) throws PermissionDeniedException {
        for (Account manager : this.managers) {
            if (!manager.getName().equals(account.getName())) continue;
            this.managers.remove(manager);
            break;
        }
    }

    @Override
    public void assertCanModifyGroup(Account account) throws PermissionDeniedException {
    }

    @Override
    public Realm getRealm() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMetadataValue(SchemaType schemaType, String value) {
        this.metadataValues.put(schemaType, value);
    }

    @Override
    public String getMetadataValue(SchemaType schemaType) {
        return this.metadataValues.get(schemaType);
    }

    @Override
    public Set<SchemaType> getMetadataKeys() {
        return this.metadataValues.keySet();
    }

    @Override
    public void clearMetadata() {
        this.metadataValues.clear();
    }
}

