/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal.aider;

import java.io.IOException;
import org.exist.security.AbstractUnixStylePermission;
import org.exist.security.Account;
import org.exist.security.Group;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.internal.aider.PermissionAider;
import org.exist.security.internal.aider.UserAider;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;
import org.exist.util.SyntaxException;

public class UnixStylePermissionAider
extends AbstractUnixStylePermission
implements PermissionAider {
    private Account owner;
    private Group ownerGroup;
    private int mode;

    public UnixStylePermissionAider() {
        this.owner = new UserAider("admin");
    }

    public UnixStylePermissionAider(int mode) {
        this();
        this.mode = mode;
    }

    public UnixStylePermissionAider(String user, String group, int mode) {
        this.owner = new UserAider(user);
        this.ownerGroup = new GroupAider(group);
        this.mode = mode;
    }

    @Override
    public boolean isSetGid() {
        return (this.mode >>> 9 & 2) == 2;
    }

    @Override
    public boolean isSetUid() {
        return (this.mode >>> 9 & 4) == 4;
    }

    @Override
    public boolean isSticky() {
        return (this.mode >>> 9 & 1) == 1;
    }

    @Override
    public void setSetUid(boolean setUid) {
        this.mode = setUid ? (this.mode |= 0x800) : (this.mode &= 0xFFFFF7FF);
    }

    @Override
    public void setSetGid(boolean setGid) {
        this.mode = setGid ? (this.mode |= 0x400) : (this.mode &= 0xFFFFFBFF);
    }

    @Override
    public void setSticky(boolean sticky) {
        this.mode = sticky ? (this.mode |= 0x200) : (this.mode &= 0xFFFFFDFF);
    }

    @Override
    public int getGroupMode() {
        return (this.mode & 0x38) >> 3;
    }

    @Override
    public Account getOwner() {
        return this.owner;
    }

    @Override
    public Group getGroup() {
        return this.ownerGroup;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public int getOtherMode() {
        return this.mode & 7;
    }

    @Override
    public int getOwnerMode() {
        return (this.mode & 0x1C0) >> 6;
    }

    @Override
    public void setGroup(Group group) {
        this.ownerGroup = group;
    }

    @Override
    public void setGroup(String group) {
        this.ownerGroup = new GroupAider(group);
    }

    @Override
    public void setGroupFrom(Permission other) throws PermissionDeniedException {
        this.ownerGroup = new GroupAider(other.getGroup().getName());
    }

    @Override
    public void setGroupMode(int groupMode) {
        this.mode |= groupMode << 3;
    }

    @Override
    public void setOwner(Account user) {
        this.owner = user;
    }

    @Override
    public void setOwner(String user) {
        this.owner = new UserAider(user);
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setOtherMode(int otherMode) {
        this.mode |= otherMode;
    }

    @Override
    public void setOwnerMode(int ownerMode) {
        this.mode |= ownerMode << 6;
    }

    public String toString() {
        char[] cArray = new char[9];
        cArray[0] = (this.mode & 0x100) == 0 ? 45 : 114;
        int n = cArray[1] = (this.mode & 0x80) == 0 ? 45 : 119;
        cArray[2] = (this.mode & 0x800) == 0 ? ((this.mode & 0x40) == 0 ? 45 : 120) : ((this.mode & 0x40) == 0 ? 83 : 115);
        cArray[3] = (this.mode & 0x20) == 0 ? 45 : 114;
        int n2 = cArray[4] = (this.mode & 0x10) == 0 ? 45 : 119;
        cArray[5] = (this.mode & 0x400) == 0 ? ((this.mode & 8) == 0 ? 45 : 120) : ((this.mode & 8) == 0 ? 83 : 115);
        cArray[6] = (this.mode & 4) == 0 ? 45 : 114;
        int n3 = cArray[7] = (this.mode & 2) == 0 ? 45 : 119;
        cArray[8] = (this.mode & 0x200) == 0 ? ((this.mode & 1) == 0 ? 45 : 120) : ((this.mode & 1) == 0 ? 84 : 116);
        char[] ch = cArray;
        return String.valueOf(ch);
    }

    public static UnixStylePermissionAider fromString(String modeStr) throws SyntaxException {
        if (modeStr == null || modeStr.length() != 9 && modeStr.length() != 12) {
            throw new SyntaxException("Invalid Permission String '" + modeStr + "'");
        }
        int mode = 0;
        for (int i = 0; i < modeStr.length(); i += 3) {
            block11: for (char c : modeStr.substring(i, i + 3).toCharArray()) {
                switch (c) {
                    case 'r': {
                        mode |= 4 << 6 - i;
                        continue block11;
                    }
                    case 'w': {
                        mode |= 2 << 6 - i;
                        continue block11;
                    }
                    case 'x': {
                        mode |= 1 << 6 - i;
                        continue block11;
                    }
                    case 's': {
                        if (i == 0) {
                            mode |= 0x800;
                        } else if (i == 3) {
                            mode |= 0x400;
                        }
                        mode |= 1 << 6 - i;
                        continue block11;
                    }
                    case 'S': {
                        if (i == 0) {
                            mode |= 0x800;
                            continue block11;
                        }
                        if (i != 3) continue block11;
                        mode |= 0x400;
                        continue block11;
                    }
                    case 't': {
                        mode |= 0x200;
                        mode |= 1 << 6 - i;
                        continue block11;
                    }
                    case 'T': {
                        mode |= 0x200;
                        continue block11;
                    }
                    case '-': {
                        continue block11;
                    }
                    default: {
                        throw new SyntaxException("Unknown char '" + c + "' in mode string '" + modeStr + "'");
                    }
                }
            }
        }
        return new UnixStylePermissionAider(mode);
    }

    @Override
    public boolean validate(Subject user, int mode) {
        throw new UnsupportedOperationException("Validation of Permission Aider is unsupported");
    }

    @Override
    public void setGroup(int id) {
        this.ownerGroup = new GroupAider(id);
    }

    @Override
    public void setOwner(int id) {
        this.owner = new UserAider(id);
    }

    @Override
    public void write(VariableByteOutputStream ostream) {
        throw new UnsupportedOperationException("Serialization of permission Aider is unsupported");
    }

    @Override
    public void read(VariableByteInput istream) throws IOException {
        throw new UnsupportedOperationException("De-Serialization of permission Aider is unsupported");
    }

    @Override
    public boolean isCurrentSubjectDBA() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCurrentSubjectOwner() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCurrentSubjectInGroup() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isCurrentSubjectInGroup(int groupId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

