/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.internal.aider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.exist.config.Configuration;
import org.exist.security.Account;
import org.exist.security.Credential;
import org.exist.security.Group;
import org.exist.security.PermissionDeniedException;
import org.exist.security.SchemaType;
import org.exist.security.internal.RealmImpl;
import org.exist.security.internal.aider.GroupAider;
import org.exist.security.realm.Realm;
import org.exist.storage.DBBroker;

public class UserAider
implements Account {
    private final String realmId;
    private final String name;
    private final int id;
    private final Map<SchemaType, String> metadata = new HashMap<SchemaType, String>();
    private String password = null;
    private String passwordDigest = null;
    private Group defaultRole = null;
    private Map<String, Group> roles = new LinkedHashMap<String, Group>();
    private int umask = 18;
    private boolean enabled = true;

    public UserAider(int id) {
        this(id, null, null);
    }

    public UserAider(String name) {
        this(RealmImpl.ID, name);
    }

    public UserAider(String realmId, String name) {
        this(-1, realmId, name);
    }

    public UserAider(int id, String realmId, String name) {
        this.realmId = realmId;
        this.name = name;
        this.id = id;
    }

    public UserAider(String realmId, String name, Group group) {
        this(realmId, name);
        this.defaultRole = this.addGroup(group);
    }

    public UserAider(String name, Group group) {
        this(name);
        this.defaultRole = this.addGroup(group);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRealmId() {
        return this.realmId;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Group addGroup(String name) {
        GroupAider role = new GroupAider(this.realmId, name);
        this.roles.put(name, role);
        return role;
    }

    @Override
    public Group addGroup(Group group) {
        if (group == null) {
            return null;
        }
        return this.addGroup(group.getName());
    }

    @Override
    public void setPrimaryGroup(Group group) throws PermissionDeniedException {
        if (!this.roles.containsKey(group.getName())) {
            this.addGroup(group);
        }
        ArrayList<Map.Entry<String, Group>> entries = new ArrayList<Map.Entry<String, Group>>(this.roles.entrySet());
        Collections.sort(entries, (o1, o2) -> {
            if (((String)o1.getKey()).equals(group.getName())) {
                return -1;
            }
            return 1;
        });
        this.roles = new LinkedHashMap<String, Group>();
        for (Map.Entry entry : entries) {
            this.roles.put((String)entry.getKey(), (Group)entry.getValue());
        }
    }

    @Override
    public void remGroup(String role) {
        this.roles.remove(role);
    }

    @Override
    public void setGroups(String[] names) {
        this.roles = new HashMap<String, Group>();
        for (String name : names) {
            this.addGroup(name);
        }
    }

    @Override
    public String[] getGroups() {
        return this.roles.keySet().toArray(new String[0]);
    }

    @Override
    public int[] getGroupIds() {
        return new int[0];
    }

    @Override
    public boolean hasDbaRole() {
        return false;
    }

    @Override
    public String getPrimaryGroup() {
        if (this.defaultRole == null) {
            return null;
        }
        return this.defaultRole.getName();
    }

    @Override
    public boolean hasGroup(String group) {
        return this.roles.containsKey(group);
    }

    @Override
    public Realm getRealm() {
        return null;
    }

    @Override
    public String getMetadataValue(SchemaType schemaType) {
        return this.metadata.get(schemaType);
    }

    @Override
    public void setMetadataValue(SchemaType schemaType, String value) {
        this.metadata.put(schemaType, value);
    }

    @Override
    public Set<SchemaType> getMetadataKeys() {
        return this.metadata.keySet();
    }

    @Override
    public void clearMetadata() {
        this.metadata.clear();
    }

    @Override
    public Group getDefaultGroup() {
        return this.defaultRole;
    }

    public void setEncodedPassword(String passwd) {
        this.password = passwd;
    }

    @Override
    public void setPassword(String passwd) {
        this.password = passwd;
    }

    @Override
    public void setCredential(Credential credential) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPasswordDigest(String password) {
        this.passwordDigest = password;
    }

    @Override
    public String getDigestPassword() {
        return this.passwordDigest;
    }

    @Override
    public boolean isConfigured() {
        return false;
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    @Override
    public String getUsername() {
        return null;
    }

    @Override
    public boolean isAccountNonExpired() {
        return false;
    }

    @Override
    public boolean isAccountNonLocked() {
        return false;
    }

    @Override
    public boolean isCredentialsNonExpired() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void save() throws PermissionDeniedException {
    }

    @Override
    public void save(DBBroker broker) throws PermissionDeniedException {
    }

    @Override
    public void assertCanModifyAccount(Account user) throws PermissionDeniedException {
        if (user.getId() != this.getId() && !user.hasDbaRole()) {
            throw new PermissionDeniedException("Permission denied to modify user");
        }
    }

    @Override
    public int getUserMask() {
        return this.umask;
    }

    @Override
    public void setUserMask(int umask) {
        this.umask = umask;
    }
}

