/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.exist.dom.QName;
import org.exist.source.Source;
import org.exist.xquery.XPathException;
import org.exist.xquery.parser.DeclScanner;
import org.exist.xquery.parser.XQueryLexer;

public abstract class AbstractSource
implements Source {
    private long cacheTime = 0L;

    @Override
    public Charset getEncoding() throws IOException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Source) {
            return this.getKey().equals(((Source)obj).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public long getCacheTimestamp() {
        return this.cacheTime;
    }

    @Override
    public void setCacheTimestamp(long timestamp) {
        this.cacheTime = timestamp;
    }

    @Override
    public QName isModule() throws IOException {
        return null;
    }

    protected static final String guessXQueryEncoding(InputStream is) {
        XQueryLexer lexer = new XQueryLexer(null, new InputStreamReader(is));
        DeclScanner scanner = new DeclScanner(lexer);
        try {
            scanner.versionDecl();
        }
        catch (RecognitionException | TokenStreamException | XPathException throwable) {
            // empty catch block
        }
        return scanner.getEncoding();
    }

    protected static final QName getModuleDecl(InputStream is) {
        XQueryLexer lexer = new XQueryLexer(null, new InputStreamReader(is));
        DeclScanner scanner = new DeclScanner(lexer);
        try {
            scanner.versionDecl();
        }
        catch (RecognitionException | TokenStreamException | XPathException throwable) {
            // empty catch block
        }
        if (scanner.getNamespace() != null) {
            return new QName(scanner.getPrefix(), scanner.getNamespace());
        }
        return null;
    }
}

