/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;

public class FileSource
extends AbstractSource {
    private static final Logger LOG = LogManager.getLogger(FileSource.class);
    private final Path path;
    private Charset encoding;
    private final boolean checkEncoding;
    private String filePath;
    private long lastModified;

    public FileSource(Path path, boolean checkXQEncoding) {
        this(path, StandardCharsets.UTF_8, checkXQEncoding);
    }

    public FileSource(Path path, Charset encoding, boolean checkXQEncoding) {
        this.path = path;
        this.encoding = encoding;
        this.checkEncoding = checkXQEncoding;
        this.filePath = path.toAbsolutePath().toString();
        this.lastModified = this.lastModifiedSafe(path);
    }

    @Override
    public String path() {
        return this.getFilePath();
    }

    @Override
    public String type() {
        return "File";
    }

    @Override
    public Object getKey() {
        return this.filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public Source.Validity isValid(DBBroker broker) {
        long currentLastModified = this.lastModifiedSafe(this.path);
        if (currentLastModified == -1L || currentLastModified > this.lastModified) {
            return Source.Validity.INVALID;
        }
        return Source.Validity.VALID;
    }

    @Override
    public Source.Validity isValid(Source other) {
        return Source.Validity.INVALID;
    }

    @Override
    public Reader getReader() throws IOException {
        this.checkEncoding();
        return Files.newBufferedReader(this.path, this.encoding);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.path, new OpenOption[0]);
    }

    @Override
    public String getContent() throws IOException {
        this.checkEncoding();
        return new String(Files.readAllBytes(this.path), this.encoding);
    }

    @Override
    public Charset getEncoding() throws IOException {
        this.checkEncoding();
        return this.encoding;
    }

    private void checkEncoding() throws IOException {
        if (this.checkEncoding) {
            try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
                String checkedEnc = FileSource.guessXQueryEncoding(is);
                if (checkedEnc != null) {
                    this.encoding = Charset.forName(checkedEnc);
                }
            }
        }
    }

    private long lastModifiedSafe(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            return -1L;
        }
    }

    @Override
    public QName isModule() throws IOException {
        try (InputStream is = Files.newInputStream(this.path, new OpenOption[0]);){
            QName qName = FileSource.getModuleDecl(is);
            return qName;
        }
    }

    public String toString() {
        return this.filePath;
    }

    @Override
    public void validate(Subject subject, int perm) throws PermissionDeniedException {
    }
}

