/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;

public class StringSource
extends AbstractSource {
    private String data;

    public StringSource(String content) {
        this.data = content;
    }

    @Override
    public String path() {
        return this.type();
    }

    @Override
    public String type() {
        return "String";
    }

    @Override
    public Object getKey() {
        return this.data;
    }

    @Override
    public Source.Validity isValid(DBBroker broker) {
        return Source.Validity.VALID;
    }

    @Override
    public Source.Validity isValid(Source other) {
        return Source.Validity.VALID;
    }

    @Override
    public Reader getReader() throws IOException {
        return new StringReader(this.data);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getContent() throws IOException {
        return this.data;
    }

    @Override
    public void validate(Subject subject, int perm) throws PermissionDeniedException {
    }
}

