/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;

public class URLSource
extends AbstractSource {
    private static final Pattern URL_PATTERN = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
    private static final Logger LOG = LogManager.getLogger(URLSource.class);
    protected URL url;
    private URLConnection connection = null;
    private long lastModified = 0L;
    private int responseCode = 200;

    protected URLSource() {
    }

    public URLSource(URL url) {
        this.url = url;
    }

    @Override
    public String path() {
        String protocol = this.url.getProtocol();
        String host = this.url.getHost();
        if (protocol.equals("file") && (host == null || host.length() == 0 || "localhost".equals(host) || "127.0.0.1".equals(host))) {
            return this.url.getFile();
        }
        return this.url.toExternalForm();
    }

    @Override
    public String type() {
        String protocol = this.url.getProtocol();
        String host = this.url.getHost();
        if (protocol.equals("file") && (host == null || host.length() == 0 || "localhost".equals(host) || "127.0.0.1".equals(host))) {
            return "File";
        }
        return "URL";
    }

    protected void setURL(URL url) {
        this.url = url;
    }

    public URL getURL() {
        return this.url;
    }

    private long getLastModification() {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
            }
            return this.connection.getLastModified();
        }
        catch (IOException e) {
            LOG.warn("URL could not be opened: " + e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    @Override
    public Object getKey() {
        return this.url;
    }

    @Override
    public Source.Validity isValid(DBBroker broker) {
        long modified = this.getLastModification();
        if (modified == 0L && modified > this.lastModified) {
            return Source.Validity.INVALID;
        }
        return Source.Validity.VALID;
    }

    @Override
    public Source.Validity isValid(Source other) {
        return Source.Validity.INVALID;
    }

    @Override
    public Charset getEncoding() throws IOException {
        String contentType;
        if (this.connection == null) {
            this.connection = this.url.openConnection();
        }
        if ((contentType = this.connection.getContentType()) != null) {
            Matcher matcher = URL_PATTERN.matcher(contentType);
            if (matcher.find()) {
                try {
                    return Charset.forName(matcher.group(1).trim().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (contentType.startsWith("text/")) {
                return StandardCharsets.ISO_8859_1;
            }
        }
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
                if (this.connection instanceof HttpURLConnection) {
                    this.responseCode = ((HttpURLConnection)this.connection).getResponseCode();
                }
            }
            InputStreamReader reader = null;
            if (this.responseCode != 404) {
                reader = new InputStreamReader(this.connection.getInputStream(), "UTF-8");
            }
            this.connection = null;
            return reader;
        }
        catch (IOException e) {
            LOG.warn("URL could not be opened: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
                if (this.connection instanceof HttpURLConnection) {
                    this.responseCode = ((HttpURLConnection)this.connection).getResponseCode();
                }
            }
            InputStream is = null;
            if (this.responseCode != 404) {
                is = this.connection.getInputStream();
            }
            this.connection = null;
            return is;
        }
        catch (ConnectException e) {
            LOG.warn("Unable to connect to URL: " + e.getMessage());
            throw e;
        }
        catch (IOException e) {
            LOG.warn("URL could not be opened: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    @Override
    public String getContent() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = this.url.openConnection();
                if (this.connection instanceof HttpURLConnection) {
                    this.responseCode = ((HttpURLConnection)this.connection).getResponseCode();
                }
            }
            String content = this.connection.getContent().toString();
            this.connection = null;
            return content;
        }
        catch (IOException e) {
            LOG.warn("URL could not be opened: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String toString() {
        if (this.url == null) {
            return "[not set]";
        }
        return this.url.toString();
    }

    @Override
    public void validate(Subject subject, int perm) throws PermissionDeniedException {
    }

    @Override
    public QName isModule() throws IOException {
        try (InputStream is = this.getInputStream();){
            QName qName = URLSource.getModuleDecl(is);
            return qName;
        }
    }
}

