/*
 * Decompiled with CFR 0.152.
 */
package org.exist.stax;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.AbstractCharacterData;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.stax.ExtendedXMLStreamReader;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.DBBroker;
import org.exist.storage.Signatures;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.IRawNodeIterator;
import org.exist.util.ByteConversion;
import org.exist.util.XMLString;
import org.exist.util.serializer.AttrList;
import org.w3c.dom.ProcessingInstruction;

public abstract class AbstractEmbeddedXMLStreamReader<T extends IRawNodeIterator>
implements IEmbeddedXMLStreamReader,
ExtendedXMLStreamReader {
    private static final Logger LOG = LogManager.getLogger(AbstractEmbeddedXMLStreamReader.class);
    protected final T iterator;
    private Value current = null;
    private Value previous = null;
    private final Stack<ElementEvent> elementStack = new Stack();
    private int state = 7;
    private boolean beforeRoot = false;
    private DocumentImpl document;
    protected NodeId nodeId;
    protected NodeHandle origin;
    private QName qname = null;
    private final XMLString text = new XMLString(256);
    private final List<String[]> namespaces = new ArrayList<String[]>(6);
    private boolean nsRead = false;
    private AttrList attributes = null;
    private boolean reportAttribs = false;
    private DBBroker broker;

    public AbstractEmbeddedXMLStreamReader(DBBroker broker, DocumentImpl doc, T iterator, NodeHandle origin, boolean reportAttributes) throws XMLStreamException {
        this.broker = broker;
        this.document = doc;
        this.iterator = iterator;
        this.reportAttribs = reportAttributes;
        this.origin = origin;
    }

    @Override
    public void filter(StreamFilter filter) throws XMLStreamException {
        while (this.hasNext()) {
            this.next();
            if (filter.accept(this)) continue;
            break;
        }
    }

    @Override
    public void reposition(DBBroker broker, NodeHandle node, boolean reportAttributes) throws IOException {
        this.broker = broker;
        this.iterator.seek(node);
        this.reset();
        this.current = null;
        this.previous = null;
        this.elementStack.clear();
        this.state = 7;
        this.reportAttribs = reportAttributes;
        this.document = (DocumentImpl)node.getOwnerDocument();
        this.origin = node;
    }

    @Override
    public short getNodeType() {
        return Signatures.getType(this.current.data()[this.current.start()]);
    }

    private void initNode() {
        short type = Signatures.getType(this.current.data()[this.current.start()]);
        if (this.state == 7 && type != 1) {
            this.beforeRoot = true;
        }
        switch (type) {
            case 1: {
                this.state = 1;
                this.elementStack.push(new ElementEvent(this.current));
                this.beforeRoot = false;
                break;
            }
            case 2: {
                this.state = 10;
                break;
            }
            case 3: {
                this.state = 4;
                break;
            }
            case 8: {
                this.state = 5;
                break;
            }
            case 4: {
                this.state = 12;
                break;
            }
            case 7: {
                this.state = 3;
            }
        }
        this.reset();
        this.readNodeId();
    }

    private void skipAttributes() throws XMLStreamException {
        if (this.attributes == null) {
            ElementEvent parent = this.elementStack.peek();
            int attrs = this.getAttributeCount();
            for (int i = 0; i < attrs; ++i) {
                this.iterator.next();
                parent.incrementChild();
            }
        }
    }

    private void readAttributes() {
        if (this.attributes == null) {
            ElementEvent parent = this.elementStack.peek();
            int count = this.getAttributeCount();
            this.attributes = new AttrList();
            for (int i = 0; i < count; ++i) {
                Value v = this.iterator.next();
                AttrImpl.addToList(this.broker, v.data(), v.start(), v.getLength(), this.attributes);
                parent.incrementChild();
            }
        }
    }

    private void readNodeId() {
        int offset = this.current.start() + 1;
        if (this.state == 1 || this.state == 2) {
            offset += 4;
        }
        short dlnLen = ByteConversion.byteToShort(this.current.data(), offset);
        this.nodeId = this.broker.getBrokerPool().getNodeFactory().createFromData(dlnLen, this.current.data(), offset += 2);
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.state != 2) {
            this.previous = this.current;
        }
        if (this.state == 1 && !this.reportAttribs) {
            this.skipAttributes();
        }
        if (!this.elementStack.isEmpty()) {
            ElementEvent parent = this.elementStack.peek();
            if (parent.getChildCount() == parent.getCurrentChild()) {
                this.elementStack.pop();
                this.state = 2;
                this.current = parent.data;
                this.reset();
                return this.state;
            }
            parent.incrementChild();
        } else if (this.state != 7 && !this.beforeRoot) {
            throw new NoSuchElementException();
        }
        boolean first = this.state == 7;
        this.current = this.iterator.next();
        this.initNode();
        if (first && this.origin != null) {
            this.verifyOriginNodeId();
            this.origin = null;
        }
        return this.state;
    }

    protected void verifyOriginNodeId() throws XMLStreamException {
        if (!this.nodeId.equals(this.origin.getNodeId())) {
            LOG.warn("expected node id " + this.origin.getNodeId() + ", got " + this.nodeId + "; resyncing address");
            this.origin.setInternalAddress(-1L);
            boolean reportAttribsBackup = this.reportAttribs;
            DocumentImpl documentBackup = this.document;
            try {
                this.iterator.seek(this.origin);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
            this.reset();
            this.previous = null;
            this.elementStack.clear();
            this.reportAttribs = reportAttribsBackup;
            this.document = documentBackup;
            this.current = this.iterator.next();
            this.initNode();
        }
    }

    private void reset() {
        this.nodeId = null;
        this.qname = null;
        this.attributes = null;
        this.text.reuse();
        if (this.state != 2) {
            this.namespaces.clear();
            this.nsRead = false;
        }
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text");
        }
        int eventType = this.next();
        StringBuilder content = new StringBuilder();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content");
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT");
                }
                throw new XMLStreamException("Unexpected event type " + eventType);
            }
            eventType = this.next();
        }
        return content.toString();
    }

    @Override
    public Object getProperty(String string) throws IllegalArgumentException {
        if (string.equals("node-id")) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            return this.nodeId;
        }
        return null;
    }

    @Override
    public int nextTag() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.state == 7 || this.beforeRoot || !this.elementStack.isEmpty();
    }

    @Override
    public void close() throws XMLStreamException {
        this.iterator.close();
    }

    @Override
    public boolean isStartElement() {
        return this.state == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.state == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.state == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        this.readAttributes();
        for (int i = 0; i < this.attributes.getLength(); ++i) {
            org.exist.dom.QName qn = this.attributes.getQName(i);
            if (!qn.getNamespaceURI().equals(namespaceURI) || !qn.getLocalPart().equals(localName)) continue;
            return this.attributes.getValue(i);
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        int offset = this.current.start() + 1 + 4 + 2 + this.nodeId.size();
        return ByteConversion.byteToShort(this.current.data(), offset);
    }

    @Override
    public QName getAttributeName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(index).toJavaQName();
    }

    @Override
    public org.exist.dom.QName getAttributeQName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(index).getNamespaceURI();
    }

    @Override
    public String getAttributeLocalName(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(index).getLocalPart();
    }

    @Override
    public String getAttributePrefix(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getQName(index).getPrefix();
    }

    @Override
    public String getAttributeType(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        int type = this.attributes.getType(index);
        return AttrImpl.getAttributeType(type);
    }

    @Override
    public String getAttributeValue(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getValue(index);
    }

    @Override
    public NodeId getAttributeId(int index) {
        if (this.state != 1) {
            throw new IllegalStateException("Cursor is not at an element");
        }
        this.readAttributes();
        if (index > this.attributes.getLength()) {
            throw new ArrayIndexOutOfBoundsException("index should be < " + this.attributes.getLength());
        }
        return this.attributes.getNodeId(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return false;
    }

    @Override
    public int getNamespaceCount() {
        this.readNamespaceDecls();
        return this.namespaces.size();
    }

    @Override
    public String getNamespacePrefix(int index) {
        this.readNamespaceDecls();
        if (index < 0 || index > this.namespaces.size()) {
            return null;
        }
        String[] decl = this.namespaces.get(index);
        return decl[0];
    }

    @Override
    public String getNamespaceURI(int i) {
        this.readNamespaceDecls();
        if (i < 0 || i > this.namespaces.size()) {
            return null;
        }
        String[] decl = this.namespaces.get(i);
        return decl[1];
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEventType() {
        return this.state;
    }

    @Override
    public XMLString getXMLText() {
        if (this.state == 4 || this.state == 5 || this.state == 12) {
            if (this.text.length() == 0) {
                AbstractCharacterData.readData(this.nodeId, this.current, this.text);
            }
            return this.text;
        }
        return new XMLString();
    }

    @Override
    public String getText() {
        return this.getXMLText().toString();
    }

    @Override
    public char[] getTextCharacters() {
        String s = this.getText();
        char[] dst = new char[s.length()];
        s.getChars(0, dst.length, dst, 0);
        return dst;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] chars, int targetStart, int length) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextStart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTextLength() {
        if (this.state == 4 || this.state == 5 || this.state == 12) {
            if (this.text.length() == 0) {
                return AbstractCharacterData.getStringLength(this.nodeId, this.current);
            }
            return this.text.length();
        }
        return 0;
    }

    @Override
    public String getEncoding() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasText() {
        return this.state == 4 || this.state == 5 || this.state == 12;
    }

    @Override
    public Location getLocation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return null;
    }

    @Override
    public QName getName() {
        if (this.qname != null) {
            return this.qname;
        }
        if (this.state == 1 || this.state == 2) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            this.qname = ElementImpl.readQName(this.current, this.document, this.nodeId).toJavaQName();
        }
        return this.qname;
    }

    @Override
    public org.exist.dom.QName getQName() {
        if (this.state == 1 || this.state == 2) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            return ElementImpl.readQName(this.current, this.document, this.nodeId);
        }
        return null;
    }

    private void readNamespaceDecls() {
        if (this.nsRead) {
            return;
        }
        if (this.state == 1 || this.state == 2) {
            if (this.nodeId == null) {
                this.readNodeId();
            }
            ElementImpl.readNamespaceDecls(this.namespaces, this.current, this.document, this.nodeId);
        }
        this.nsRead = true;
    }

    @Override
    public String getPrefix() {
        return this.getName().getPrefix();
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public String getNamespaceURI() {
        return this.getName().getNamespaceURI();
    }

    @Override
    public boolean hasName() {
        return this.state == 1 || this.state == 2;
    }

    @Override
    public IStoredNode getNode() {
        StoredNode node = StoredNode.deserialize(this.current.data(), this.current.start(), this.current.getLength(), this.document);
        node.setOwnerDocument(this.document);
        node.setInternalAddress(this.current.getAddress());
        return node;
    }

    @Override
    public IStoredNode getPreviousNode() {
        StoredNode node = StoredNode.deserialize(this.previous.data(), this.previous.start(), this.previous.getLength(), this.document);
        node.setOwnerDocument(this.document);
        node.setInternalAddress(this.previous.getAddress());
        return node;
    }

    @Override
    public String getVersion() {
        return "1.0";
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    @Override
    public String getPITarget() {
        this.readPI();
        return this.qname.getLocalPart();
    }

    @Override
    public String getPIData() {
        this.readPI();
        return this.text.toString();
    }

    private void readPI() {
        if (this.qname == null) {
            if (this.state != 3) {
                throw new IllegalStateException("Cursor is not at a processing instruction");
            }
            ProcessingInstruction pi = (ProcessingInstruction)((Object)StoredNode.deserialize(this.current.data(), this.current.start(), this.current.getLength(), this.document));
            this.qname = new QName("", pi.getTarget(), "");
            this.text.append(pi.getData());
        }
    }

    private static final class ElementEvent {
        private final Value data;
        private final int childCount;
        private int currentChild = 0;

        public ElementEvent(Value data) {
            this.data = data;
            this.childCount = ByteConversion.byteToInt(data.data(), data.start() + 1);
        }

        public Value getData() {
            return this.data;
        }

        public int getChildCount() {
            return this.childCount;
        }

        public int getCurrentChild() {
            return this.currentChild;
        }

        public void incrementChild() {
            ++this.currentChild;
        }
    }
}

