/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.util.Configuration;

public class BrokerFactory {
    public static final String PROPERTY_DATABASE = "database";
    private static Class<?>[] constructorArgs = new Class[]{BrokerPool.class, Configuration.class};
    private static Map<String, Class<? extends DBBroker>> objClasses = new HashMap<String, Class<? extends DBBroker>>();

    public static void plug(String id, Class<? extends DBBroker> clazz) {
        objClasses.put(id.toUpperCase(Locale.ENGLISH), clazz);
    }

    public static DBBroker getInstance(BrokerPool database, Configuration conf) throws EXistException {
        String brokerID = (String)conf.getProperty(PROPERTY_DATABASE);
        if (brokerID == null) {
            throw new RuntimeException("no database defined");
        }
        if (!objClasses.containsKey(brokerID = brokerID.toUpperCase(Locale.ENGLISH))) {
            throw new RuntimeException("no database backend found for " + brokerID);
        }
        try {
            Class<? extends DBBroker> clazz = objClasses.get(brokerID);
            Constructor<? extends DBBroker> constructor = clazz.getConstructor(constructorArgs);
            return constructor.newInstance(database, conf);
        }
        catch (Exception e) {
            throw new RuntimeException("can't get database backend " + brokerID, e);
        }
    }

    static {
        BrokerFactory.plug("NATIVE", NativeBroker.class);
    }
}

