/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import com.evolvedbinary.j8fu.function.ConsumerE;
import java.util.Map;
import java.util.Observer;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.GuardedBy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;

abstract class BrokerPools {
    private static final Logger LOG = LogManager.getLogger(BrokerPools.class);
    private static final ReadWriteLock instancesLock = new ReentrantReadWriteLock();
    @GuardedBy(value="instancesLock")
    private static final Map<String, BrokerPool> instances = new TreeMap<String, BrokerPool>();
    public static String DEFAULT_INSTANCE_NAME = "exist";

    BrokerPools() {
    }

    @Deprecated
    public static void configure(int minBrokers, int maxBrokers, Configuration config) throws EXistException, DatabaseConfigurationException {
        BrokerPools.configure(DEFAULT_INSTANCE_NAME, minBrokers, maxBrokers, config);
    }

    public static void configure(int minBrokers, int maxBrokers, Configuration config, Optional<Observer> statusObserver) throws EXistException, DatabaseConfigurationException {
        BrokerPools.configure(DEFAULT_INSTANCE_NAME, minBrokers, maxBrokers, config, statusObserver);
    }

    @Deprecated
    public static void configure(String instanceName, int minBrokers, int maxBrokers, Configuration config) throws EXistException {
        BrokerPools.configure(instanceName, minBrokers, maxBrokers, config, Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(String instanceName, int minBrokers, int maxBrokers, Configuration config, Optional<Observer> statusObserver) throws EXistException {
        Lock readLock = instancesLock.readLock();
        readLock.lock();
        try {
            if (instances.containsKey(instanceName)) {
                LOG.warn("Database instance '" + instanceName + "' is already configured");
                return;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = instancesLock.writeLock();
        writeLock.lock();
        try {
            if (instances.containsKey(instanceName)) {
                LOG.warn("Database instance '" + instanceName + "' is already configured");
                return;
            }
            LOG.debug("Configuring database instance '" + instanceName + "'...");
            try {
                BrokerPool instance = new BrokerPool(instanceName, minBrokers, maxBrokers, config, statusObserver);
                instance.initialize();
                instances.put(instanceName, instance);
            }
            catch (Throwable e) {
                LOG.error("Unable to initialize database instance '" + instanceName + "': " + e.getMessage(), e);
                EXistException ee = e instanceof EXistException ? (EXistException)e : new EXistException(e);
                throw ee;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static boolean isConfigured() {
        return BrokerPools.isConfigured(DEFAULT_INSTANCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isConfigured(String instanceName) {
        Lock readLock = instancesLock.readLock();
        readLock.lock();
        try {
            BrokerPool instance = instances.get(instanceName);
            if (instance == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = instance.isInstanceConfigured();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public static BrokerPool getInstance() throws EXistException {
        return BrokerPools.getInstance(DEFAULT_INSTANCE_NAME);
    }

    public static BrokerPool getInstance(String instanceName) throws EXistException {
        Lock readLock = instancesLock.readLock();
        readLock.lock();
        try {
            BrokerPool instance = instances.get(instanceName);
            if (instance != null) {
                BrokerPool brokerPool = instance;
                return brokerPool;
            }
            throw new EXistException("Database instance '" + instanceName + "' is not available");
        }
        finally {
            readLock.unlock();
        }
    }

    static void removeInstance(String instanceName) {
        Lock writeLock = instancesLock.writeLock();
        writeLock.lock();
        try {
            instances.remove(instanceName);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void readInstances(ConsumerE<BrokerPool, E> reader) throws E {
        Lock readLock = instancesLock.readLock();
        readLock.lock();
        try {
            for (BrokerPool instance : instances.values()) {
                reader.accept((Object)instance);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    static int instancesCount() {
        Lock readLock = instancesLock.readLock();
        readLock.lock();
        try {
            int n = instances.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll(boolean killed) {
        Lock writeLock = instancesLock.writeLock();
        writeLock.lock();
        try {
            for (BrokerPool instance : instances.values()) {
                if (!instance.isInstanceConfigured()) continue;
                instance.shutdown(killed);
            }
            assert (instances.size() == 0);
            instances.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    static {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread("BrokerPools-ShutdownHook"){

                @Override
                public void run() {
                    LOG.info("Executing shutdown thread");
                    BrokerPools.stopAll(true);
                }
            });
            LOG.debug("Shutdown hook registered");
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Shutdown hook already registered");
        }
    }
}

