/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.CollectionCache;
import org.exist.management.Agent;
import org.exist.management.AgentFactory;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.CacheManager;
import org.exist.storage.cache.Cache;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;

public class CollectionCacheManager
implements CacheManager,
BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(CollectionCacheManager.class);
    private static final int DEFAULT_CACHE_SIZE_BYTES = 0x4000000;
    public static final String CACHE_SIZE_ATTRIBUTE = "collectionCache";
    public static final String PROPERTY_CACHE_SIZE_BYTES = "db-connection.collection-cache-mem";
    private final String brokerPoolId;
    private CollectionCache collectionCache;
    private int maxCacheSize;

    public CollectionCacheManager(BrokerPool pool, CollectionCache cache) {
        this.brokerPoolId = pool.getId();
        this.collectionCache = cache;
        this.collectionCache.setCacheManager(this);
    }

    @Override
    public void configure(Configuration configuration) throws BrokerPoolServiceException {
        int cacheSize;
        this.maxCacheSize = cacheSize = Optional.of(configuration.getInteger(PROPERTY_CACHE_SIZE_BYTES)).filter(size -> size > 0).orElse(0x4000000).intValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug("collection collectionCache will be using " + this.maxCacheSize + " bytes max.");
        }
        this.registerMBean(this.brokerPoolId);
    }

    @Override
    public void shutdown() {
        this.deregisterCache(this.collectionCache);
    }

    @Override
    public void registerCache(Cache cache) {
    }

    @Override
    public void deregisterCache(Cache cache) {
        this.collectionCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requestMem(Cache cache) {
        int realSize = this.collectionCache.getRealSize();
        if (realSize < this.maxCacheSize) {
            CollectionCacheManager collectionCacheManager = this;
            synchronized (collectionCacheManager) {
                int newCacheSize = (int)((double)this.collectionCache.getBuffers() * this.collectionCache.getGrowthFactor());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Growing cache {} (a {}) from {} to {} bytes. Current memory usage = {}", (Object)this.collectionCache.getName(), (Object)this.collectionCache.getClass().getName(), (Object)this.collectionCache.getBuffers(), (Object)newCacheSize, (Object)realSize);
                }
                this.collectionCache.resize(newCacheSize);
                return newCacheSize;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache has reached max. size: " + realSize);
        }
        return -1;
    }

    @Override
    public void checkCaches() {
    }

    @Override
    public void checkDistribution() {
    }

    @Override
    public long getMaxTotal() {
        return this.maxCacheSize;
    }

    @Override
    public long getMaxSingle() {
        return this.maxCacheSize;
    }

    @Override
    public long getCurrentSize() {
        return this.collectionCache.getRealSize();
    }

    @Override
    public int getDefaultInitialSize() {
        return 0x4000000;
    }

    private void registerMBean(String instanceName) {
        Agent agent = AgentFactory.getInstance();
        try {
            agent.addMBean(instanceName, "org.exist.management." + instanceName + ":type=CollectionCacheManager", new org.exist.management.CacheManager(this));
        }
        catch (DatabaseConfigurationException e) {
            LOG.warn("Exception while registering cache mbean.", (Throwable)e);
        }
    }
}

