/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Observable;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.Database;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.MutableDocumentSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeProxy;
import org.exist.indexing.IndexController;
import org.exist.indexing.StreamListener;
import org.exist.indexing.StructuralIndex;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.stax.IEmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.ElementIndex;
import org.exist.storage.IndexSpec;
import org.exist.storage.NativeValueIndex;
import org.exist.storage.NodePath;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.dom.INodeIterator;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.util.TraceableStateChange;
import org.exist.util.TraceableStateChanges;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.TerminatedException;
import org.w3c.dom.Document;

public abstract class DBBroker
extends Observable
implements AutoCloseable {
    public static final int MATCH_EXACT = 0;
    public static final int MATCH_REGEXP = 1;
    public static final int MATCH_WILDCARDS = 2;
    public static final int MATCH_CONTAINS = 3;
    public static final int MATCH_STARTSWITH = 4;
    public static final int MATCH_ENDSWITH = 5;
    public static final String CONFIGURATION_ELEMENT_NAME = "xupdate";
    public static final String XUPDATE_FRAGMENTATION_FACTOR_ATTRIBUTE = "allowed-fragmentation";
    public static final String PROPERTY_XUPDATE_FRAGMENTATION_FACTOR = "xupdate.fragmentation";
    public static final String XUPDATE_CONSISTENCY_CHECKS_ATTRIBUTE = "enable-consistency-checks";
    public static final String PROPERTY_XUPDATE_CONSISTENCY_CHECKS = "xupdate.consistency-checks";
    protected static final Logger LOG = LogManager.getLogger(DBBroker.class);
    protected boolean caseSensitive = true;
    protected Configuration config;
    protected BrokerPool pool;
    private Deque<Subject> subject = new ArrayDeque<Subject>();
    private TraceableStateChanges<Subject, TraceableSubjectChange.Change> subjectChangeTrace = LOG.isTraceEnabled() ? new TraceableStateChanges() : null;
    private int referenceCount = 0;
    protected String id;
    protected IndexController indexController;
    protected List<ContentLoadingObserver> contentLoadingObservers = new ArrayList<ContentLoadingObserver>();

    public DBBroker(BrokerPool pool, Configuration config) {
        this.config = config;
        Boolean temp = (Boolean)config.getProperty("indexer.case-sensitive");
        if (temp != null) {
            this.caseSensitive = temp;
        }
        this.pool = pool;
        this.initIndexModules();
    }

    public void initIndexModules() {
        this.indexController = new IndexController(this);
    }

    public void pushSubject(Subject subject) {
        if (LOG.isTraceEnabled()) {
            this.subjectChangeTrace.add(TraceableSubjectChange.push(subject, this.getId()));
        }
        this.subject.addFirst(subject);
    }

    public Subject popSubject() {
        Subject subject = this.subject.removeFirst();
        if (LOG.isTraceEnabled()) {
            this.subjectChangeTrace.add(TraceableSubjectChange.pop(subject, this.getId()));
        }
        return subject;
    }

    public Subject getCurrentSubject() {
        return this.subject.peekFirst();
    }

    public void traceSubjectChanges() {
        this.subjectChangeTrace.logTrace(LOG);
    }

    public void clearSubjectChangesTrace() {
        if (!LOG.isTraceEnabled()) {
            throw new IllegalStateException("This is only enabled at TRACE level logging");
        }
        this.subjectChangeTrace.clear();
    }

    public IndexController getIndexController() {
        return this.indexController;
    }

    public abstract ElementIndex getElementIndex();

    public abstract StructuralIndex getStructuralIndex();

    public void flush() {
    }

    public void clearContentLoadingObservers() {
        this.contentLoadingObservers.clear();
    }

    public void addContentLoadingObserver(ContentLoadingObserver observer) {
        if (!this.contentLoadingObservers.contains(observer)) {
            this.contentLoadingObservers.add(observer);
        }
    }

    public void removeContentLoadingObserver(ContentLoadingObserver observer) {
        if (this.contentLoadingObservers.contains(observer)) {
            this.contentLoadingObservers.remove(observer);
        }
    }

    public abstract MutableDocumentSet getAllXMLResources(MutableDocumentSet var1) throws PermissionDeniedException;

    public abstract void getResourcesFailsafe(BTreeCallback var1, boolean var2) throws TerminatedException;

    public abstract void getCollectionsFailsafe(BTreeCallback var1) throws TerminatedException;

    public abstract Collection getCollection(XmldbURI var1) throws PermissionDeniedException;

    public abstract Collection openCollection(XmldbURI var1, Lock.LockMode var2) throws PermissionDeniedException;

    public abstract List<String> findCollectionsMatching(String var1);

    public abstract Collection getOrCreateCollection(Txn var1, XmldbURI var2) throws PermissionDeniedException, IOException, TriggerException;

    public Configuration getConfiguration() {
        return this.config;
    }

    public INodeIterator getNodeIterator(NodeHandle node) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public abstract Document getXMLResource(XmldbURI var1) throws PermissionDeniedException;

    public abstract DocumentImpl getResource(XmldbURI var1, int var2) throws PermissionDeniedException;

    public abstract DocumentImpl getResourceById(int var1, byte var2, int var3) throws PermissionDeniedException;

    public abstract DocumentImpl getXMLResource(XmldbURI var1, Lock.LockMode var2) throws PermissionDeniedException;

    public abstract int getNextResourceId(Txn var1, Collection var2) throws EXistException;

    public String getNodeValue(IStoredNode node, boolean addWhitespace) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public abstract Serializer getSerializer();

    public abstract NativeValueIndex getValueIndex();

    public abstract Serializer newSerializer();

    public abstract Serializer newSerializer(List<String> var1);

    public abstract IStoredNode objectWith(Document var1, NodeId var2);

    public abstract IStoredNode objectWith(NodeProxy var1);

    public abstract boolean removeCollection(Txn var1, Collection var2) throws PermissionDeniedException, IOException, TriggerException;

    public abstract void removeResource(Txn var1, DocumentImpl var2) throws IOException, PermissionDeniedException;

    public void removeXMLResource(Txn transaction, DocumentImpl document) throws PermissionDeniedException, IOException {
        this.removeXMLResource(transaction, document, true);
    }

    public abstract void removeXMLResource(Txn var1, DocumentImpl var2, boolean var3) throws PermissionDeniedException, IOException;

    public abstract void reindexCollection(XmldbURI var1) throws PermissionDeniedException, IOException;

    public abstract void reindexXMLResource(Txn var1, DocumentImpl var2);

    public abstract void reindexXMLResource(Txn var1, DocumentImpl var2, IndexMode var3);

    public abstract void repair() throws PermissionDeniedException, IOException;

    public abstract void repairPrimary();

    public abstract void saveCollection(Txn var1, Collection var2) throws PermissionDeniedException, IOException, TriggerException;

    public void closeDocument() {
    }

    public void shutdown() {
    }

    public abstract <T extends IStoredNode> void storeNode(Txn var1, IStoredNode<T> var2, NodePath var3, IndexSpec var4);

    public <T extends IStoredNode> void endElement(IStoredNode<T> node, NodePath currentPath, String content) {
        this.endElement(node, currentPath, content, false);
    }

    public abstract <T extends IStoredNode> void endElement(IStoredNode<T> var1, NodePath var2, String var3, boolean var4);

    public abstract void storeXMLResource(Txn var1, DocumentImpl var2);

    public abstract void storeMetadata(Txn var1, DocumentImpl var2) throws TriggerException;

    @Deprecated
    public abstract void storeBinaryResource(Txn var1, BinaryDocument var2, byte[] var3) throws IOException;

    public abstract void storeBinaryResource(Txn var1, BinaryDocument var2, InputStream var3) throws IOException;

    public abstract void getCollectionResources(Collection.InternalAccess var1);

    public abstract void readBinaryResource(BinaryDocument var1, OutputStream var2) throws IOException;

    public abstract Path getBinaryFile(BinaryDocument var1) throws IOException;

    public abstract InputStream getBinaryResource(BinaryDocument var1) throws IOException;

    public abstract long getBinaryResourceSize(BinaryDocument var1) throws IOException;

    public abstract void removeBinaryResource(Txn var1, BinaryDocument var2) throws PermissionDeniedException, IOException;

    public abstract void moveCollection(Txn var1, Collection var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, IOException, TriggerException;

    public abstract void moveResource(Txn var1, DocumentImpl var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, IOException, TriggerException;

    public abstract void copyCollection(Txn var1, Collection var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, IOException, TriggerException, EXistException;

    public abstract void copyResource(Txn var1, DocumentImpl var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, EXistException, IOException;

    public abstract void defragXMLResource(Txn var1, DocumentImpl var2);

    public abstract void checkXMLResourceTree(DocumentImpl var1);

    public abstract void checkXMLResourceConsistency(DocumentImpl var1) throws EXistException;

    public abstract void sync(Sync var1);

    public abstract <T extends IStoredNode> void updateNode(Txn var1, IStoredNode<T> var2, boolean var3);

    public boolean isReadOnly() {
        return false;
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    public Database getDatabase() {
        return this.pool;
    }

    public abstract void insertNodeAfter(Txn var1, NodeHandle var2, IStoredNode var3);

    public abstract void indexNode(Txn var1, IStoredNode var2, NodePath var3);

    public void indexNode(Txn transaction, IStoredNode node) {
        this.indexNode(transaction, node, null);
    }

    public abstract <T extends IStoredNode> void removeNode(Txn var1, IStoredNode<T> var2, NodePath var3, String var4);

    public abstract void removeAllNodes(Txn var1, IStoredNode var2, NodePath var3, StreamListener var4);

    public abstract void endRemove(Txn var1);

    public abstract DocumentImpl storeTempResource(org.exist.dom.memtree.DocumentImpl var1) throws EXistException, PermissionDeniedException, LockException;

    public abstract void cleanUpTempResources(boolean var1) throws PermissionDeniedException;

    public abstract void checkAvailableMemory();

    public abstract MutableDocumentSet getXMLResourcesByDoctype(String var1, MutableDocumentSet var2) throws PermissionDeniedException;

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void incReferenceCount() {
        ++this.referenceCount;
    }

    public void decReferenceCount() {
        --this.referenceCount;
    }

    public abstract IndexSpec getIndexConfiguration();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public abstract IEmbeddedXMLStreamReader getXMLStreamReader(NodeHandle var1, boolean var2) throws IOException, XMLStreamException;

    public abstract IEmbeddedXMLStreamReader newXMLStreamReader(NodeHandle var1, boolean var2) throws IOException, XMLStreamException;

    public abstract void backupToArchive(RawDataBackup var1) throws IOException, EXistException;

    public abstract void readCollectionEntry(Collection.SubCollectionEntry var1);

    @Override
    public void close() {
        this.pool.release(this);
    }

    @Deprecated
    public void release() {
        this.pool.release(this);
    }

    private static class TraceableSubjectChange
    extends TraceableStateChange<Subject, Change> {
        private final String id;

        private TraceableSubjectChange(Change change, Subject subject, String id) {
            super(change, subject);
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String describeState() {
            return ((Subject)this.getState()).getName();
        }

        static final TraceableSubjectChange push(Subject subject, String id) {
            return new TraceableSubjectChange(Change.PUSH, subject, id);
        }

        static final TraceableSubjectChange pop(Subject subject, String id) {
            return new TraceableSubjectChange(Change.POP, subject, id);
        }

        public static enum Change {
            PUSH,
            POP;

        }
    }

    public static enum IndexMode {
        STORE,
        REPAIR,
        REMOVE;

    }
}

