/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Optional;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;

public class DataBackup
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(DataBackup.class);
    public static final String DATE_FORMAT_PICTURE = "yyyyMMddHHmmssS";
    private final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyyMMddHHmmssS");
    private Path dest;
    private Optional<Path> lastBackup = Optional.empty();

    public DataBackup() {
    }

    public DataBackup(Path destination) {
        this.dest = destination;
    }

    @Override
    public boolean afterCheckpoint() {
        return true;
    }

    @Override
    public String getName() {
        return "Data Backup Task";
    }

    @Override
    public void configure(Configuration config, Properties properties) throws EXistException {
        this.dest = Paths.get(properties.getProperty("output-dir", "backup"), new String[0]);
        if (!this.dest.isAbsolute()) {
            this.dest = ((Path)config.getProperty("db-connection.data-dir")).resolve(this.dest);
        }
        if (!(!Files.exists(this.dest, new LinkOption[0]) || Files.isWritable(this.dest) && Files.isDirectory(this.dest, new LinkOption[0]))) {
            throw new EXistException("Cannot write backup files to " + this.dest.toAbsolutePath().toString() + ". It should be a writable directory.");
        }
        try {
            Files.createDirectories(this.dest, new FileAttribute[0]);
        }
        catch (IOException ioe) {
            throw new EXistException("Unable to create directory: " + this.dest.toAbsolutePath().toString(), ioe);
        }
        LOG.debug("Setting backup data directory: " + this.dest);
    }

    @Override
    public void execute(DBBroker broker) throws EXistException {
        if (!(broker instanceof NativeBroker)) {
            throw new EXistException("DataBackup system task can only be used with the native storage backend");
        }
        LOG.debug("Backing up data files ...");
        String creationDate = this.creationDateFormat.format(Calendar.getInstance().getTime());
        Path outFilename = this.dest.resolve(creationDate + ".zip");
        this.lastBackup = Optional.of(outFilename);
        LOG.debug("Archiving data files into: " + outFilename);
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(outFilename, new OpenOption[0]));){
            out.setLevel(0);
            Callback cb = new Callback(out);
            broker.backupToArchive(cb);
        }
        catch (IOException e) {
            LOG.error("An IO error occurred while backing up data files: " + e.getMessage(), (Throwable)e);
        }
    }

    public Optional<Path> getLastBackup() {
        return this.lastBackup;
    }

    private static class Callback
    implements RawDataBackup {
        private final ZipOutputStream zout;

        private Callback(ZipOutputStream out) {
            this.zout = out;
        }

        @Override
        public OutputStream newEntry(String name) throws IOException {
            this.zout.putNextEntry(new ZipEntry(name));
            return this.zout;
        }

        @Override
        public void closeEntry() throws IOException {
            this.zout.closeEntry();
        }
    }
}

