/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.ArrayList;
import java.util.Observable;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ExtNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.Occurrences;
import org.exist.xquery.NodeSelector;

public abstract class ElementIndex
extends Observable {
    protected static final Logger LOG = LogManager.getLogger((String)ElementIndex.class.getName());
    protected DBBroker broker;
    protected TreeMap<QName, ArrayList<NodeProxy>> pending = new TreeMap();
    protected DocumentImpl doc;
    protected boolean inUpdateMode = false;

    public ElementIndex(DBBroker broker) {
        this.broker = broker;
    }

    public void setDocument(DocumentImpl doc) {
        if (this.pending.size() > 0 && this.doc.getDocId() != doc.getDocId()) {
            LOG.error("Document changed but pending had " + this.pending.size(), new Throwable());
            this.pending.clear();
        }
        this.doc = doc;
    }

    public void setInUpdateMode(boolean update) {
        this.inUpdateMode = update;
    }

    public abstract NodeSet findElementsByTagName(byte var1, DocumentSet var2, QName var3, NodeSelector var4);

    public abstract NodeSet findDescendantsByTagName(byte var1, QName var2, int var3, DocumentSet var4, ExtNodeSet var5, int var6);

    public abstract Occurrences[] scanIndexedElements(Collection var1, boolean var2) throws PermissionDeniedException;

    public abstract boolean matchElementsByTagName(byte var1, DocumentSet var2, QName var3, NodeSelector var4);

    public abstract boolean matchDescendantsByTagName(byte var1, QName var2, int var3, DocumentSet var4, ExtNodeSet var5, int var6);
}

