/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.exist.dom.QName;
import org.exist.dom.TypedQNameComparator;
import org.exist.storage.DBBroker;
import org.exist.storage.GeneralRangeIndexSpec;
import org.exist.storage.NodePath;
import org.exist.storage.QNameRangeIndexSpec;
import org.exist.util.DatabaseConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IndexSpec {
    private static final String TYPE_ATTRIB = "type";
    private static final String PATH_ATTRIB = "path";
    private static final String CREATE_ELEMENT = "create";
    private static final String QNAME_ATTRIB = "qname";
    private GeneralRangeIndexSpec[] specs = null;
    private Map<QName, QNameRangeIndexSpec> qnameSpecs = new TreeMap<QName, QNameRangeIndexSpec>(new TypedQNameComparator());
    private Map<String, Object> customIndexSpecs = null;

    public IndexSpec(DBBroker broker, Element index) throws DatabaseConfigurationException {
        this.read(broker, index);
    }

    public void read(DBBroker broker, Element index) throws DatabaseConfigurationException {
        Map<String, String> namespaces = this.getNamespaceMap(index);
        NodeList childNodes = index.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !CREATE_ELEMENT.equals(node.getLocalName())) continue;
            Element elem = (Element)node;
            String type = elem.getAttribute(TYPE_ATTRIB);
            if (elem.hasAttribute(QNAME_ATTRIB)) {
                String qname = elem.getAttribute(QNAME_ATTRIB);
                QNameRangeIndexSpec qnIdx = new QNameRangeIndexSpec(namespaces, qname, type);
                this.qnameSpecs.put(qnIdx.getQName(), qnIdx);
                continue;
            }
            if (elem.hasAttribute(PATH_ATTRIB)) {
                String path = elem.getAttribute(PATH_ATTRIB);
                GeneralRangeIndexSpec valueIdx = new GeneralRangeIndexSpec(namespaces, path, type);
                this.addValueIndex(valueIdx);
                continue;
            }
            String error_message = "Configuration error: element " + elem.getNodeName() + " must have attribute " + PATH_ATTRIB + " or " + QNAME_ATTRIB;
            throw new DatabaseConfigurationException(error_message);
        }
        if (broker != null) {
            this.customIndexSpecs = broker.getIndexController().configure(childNodes, namespaces);
        }
    }

    public Object getCustomIndexSpec(String id) {
        return this.customIndexSpecs == null ? null : this.customIndexSpecs.get(id);
    }

    public GeneralRangeIndexSpec getIndexByPath(NodePath path) {
        if (this.specs != null) {
            for (GeneralRangeIndexSpec spec : this.specs) {
                if (!spec.matches(path)) continue;
                return spec;
            }
        }
        return null;
    }

    public QNameRangeIndexSpec getIndexByQName(QName name) {
        return this.qnameSpecs.get(name);
    }

    public boolean hasIndexesByPath() {
        return this.specs != null && this.specs.length > 0;
    }

    public boolean hasIndexesByQName() {
        return this.qnameSpecs.size() > 0;
    }

    public List<QName> getIndexedQNames() {
        return this.qnameSpecs.keySet().stream().collect(Collectors.toList());
    }

    private void addValueIndex(GeneralRangeIndexSpec valueIdx) {
        if (this.specs == null) {
            this.specs = new GeneralRangeIndexSpec[1];
            this.specs[0] = valueIdx;
        } else {
            GeneralRangeIndexSpec[] nspecs = new GeneralRangeIndexSpec[this.specs.length + 1];
            System.arraycopy(this.specs, 0, nspecs, 0, this.specs.length);
            nspecs[this.specs.length] = valueIdx;
            this.specs = nspecs;
        }
    }

    private Map<String, String> getNamespaceMap(Element elem) {
        Node parent = elem.getParentNode();
        if (parent != null) {
            elem = (Element)parent;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.getNamespaceMap(elem, map);
        return map;
    }

    private void getNamespaceMap(Element elem, Map<String, String> map) {
        NamedNodeMap attrs = elem.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getPrefix() == null || !"xmlns".equals(attr.getPrefix()) || attr.getValue().equals("http://exist-db.org/collection-config/1.0")) continue;
            map.put(attr.getLocalName(), attr.getValue());
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.getNamespaceMap((Element)child, map);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.specs != null) {
            for (GeneralRangeIndexSpec spec : this.specs) {
                if (spec == null) continue;
                result.append(spec.toString()).append('\n');
            }
        }
        for (Map.Entry entry : this.qnameSpecs.entrySet()) {
            result.append(((QNameRangeIndexSpec)entry.getValue()).toString()).append('\n');
        }
        return result.toString();
    }
}

