/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.FastStringBuffer;

public class NodePath
implements Comparable<NodePath> {
    private static final Logger LOG = LogManager.getLogger(NodePath.class);
    public static final QName SKIP = new QName("//", "");
    public static final QName WILDCARD = new QName("*", "");
    private QName[] components = new QName[5];
    private int pos = 0;
    private boolean includeDescendants = true;

    public NodePath() {
    }

    public NodePath(NodePath other) {
        this(other, other.includeDescendants);
    }

    public NodePath(NodePath other, boolean includeDescendants) {
        this.components = new QName[other.components.length];
        System.arraycopy(other.components, 0, this.components, 0, other.components.length);
        this.pos = other.pos;
        this.includeDescendants = includeDescendants;
    }

    public NodePath(Map<String, String> namespaces, String path) {
        this.init(namespaces, path);
    }

    public NodePath(Map<String, String> namespaces, String path, boolean includeDescendants) {
        this.includeDescendants = includeDescendants;
        this.init(namespaces, path);
    }

    public NodePath(QName qname) {
        this.addComponent(qname);
    }

    public void setIncludeDescendants(boolean includeDescendants) {
        this.includeDescendants = includeDescendants;
    }

    public void append(NodePath other) {
        QName[] newComponents = new QName[this.length() + other.length()];
        System.arraycopy(this.components, 0, newComponents, 0, this.pos);
        System.arraycopy(other.components, 0, newComponents, this.pos, other.length());
        this.pos = newComponents.length;
        this.components = newComponents;
    }

    public void addComponent(QName component) {
        if (this.pos == this.components.length) {
            QName[] t = new QName[this.pos + 1];
            System.arraycopy(this.components, 0, t, 0, this.pos);
            this.components = t;
        }
        this.components[this.pos++] = component;
    }

    public void addComponentAtStart(QName component) {
        if (this.pos == this.components.length) {
            QName[] t = new QName[this.pos + 1];
            System.arraycopy(this.components, 0, t, 1, this.pos);
            this.components = t;
            this.components[0] = component;
        } else {
            System.arraycopy(this.components, 0, this.components, 1, this.pos);
            this.components[0] = component;
        }
        ++this.pos;
    }

    public void removeLastComponent() {
        if (this.pos > 0) {
            this.components[--this.pos] = null;
        }
    }

    public int length() {
        return this.pos;
    }

    public QName getComponent(int at) {
        if (at < 0 || at >= this.pos) {
            throw new ArrayIndexOutOfBoundsException(at);
        }
        return this.components[at];
    }

    public QName getLastComponent() {
        if (this.pos > 0) {
            return this.components[this.pos - 1];
        }
        return null;
    }

    public boolean hasWildcard() {
        for (int i = 0; i < this.pos; ++i) {
            if (this.components[i] != WILDCARD) continue;
            return true;
        }
        return false;
    }

    public boolean match(QName qname) {
        if (this.pos > 0) {
            return this.components[this.pos - 1].equals(qname);
        }
        return false;
    }

    public final boolean match(NodePath other) {
        return this.match(other, 0);
    }

    public final boolean match(NodePath other, int j) {
        boolean skip = false;
        int i = 0;
        while (j < other.pos) {
            if (i == this.pos) {
                if (this.includeDescendants) {
                    return true;
                }
                return j == other.pos;
            }
            if (this.components[i] == SKIP) {
                ++i;
                skip = true;
            }
            if (!(this.components[i] != WILDCARD && other.components[j].compareTo(this.components[i]) != 0 || skip && j + 1 != other.pos && other.components[j + 1].compareTo(this.components[i]) == 0)) {
                ++i;
                skip = false;
            } else if (!skip) {
                return false;
            }
            ++j;
        }
        if (i == this.pos) {
            if (this.includeDescendants) {
                return true;
            }
            return j == other.pos;
        }
        return false;
    }

    public void reset() {
        for (int i = 0; i < this.pos; ++i) {
            this.components[i] = null;
        }
        this.pos = 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.pos; ++i) {
            buf.append("/");
            if (this.components[i].getNameType() == 1) {
                buf.append("@");
            }
            buf.append(this.components[i]);
        }
        return buf.toString();
    }

    private void addComponent(Map<String, String> namespaces, String component) {
        boolean isAttribute = false;
        if (component.startsWith("@")) {
            isAttribute = true;
            component = component.substring(1);
        }
        try {
            String prefix = QName.extractPrefix(component);
            String localName = QName.extractLocalName(component);
            String namespaceURI = null;
            if (prefix != null) {
                namespaceURI = namespaces.get(prefix);
                if (namespaceURI == null) {
                    LOG.error("No namespace URI defined for prefix: " + prefix);
                    prefix = null;
                    namespaceURI = "";
                }
            } else if (namespaces != null) {
                namespaceURI = namespaces.get("");
            }
            QName qn = isAttribute ? new QName(localName, namespaceURI, prefix, 1) : new QName(localName, namespaceURI, prefix);
            LOG.debug("URI = " + qn.getNamespaceURI());
            this.addComponent(qn);
        }
        catch (QName.IllegalQNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void init(Map<String, String> namespaces, String path) {
        FastStringBuffer token = new FastStringBuffer(path.length());
        int pos = 0;
        block4: while (pos < path.length()) {
            char ch = path.charAt(pos);
            switch (ch) {
                case '*': {
                    this.addComponent(WILDCARD);
                    token.setLength(0);
                    ++pos;
                    continue block4;
                }
                case '/': {
                    String next = token.toString();
                    token.setLength(0);
                    if (next.length() > 0) {
                        this.addComponent(namespaces, next);
                    }
                    if (path.charAt(++pos) != '/') continue block4;
                    this.addComponent(SKIP);
                    continue block4;
                }
            }
            token.append(ch);
            ++pos;
        }
        if (token.length() > 0) {
            this.addComponent(namespaces, token.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof NodePath) {
            NodePath nodePath = (NodePath)obj;
            if (nodePath.pos == this.pos) {
                for (int i = 0; i < this.pos; ++i) {
                    if (nodePath.components[i].equals(this.components[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.pos; ++i) {
            h = 31 * h + this.components[i].hashCode();
        }
        return h;
    }

    @Override
    public int compareTo(NodePath other) {
        return this.toString().compareTo(other.toString());
    }
}

