/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.http.servlets.RequestWrapper;
import org.exist.source.Source;
import org.exist.storage.BrokerPoolService;
import org.exist.util.Configuration;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryWatchDog;
import org.exist.xquery.functions.request.RequestModule;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.JavaObjectValue;

public class ProcessMonitor
implements BrokerPoolService {
    public static final String ACTION_UNSPECIFIED = "unspecified";
    public static final String ACTION_VALIDATE_DOC = "validating document";
    public static final String ACTION_STORE_DOC = "storing document";
    public static final String ACTION_STORE_BINARY = "storing binary resource";
    public static final String ACTION_REMOVE_XML = "remove XML resource";
    public static final String ACTION_REMOVE_BINARY = "remove binary resource";
    public static final String ACTION_REMOVE_COLLECTION = "remove collection";
    public static final String ACTION_REINDEX_COLLECTION = "reindex collection";
    public static final String ACTION_COPY_COLLECTION = "copy collection";
    public static final String ACTION_MOVE_COLLECTION = "move collection";
    public static final String ACTION_BACKUP = "backup";
    private static final Logger LOG = LogManager.getLogger(ProcessMonitor.class);
    public static final long QUERY_HISTORY_TIMEOUT = 120000L;
    public static final long MIN_TIME = 100L;
    private final Set<XQueryWatchDog> runningQueries = new HashSet<XQueryWatchDog>();
    private final DelayQueue<QueryHistory> history = new DelayQueue();
    private Map<Thread, JobInfo> processes = new HashMap<Thread, JobInfo>();
    private long maxShutdownWait;
    private long historyTimespan = 120000L;
    private long minTime = 100L;
    private boolean trackRequests = false;

    @Override
    public void configure(Configuration configuration) {
        this.maxShutdownWait = configuration.getProperty("wait-before-shutdown", 45000L);
    }

    public void startJob(String action) {
        this.startJob(action, null);
    }

    public void startJob(String action, Object addInfo) {
        this.startJob(action, addInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startJob(String action, Object addInfo, Monitor monitor) {
        JobInfo info = new JobInfo(action, monitor);
        info.setAddInfo(addInfo);
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            this.processes.put(info.getThread(), info);
        }
    }

    public synchronized void endJob() {
        this.processes.remove(Thread.currentThread());
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo[] runningJobs() {
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            JobInfo[] jobs = new JobInfo[this.processes.size()];
            int j = 0;
            Iterator<JobInfo> i = this.processes.values().iterator();
            while (i.hasNext()) {
                jobs[j] = i.next();
                ++j;
            }
            return jobs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunningJobs() {
        long waitStart = System.currentTimeMillis();
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            if (this.maxShutdownWait > -1L) {
                while (this.processes.size() > 0) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.maxShutdownWait <= -1L || System.currentTimeMillis() - waitStart <= this.maxShutdownWait) continue;
                }
            }
            for (JobInfo job : this.processes.values()) {
                job.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryStarted(XQueryWatchDog watchdog) {
        Set<XQueryWatchDog> set = this.runningQueries;
        synchronized (set) {
            watchdog.setRunningThread(Thread.currentThread().getName());
            this.runningQueries.add(watchdog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryCompleted(XQueryWatchDog watchdog) {
        boolean found;
        Set<XQueryWatchDog> set = this.runningQueries;
        synchronized (set) {
            found = this.runningQueries.remove(watchdog);
        }
        long elapsed = System.currentTimeMillis() - watchdog.getStartTime();
        if (found && elapsed > this.minTime) {
            DelayQueue<QueryHistory> delayQueue = this.history;
            synchronized (delayQueue) {
                Source source = watchdog.getContext().getSource();
                String sourceKey = source == null ? "unknown" : source.path();
                QueryHistory qh = new QueryHistory(sourceKey, this.historyTimespan);
                qh.setMostRecentExecutionTime(watchdog.getStartTime());
                qh.setMostRecentExecutionDuration(elapsed);
                qh.incrementInvocationCount();
                if (this.trackRequests) {
                    qh.setRequestURI(ProcessMonitor.getRequestURI(watchdog));
                }
                this.history.add(qh);
                this.cleanHistory();
            }
        }
    }

    private void cleanHistory() {
        while (this.history.poll() != null) {
        }
    }

    public void setHistoryTimespan(long time) {
        this.historyTimespan = time;
    }

    public long getHistoryTimespan() {
        return this.historyTimespan;
    }

    public void setMinTime(long time) {
        this.minTime = time;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setTrackRequestURI(boolean track) {
        this.trackRequests = track;
    }

    public boolean getTrackRequestURI() {
        return this.trackRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHistory[] getRecentQueryHistory() {
        DelayQueue<QueryHistory> delayQueue = this.history;
        synchronized (delayQueue) {
            this.cleanHistory();
            return (QueryHistory[])this.history.stream().sorted((o1, o2) -> ((QueryHistory)o1).expires > ((QueryHistory)o2).expires ? -1 : (((QueryHistory)o1).expires < ((QueryHistory)o2).expires ? 1 : 0)).toArray(QueryHistory[]::new);
        }
    }

    public void killAll(long waitTime) {
        for (XQueryWatchDog watchdog : this.runningQueries) {
            LOG.debug("Killing query: " + ExpressionDumper.dump(watchdog.getContext().getRootExpression()));
            watchdog.kill(waitTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XQueryWatchDog[] getRunningXQueries() {
        Set<XQueryWatchDog> set = this.runningQueries;
        synchronized (set) {
            return (XQueryWatchDog[])this.runningQueries.stream().toArray(XQueryWatchDog[]::new);
        }
    }

    public static String getRequestURI(XQueryWatchDog watchdog) {
        RequestModule reqModule = (RequestModule)watchdog.getContext().getModule("http://exist-db.org/xquery/request");
        if (reqModule == null) {
            return null;
        }
        try {
            Variable var = reqModule.resolveVariable(RequestModule.REQUEST_VAR);
            if (var == null || var.getValue() == null) {
                return null;
            }
            if (var.getValue().getItemType() != 100) {
                return null;
            }
            JavaObjectValue value = (JavaObjectValue)var.getValue().itemAt(0);
            if (value.getObject() instanceof RequestWrapper) {
                RequestWrapper wrapper = (RequestWrapper)value.getObject();
                Object attr = wrapper.getAttribute("org.exist.forward.request-uri");
                String uri = attr == null ? wrapper.getRequestURI() : attr.toString();
                String queryString = wrapper.getQueryString();
                if (queryString != null) {
                    uri = uri + "?" + queryString;
                }
                return uri;
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return null;
    }

    public static final class JobInfo {
        private Thread thread = Thread.currentThread();
        private String action;
        private long startTime;
        private Object addInfo = null;
        private Monitor monitor = null;

        public JobInfo(String action, Monitor monitor) {
            this.action = action;
            this.monitor = monitor;
            this.startTime = System.currentTimeMillis();
        }

        public String getAction() {
            return this.action;
        }

        public Thread getThread() {
            return this.thread;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setAddInfo(Object info) {
            this.addInfo = info;
        }

        public Object getAddInfo() {
            return this.addInfo;
        }

        public void stop() {
            if (this.monitor != null) {
                this.monitor.stop();
            }
        }
    }

    public static final class Monitor {
        boolean stop = false;

        public boolean proceed() {
            return !this.stop;
        }

        public void stop() {
            LOG.debug("Terminating job");
            this.stop = true;
        }
    }

    public static class QueryHistory
    implements Delayed {
        private final String source;
        private String requestURI = null;
        private long mostRecentExecutionTime;
        private long mostRecentExecutionDuration;
        private int invocationCount = 0;
        private long expires;

        public QueryHistory(String source, long delay) {
            this.source = source;
            this.expires = System.currentTimeMillis() + delay;
        }

        public String getSource() {
            return this.source;
        }

        public void incrementInvocationCount() {
            ++this.invocationCount;
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public long getMostRecentExecutionTime() {
            return this.mostRecentExecutionTime;
        }

        public void setMostRecentExecutionTime(long mostRecentExecutionTime) {
            this.mostRecentExecutionTime = mostRecentExecutionTime;
        }

        public long getMostRecentExecutionDuration() {
            return this.mostRecentExecutionDuration;
        }

        public void setMostRecentExecutionDuration(long mostRecentExecutionDuration) {
            this.mostRecentExecutionDuration = mostRecentExecutionDuration;
        }

        public String getRequestURI() {
            return this.requestURI;
        }

        public void setRequestURI(String uri) {
            this.requestURI = uri;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expires - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (this.expires < ((QueryHistory)o).expires) {
                return -1;
            }
            if (this.expires > ((QueryHistory)o).expires) {
                return 1;
            }
            return 0;
        }
    }
}

