/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.plugin.PluginsManagerImpl;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.DBBroker;
import org.exist.storage.StartupTrigger;
import org.exist.util.Configuration;

public class StartupTriggersManager
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(PluginsManagerImpl.class);
    private final List<Configuration.StartupTriggerConfig> startupTriggerConfigs = new ArrayList<Configuration.StartupTriggerConfig>();

    @Override
    public void configure(Configuration configuration) throws BrokerPoolServiceException {
        List startupTriggerConfigs = (List)configuration.getProperty("startup.triggers");
        if (startupTriggerConfigs != null) {
            this.startupTriggerConfigs.addAll(startupTriggerConfigs);
        }
    }

    @Override
    public void startPreMultiUserSystem(DBBroker systemBroker) throws BrokerPoolServiceException {
        for (Configuration.StartupTriggerConfig startupTriggerConfig : this.startupTriggerConfigs) {
            try {
                Class<?> clazz = Class.forName(startupTriggerConfig.getClazz());
                StartupTrigger startupTrigger = (StartupTrigger)clazz.newInstance();
                startupTrigger.execute(systemBroker, startupTriggerConfig.getParams());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOG.error("Could not call StartupTrigger class: " + startupTriggerConfig + ". SKIPPING! " + e.getMessage(), (Throwable)e);
            }
            catch (RuntimeException re) {
                LOG.warn("StartupTrigger threw RuntimeException: " + re.getMessage() + ". IGNORING!", (Throwable)re);
            }
        }
    }
}

