/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.text.NumberFormat;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.PermissionDeniedException;
import org.exist.source.Source;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.xquery.CompiledXQuery;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;

@ThreadSafe
public class XQueryPool
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(XQueryPool.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "query-pool";
    public static final String MAX_STACK_SIZE_ATTRIBUTE = "max-stack-size";
    public static final String POOL_SIZE_ATTTRIBUTE = "size";
    public static final String TIMEOUT_ATTRIBUTE = "timeout";
    public static final String PROPERTY_MAX_STACK_SIZE = "db-connection.query-pool.max-stack-size";
    public static final String PROPERTY_POOL_SIZE = "db-connection.query-pool.size";
    public static final String PROPERTY_TIMEOUT = "db-connection.query-pool.timeout";
    private static final int DEFAULT_MAX_POOL_SIZE = 128;
    private static final int DEFAULT_MAX_QUERY_STACK_SIZE = 64;
    private static final long DEFAULT_TIMEOUT = 120000L;
    private int maxPoolSize = 128;
    private int maxQueryStackSize = 64;
    private long timeout = 120000L;
    private final AtomicBoolean configured = new AtomicBoolean();
    private Cache<Source, Queue<CompiledXQuery>> cache;

    @Override
    public void configure(Configuration configuration) {
        if (!this.configured.compareAndSet(false, true)) {
            throw new IllegalStateException("XQuery Pool has already been configured");
        }
        Integer maxStSz = (Integer)configuration.getProperty(PROPERTY_MAX_STACK_SIZE);
        Integer maxPoolSz = (Integer)configuration.getProperty(PROPERTY_POOL_SIZE);
        Long t = (Long)configuration.getProperty(PROPERTY_TIMEOUT);
        NumberFormat nf = NumberFormat.getNumberInstance();
        this.maxPoolSize = maxPoolSz != null ? maxPoolSz : 128;
        this.maxQueryStackSize = maxStSz != null ? maxStSz : 64;
        this.timeout = t != null ? t : 120000L;
        this.cache = Caffeine.newBuilder().maximumSize((long)this.maxPoolSize).expireAfterAccess(this.timeout, TimeUnit.MILLISECONDS).build();
        LOG.info("QueryPool: size = " + nf.format(this.maxPoolSize) + "; maxQueryStackSize = " + nf.format(this.maxQueryStackSize) + "; timeout = " + nf.format(this.timeout) + "; ");
    }

    public void returnCompiledXQuery(Source source, CompiledXQuery compiledXQuery) {
        if (compiledXQuery == null) {
            return;
        }
        this.cache.asMap().compute(source, (key, value) -> {
            Queue queue = value != null ? value : new MpmcAtomicArrayQueue(this.maxQueryStackSize);
            queue.offer(compiledXQuery);
            return queue;
        });
    }

    public CompiledXQuery borrowCompiledXQuery(DBBroker broker, Source source) throws PermissionDeniedException {
        if (broker == null || source == null) {
            return null;
        }
        Queue queue = this.cache.asMap().computeIfPresent(source, (key, value) -> {
            if (!value.isEmpty()) {
                CompiledXQuery firstCompiledXQuery = (CompiledXQuery)value.peek();
                Source cachedSource = firstCompiledXQuery.getSource();
                Source.Validity validity = cachedSource.isValid(broker);
                if (validity == Source.Validity.UNKNOWN) {
                    validity = cachedSource.isValid(source);
                }
                if (validity == Source.Validity.INVALID || validity == Source.Validity.UNKNOWN) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(source.getKey() + " is invalid, removing from XQuery Pool...");
                    }
                    return null;
                }
                if (!firstCompiledXQuery.isValid()) {
                    return null;
                }
            }
            return value;
        });
        if (queue == null) {
            return null;
        }
        CompiledXQuery query = (CompiledXQuery)queue.poll();
        if (query == null) {
            return null;
        }
        source.validate(broker.getCurrentSubject(), 1);
        return query;
    }

    public void clear() {
        this.cache.invalidateAll();
    }
}

