/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.btree.BTree;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.txn.Txn;

public abstract class BTAbstractLoggable
extends AbstractLoggable {
    private byte fileId;
    private NativeBroker broker;

    public BTAbstractLoggable(byte type, byte fileId, Txn transaction) {
        super(type, transaction.getId());
        this.fileId = fileId;
    }

    public BTAbstractLoggable(byte type, DBBroker broker, long transactionId) {
        super(type, transactionId);
        this.broker = (NativeBroker)broker;
    }

    protected BTree getStorage() {
        return this.broker.getStorage(this.fileId);
    }

    @Override
    public void read(ByteBuffer in) {
        this.fileId = in.get();
    }

    @Override
    public void write(ByteBuffer out) {
        out.put(this.fileId);
    }

    @Override
    public int getLogSize() {
        return 1;
    }
}

