/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.BrokerPool;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.Value;
import org.exist.util.ByteConversion;
import org.exist.util.FileUtils;

public abstract class Paged
implements AutoCloseable {
    public static final int LENGTH_VERSION_ID = 2;
    public static final int LENGTH_HEADER_SIZE = 2;
    public static final int LENGTH_PAGE_COUNT = 8;
    public static final int LENGTH_PAGE_SIZE = 4;
    public static final int LENGTH_TOTAL_COUNT = 8;
    public static final int LENGTH_FIRST_FREE_PAGE = 8;
    public static final int LENGTH_LAST_FREE_PAGE = 8;
    public static final int LENGTH_PAGE_HEADER_SIZE = 1;
    public static final int LENGTH_MAX_KEY_SIZE = 2;
    public static final int LENGTH_RECORD_COUNT = 8;
    public static final int OFFSET_VERSION_ID = 0;
    public static final int OFFSET_HEADER_SIZE = 2;
    public static final int OFFSET_PAGE_SIZE = 4;
    public static final int OFFSET_PAGE_COUNT = 8;
    public static final int OFFSET_TOTAL_COUNT = 16;
    public static final int OFFSET_FIRST_FREE_PAGE = 24;
    public static final int OFFSET_LAST_FREE_PAGE = 32;
    public static final int OFFSET_PAGE_HEADER_SIZE = 40;
    public static final int OFFSET_MAX_KEY_SIZE = 41;
    public static final int OFFSET_RECORD_COUNT = 43;
    public static final int OFFSET_REMAINDER = 51;
    protected static final Logger LOG = LogManager.getLogger(Paged.class);
    protected static final byte DELETED = 127;
    protected static final byte OVERFLOW = 126;
    protected static final byte UNUSED = 0;
    protected static int PAGE_SIZE = 4096;
    private RandomAccessFile raf;
    private Path file;
    private final FileHeader fileHeader;
    private boolean readOnly = false;
    private boolean fileIsNew = false;
    private final byte[] tempPageData;
    private final byte[] tempHeaderData;
    private static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public Paged(BrokerPool pool) {
        this.fileHeader = this.createFileHeader(pool.getPageSize());
        this.tempPageData = new byte[this.fileHeader.pageSize];
        this.tempHeaderData = new byte[this.fileHeader.pageHeaderSize];
    }

    public abstract short getFileVersion();

    public static final void setPageSize(int pageSize) {
        PAGE_SIZE = pageSize;
    }

    public static final int getPageSize() {
        return PAGE_SIZE;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void close() throws DBException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new DBException("an error occurred while closing database file: " + e.getMessage());
        }
    }

    public boolean create() throws DBException {
        try {
            this.fileHeader.write();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(0, "Error creating " + FileUtils.fileName(this.file));
        }
    }

    public abstract FileHeader createFileHeader(int var1);

    public abstract PageHeader createPageHeader();

    public boolean exists() {
        return !this.fileIsNew;
    }

    public boolean flush() throws DBException {
        boolean flushed = false;
        try {
            if (this.fileHeader.isDirty() && !this.readOnly) {
                this.fileHeader.write();
                flushed = true;
            }
        }
        catch (IOException ioe) {
            LOG.warn("report me");
        }
        return flushed;
    }

    public void backupToStream(OutputStream os) throws IOException {
        int len;
        this.raf.seek(0L);
        byte[] buf = new byte[4096];
        while ((len = this.raf.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
    }

    public final Path getFile() {
        return this.file;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public void closeAndRemove() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            LOG.error("Failed to close data file: " + this.file.toAbsolutePath().toString());
        }
        FileUtils.deleteQuietly(this.file);
    }

    protected final Page getFreePage() throws IOException {
        return this.getFreePage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Page getFreePage(boolean reuseDeleted) throws IOException {
        Page page;
        FileHeader fileHeader = this.fileHeader;
        synchronized (fileHeader) {
            long pageNum = this.fileHeader.firstFreePage;
            if (reuseDeleted && pageNum != -1L) {
                page = new Page(pageNum);
                page.read();
                this.fileHeader.firstFreePage = page.header.nextPage;
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setLastFreePage(-1L);
                }
            } else {
                pageNum = this.fileHeader.totalCount;
                if (pageNum == Integer.MAX_VALUE) {
                    throw new IOException("page limit reached: " + pageNum);
                }
                this.fileHeader.setTotalCount(pageNum + 1L);
                page = new Page(pageNum);
                page.read();
            }
        }
        page.header.setNextPage(-1L);
        page.header.setStatus((byte)0);
        this.fileHeader.setDirty(true);
        this.fileHeader.write();
        return page;
    }

    protected final Page getPage(long pageNum) throws IOException {
        return new Page(pageNum);
    }

    public boolean isOpened() {
        return true;
    }

    public boolean open(short expectedVersion) throws DBException {
        try {
            if (this.exists()) {
                this.fileHeader.read();
                if (this.fileHeader.getVersion() != expectedVersion) {
                    throw new DBException("Database file " + FileUtils.fileName(this.getFile()) + " has a storage format incompatible with this version of eXist. You need to upgrade your database by creating a backup,cleaning your data directory and restoring the data. In some cases,a reindex may be sufficient. Please follow the instructions for the version you installed.File version is: " + expectedVersion + "; db expects version " + this.fileHeader.getVersion());
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(0, "Error opening " + FileUtils.fileName(this.file) + ": " + e.getMessage());
        }
    }

    public void printFreeSpaceList(PrintStream out) throws IOException {
        long pageNum = this.fileHeader.firstFreePage;
        out.println("first free page: " + pageNum);
        out.println("free pages for " + FileUtils.fileName(this.getFile()));
        while (pageNum != -1L) {
            Page next = this.getPage(pageNum);
            next.read();
            out.print(pageNum + ";");
            pageNum = next.header.nextPage;
        }
        out.println();
    }

    protected final void setFile(Path file) throws DBException {
        block6: {
            this.file = file;
            this.fileIsNew = !Files.exists(file, new LinkOption[0]);
            try {
                if (!Files.exists(file, new LinkOption[0]) || Files.isWritable(file)) {
                    try {
                        this.raf = new RandomAccessFile(file.toFile(), "rw");
                        FileChannel channel = this.raf.getChannel();
                        FileLock lock = channel.tryLock();
                        if (lock == null) {
                            this.readOnly = true;
                        }
                        break block6;
                    }
                    catch (NonWritableChannelException e) {
                        this.readOnly = true;
                        this.raf = new RandomAccessFile(file.toFile(), "r");
                        LOG.warn((Object)e);
                    }
                    break block6;
                }
                this.readOnly = true;
                this.raf = new RandomAccessFile(file.toFile(), "r");
            }
            catch (IOException e) {
                LOG.warn("An exception occurred while opening database file " + file.toAbsolutePath().toString() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlinkPages(Page page) throws IOException {
        if (page != null) {
            page.header.setStatus((byte)0);
            page.header.lsn = -1L;
            FileHeader fileHeader = this.fileHeader;
            synchronized (fileHeader) {
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setFirstFreePage(page.pageNum);
                    page.header.setNextPage(-1L);
                } else {
                    long firstFreePage = this.fileHeader.firstFreePage;
                    this.fileHeader.setFirstFreePage(page.pageNum);
                    page.header.setNextPage(firstFreePage);
                }
                page.remove();
                this.fileHeader.setDirty(true);
            }
        }
    }

    protected final void unlinkPages(long pageNum) throws IOException {
        this.unlinkPages(this.getPage(pageNum));
    }

    protected void reuseDeleted(Page page) throws IOException {
        if (page != null && this.fileHeader.getFirstFreePage() != -1L) {
            long firstFreePageNum = this.fileHeader.getFirstFreePage();
            if (firstFreePageNum == page.pageNum) {
                this.fileHeader.setFirstFreePage(page.header.getNextPage());
                this.fileHeader.write();
                return;
            }
            Page firstFreePage = this.getPage(firstFreePageNum);
            firstFreePage.read();
            firstFreePageNum = firstFreePage.header.getNextPage();
            while (firstFreePageNum != -1L) {
                if (firstFreePageNum == page.pageNum) {
                    firstFreePage.header.setNextPage(page.header.getNextPage());
                    firstFreePage.header.setDirty(true);
                    firstFreePage.write(null);
                    return;
                }
                firstFreePage = this.getPage(firstFreePageNum);
                firstFreePage.read();
                firstFreePageNum = firstFreePage.header.getNextPage();
            }
        }
    }

    protected final void writeValue(Page page, Value value) throws IOException {
        byte[] data = value.getData();
        this.writeValue(page, data);
    }

    protected final void writeValue(Page page, byte[] data) throws IOException {
        PageHeader pageHeader = page.getPageHeader();
        pageHeader.dataLen = this.fileHeader.workSize;
        if (data.length != pageHeader.dataLen) {
            if (pageHeader.dataLen != Paged.getPageSize() - 64) {
                LOG.warn("ouch: " + this.fileHeader.workSize + " != " + data.length);
            }
            pageHeader.dataLen = data.length;
        }
        page.write(data);
    }

    protected final void writeValue(long page, Value value) throws IOException {
        this.writeValue(this.getPage(page), value);
    }

    public static String hexDump(byte[] data) {
        StringBuilder buf = new StringBuilder();
        int columns = 0;
        int i = 0;
        while (i < data.length) {
            Paged.byteToHex(buf, data[i]);
            if (columns == 16) {
                columns = 0;
            } else {
                buf.append(' ');
            }
            ++i;
            ++columns;
        }
        return buf.toString();
    }

    private static void byteToHex(StringBuilder buf, byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        buf.append(hex[d1]);
        buf.append(hex[d2]);
    }

    public static abstract class PageHeader {
        public static final int LENGTH_PAGE_STATUS = 1;
        public static final int LENGTH_PAGE_DATA_LENGTH = 4;
        public static final int LENGTH_PAGE_NEXT_PAGE = 8;
        public static final int LENGTH_PAGE_LSN = 8;
        private int dataLen = 0;
        private boolean dirty = false;
        private long nextPage = -1L;
        private byte status = 0;
        private long lsn = -1L;

        public PageHeader() {
        }

        public PageHeader(byte[] data, int offset) throws IOException {
            this.read(data, offset);
        }

        public final int getDataLen() {
            return this.dataLen;
        }

        public final long getNextPage() {
            return this.nextPage;
        }

        public final byte getStatus() {
            return this.status;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final long getLsn() {
            return this.lsn;
        }

        public final void setLsn(long lsn) {
            this.lsn = lsn;
        }

        public int read(byte[] data, int offset) throws IOException {
            this.status = data[offset];
            this.dataLen = ByteConversion.byteToInt(data, ++offset);
            this.nextPage = ByteConversion.byteToLong(data, offset += 4);
            this.lsn = ByteConversion.byteToLong(data, offset += 8);
            return offset += 8;
        }

        public int write(byte[] data, int offset) throws IOException {
            data[offset] = this.status;
            ByteConversion.intToByte(this.dataLen, data, ++offset);
            ByteConversion.longToByte(this.nextPage, data, offset += 4);
            ByteConversion.longToByte(this.lsn, data, offset += 8);
            this.dirty = false;
            return offset += 8;
        }

        public final void setDataLen(int dataLen) {
            this.dataLen = dataLen;
            this.dirty = true;
        }

        public final void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public final void setNextPage(long nextPage) {
            this.nextPage = nextPage;
            this.dirty = true;
        }

        public final void setStatus(byte status) {
            this.status = status;
            this.dirty = true;
        }
    }

    public final class Page
    implements Comparable<Page> {
        public static final long NO_PAGE = -1L;
        private final PageHeader header;
        private long offset;
        private long pageNum;
        private int refCount = 0;

        public Page() {
            this.header = Paged.this.createPageHeader();
        }

        public Page(long pageNum) throws IOException {
            this();
            if (pageNum == -1L) {
                throw new IOException("Illegal page num: " + pageNum);
            }
            this.setPageNum(pageNum);
        }

        public void decRefCount() {
            --this.refCount;
        }

        public long getOffset() {
            return this.offset;
        }

        public PageHeader getPageHeader() {
            return this.header;
        }

        public String getPageInfo() {
            return "page: " + this.pageNum + "; file = " + FileUtils.fileName(Paged.this.getFile()) + "; address = " + Long.toHexString(this.offset) + "; page header = " + Paged.this.fileHeader.getPageHeaderSize() + "; data start = " + Long.toHexString(this.offset + (long)Paged.this.fileHeader.getPageHeaderSize());
        }

        public long getPageNum() {
            return this.pageNum;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public int getDataPos() {
            return Paged.this.fileHeader.pageHeaderSize;
        }

        public void incRefCount() {
            ++this.refCount;
        }

        public byte[] read() throws IOException {
            try {
                if (Paged.this.raf.getFilePointer() != this.offset) {
                    Paged.this.raf.seek(this.offset);
                }
                Arrays.fill(Paged.this.tempHeaderData, (byte)0);
                Paged.this.raf.read(Paged.this.tempHeaderData);
                this.header.read(Paged.this.tempHeaderData, 0);
                byte[] workData = new byte[this.header.dataLen];
                Paged.this.raf.read(workData);
                return workData;
            }
            catch (Exception e) {
                LOG.warn("error while reading page: " + this.getPageInfo(), (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }

        public void setPageNum(long pageNum) {
            this.pageNum = pageNum;
            this.offset = (long)Paged.this.fileHeader.headerSize + pageNum * (long)Paged.this.fileHeader.pageSize;
        }

        public void remove() throws IOException {
            this.write(null);
        }

        private final void write(byte[] data) throws IOException {
            if (data == null) {
                Arrays.fill(Paged.this.tempPageData, (byte)0);
                this.header.setLsn(-1L);
            }
            this.header.write(Paged.this.tempPageData, 0);
            this.header.dirty = false;
            if (data != null) {
                if (data.length > Paged.this.fileHeader.workSize) {
                    throw new IOException("page: " + this.getPageInfo() + ": data length too large: " + data.length);
                }
                System.arraycopy(data, 0, Paged.this.tempPageData, Paged.this.fileHeader.pageHeaderSize, data.length);
            }
            if (Paged.this.raf.getFilePointer() != this.offset) {
                Paged.this.raf.seek(this.offset);
            }
            Paged.this.raf.write(Paged.this.tempPageData);
        }

        public boolean equals(Object obj) {
            return ((Page)obj).pageNum == this.pageNum;
        }

        @Override
        public int compareTo(Page other) {
            if (this.pageNum == other.pageNum) {
                return 0;
            }
            if (this.pageNum > other.pageNum) {
                return 1;
            }
            return -1;
        }

        public void dumpPage() throws IOException {
            if (Paged.this.raf.getFilePointer() != this.offset) {
                Paged.this.raf.seek(this.offset);
            }
            byte[] data = new byte[Paged.this.fileHeader.pageSize];
            Paged.this.raf.read(data);
            LOG.debug("Contents of page " + this.pageNum + ": " + Paged.hexDump(data));
        }
    }

    public abstract class FileHeader {
        private short versionId;
        private boolean dirty = false;
        private long firstFreePage = -1L;
        private short headerSize;
        private long lastFreePage = -1L;
        private short maxKeySize = (short)256;
        private long pageCount;
        private byte pageHeaderSize = (byte)64;
        private int pageSize;
        private long recordCount;
        private long totalCount;
        private int workSize;
        private final byte[] buf;

        public FileHeader(long pageCount, int pageSize) {
            this.pageSize = pageSize;
            this.pageCount = pageCount;
            this.totalCount = pageCount;
            this.headerSize = (short)pageSize;
            this.versionId = Paged.this.getFileVersion();
            this.buf = new byte[this.headerSize];
            this.calculateWorkSize();
        }

        private void calculateWorkSize() {
            this.workSize = this.pageSize - this.pageHeaderSize;
        }

        public final synchronized void decRecordCount() {
            --this.recordCount;
            this.dirty = true;
        }

        public final long getFirstFreePage() {
            return this.firstFreePage;
        }

        public final short getHeaderSize() {
            return this.headerSize;
        }

        public final long getLastFreePage() {
            return this.lastFreePage;
        }

        public int getMaxKeySize() {
            return this.maxKeySize;
        }

        public final long getPageCount() {
            return this.pageCount;
        }

        public final byte getPageHeaderSize() {
            return this.pageHeaderSize;
        }

        public final int getPageSize() {
            return this.pageSize;
        }

        public final long getRecordCount() {
            return this.recordCount;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        public final int getWorkSize() {
            return this.workSize;
        }

        public final short getVersion() {
            return this.versionId;
        }

        public final synchronized void incRecordCount() {
            ++this.recordCount;
            this.dirty = true;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void read() throws IOException {
            Paged.this.raf.seek(0L);
            Paged.this.raf.read(this.buf);
            this.read(this.buf);
            this.calculateWorkSize();
            this.dirty = false;
        }

        public int read(byte[] buf) throws IOException {
            this.versionId = ByteConversion.byteToShort(buf, 0);
            this.headerSize = ByteConversion.byteToShort(buf, 2);
            this.pageSize = ByteConversion.byteToInt(buf, 4);
            this.pageCount = ByteConversion.byteToLong(buf, 8);
            this.totalCount = ByteConversion.byteToLong(buf, 16);
            this.firstFreePage = ByteConversion.byteToLong(buf, 24);
            this.lastFreePage = ByteConversion.byteToLong(buf, 32);
            this.pageHeaderSize = buf[40];
            this.maxKeySize = ByteConversion.byteToShort(buf, 41);
            this.recordCount = ByteConversion.byteToLong(buf, 43);
            return 51;
        }

        public int write(byte[] buf) throws IOException {
            ByteConversion.shortToByte(this.versionId, buf, 0);
            ByteConversion.shortToByte(this.headerSize, buf, 2);
            ByteConversion.intToByte(this.pageSize, buf, 4);
            ByteConversion.longToByte(this.pageCount, buf, 8);
            ByteConversion.longToByte(this.totalCount, buf, 16);
            ByteConversion.longToByte(this.firstFreePage, buf, 24);
            ByteConversion.longToByte(this.lastFreePage, buf, 32);
            buf[40] = this.pageHeaderSize;
            ByteConversion.shortToByte(this.maxKeySize, buf, 41);
            ByteConversion.longToByte(this.recordCount, buf, 43);
            return 51;
        }

        public final void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public final void setFirstFreePage(long firstFreePage) {
            this.firstFreePage = firstFreePage;
            this.dirty = true;
        }

        public final void setHeaderSize(short headerSize) {
            this.headerSize = headerSize;
            this.dirty = true;
        }

        public final void setLastFreePage(long lastFreePage) {
            this.lastFreePage = lastFreePage;
            this.dirty = true;
        }

        public final void setMaxKeySize(short maxKeySize) {
            this.maxKeySize = maxKeySize;
            this.dirty = true;
        }

        public final void setPageCount(long pageCount) {
            this.pageCount = pageCount;
            this.dirty = true;
        }

        public final void setPageHeaderSize(byte pageHeaderSize) {
            this.pageHeaderSize = pageHeaderSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final void setRecordCount(long recordCount) {
            this.recordCount = recordCount;
            this.dirty = true;
        }

        public final void setTotalCount(long totalCount) {
            this.totalCount = totalCount;
            this.dirty = true;
        }

        public final synchronized void write() throws IOException {
            Paged.this.raf.seek(0L);
            this.write(this.buf);
            Paged.this.raf.write(this.buf);
            this.dirty = false;
        }
    }
}

