/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.btree.Value;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemoveValueLoggable
extends BTAbstractLoggable {
    protected long pageNum;
    protected int idx;
    protected Value oldValue;
    protected long oldPointer;

    public RemoveValueLoggable(Txn transaction, byte fileId, long pageNum, int idx, Value oldValue, long oldPointer) {
        super((byte)37, fileId, transaction);
        this.pageNum = pageNum;
        this.idx = idx;
        this.oldValue = oldValue;
        this.oldPointer = oldPointer;
    }

    public RemoveValueLoggable(DBBroker broker, long transactionId) {
        super((byte)37, broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
        out.putShort((short)this.idx);
        out.putShort((short)this.oldValue.getLength());
        out.put(this.oldValue.data(), this.oldValue.start(), this.oldValue.getLength());
        out.putLong(this.oldPointer);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
        this.idx = in.getShort();
        short l = in.getShort();
        byte[] data = new byte[l];
        in.get(data);
        this.oldValue = new Value(data);
        this.oldPointer = in.getLong();
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 16 + this.oldValue.getLength();
    }

    @Override
    public void redo() throws LogException {
        this.getStorage().redoRemoveValue(this);
    }

    @Override
    public void undo() throws LogException {
        this.getStorage().undoRemoveValue(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - removed btree key on page: " + this.pageNum;
    }
}

