/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.cache;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.cache.Cacheable;
import org.exist.util.hashtable.SequencedLongHashMap;

public class Accounting {
    private static final Logger LOG = LogManager.getLogger(Accounting.class);
    private static final Object DUMMY = new Object();
    private int checkPeriod = 30000;
    private long checkPeriodStart = System.currentTimeMillis();
    private int maxEntries = 5000;
    private int hits = 0;
    private int misses = 0;
    private int totalSize = 0;
    private int thrashing = 0;
    private double thrashingFactor;
    private SequencedLongHashMap<Object> map = new SequencedLongHashMap(this.maxEntries * 3 / 2);

    public Accounting(double thrashingFactor) {
        this.thrashingFactor = thrashingFactor;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public void hitIncrement() {
        ++this.hits;
    }

    public int getHits() {
        return this.hits;
    }

    public void missesIncrement() {
        ++this.misses;
    }

    public int getMisses() {
        return this.misses;
    }

    public void replacedPage(Cacheable cacheable) {
        if (System.currentTimeMillis() - this.checkPeriodStart > (long)this.checkPeriod) {
            this.map.clear();
            this.thrashing = 0;
            this.checkPeriodStart = System.currentTimeMillis();
        }
        if (this.map.size() == this.maxEntries) {
            this.map.removeFirst();
        }
        if (this.map.get(cacheable.getKey()) != null) {
            ++this.thrashing;
        } else {
            this.map.put(cacheable.getKey(), DUMMY);
        }
    }

    public int getThrashing() {
        return this.thrashing;
    }

    public boolean resizeNeeded() {
        if (this.thrashingFactor == 0.0) {
            return this.thrashing > 0;
        }
        return (double)this.thrashing > (double)this.totalSize * this.thrashingFactor;
    }

    public void reset() {
        this.map.clear();
        this.thrashing = 0;
        this.checkPeriodStart = System.currentTimeMillis();
    }

    public void stats() {
        LOG.debug("hits: " + this.hits + "; misses: " + this.misses + "; thrashing: " + this.getThrashing() + "; thrashing period: " + this.checkPeriod);
    }
}

