/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.IStoredNode;
import org.exist.dom.persistent.NodeProxy;
import org.exist.numbering.DLNBase;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.BufferStats;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.Signatures;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Paged;
import org.exist.storage.btree.Value;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRUCache;
import org.exist.storage.dom.AddLinkLoggable;
import org.exist.storage.dom.AddMovedValueLoggable;
import org.exist.storage.dom.AddValueLoggable;
import org.exist.storage.dom.CreatePageLoggable;
import org.exist.storage.dom.InsertValueLoggable;
import org.exist.storage.dom.ItemId;
import org.exist.storage.dom.RecordPos;
import org.exist.storage.dom.RemoveEmptyPageLoggable;
import org.exist.storage.dom.RemoveOverflowLoggable;
import org.exist.storage.dom.RemovePageLoggable;
import org.exist.storage.dom.RemoveValueLoggable;
import org.exist.storage.dom.SplitPageLoggable;
import org.exist.storage.dom.UpdateHeaderLoggable;
import org.exist.storage.dom.UpdateLinkLoggable;
import org.exist.storage.dom.UpdateValueLoggable;
import org.exist.storage.dom.WriteOverflowPageLoggable;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.JournalException;
import org.exist.storage.journal.JournalManager;
import org.exist.storage.journal.LogEntryTypes;
import org.exist.storage.journal.Loggable;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;
import org.exist.util.Lockable;
import org.exist.util.ReadOnlyException;
import org.exist.util.hashtable.Object2LongIdentityHashMap;
import org.exist.util.sanity.SanityCheck;
import org.exist.xquery.TerminatedException;

public class DOMFile
extends BTree
implements Lockable {
    protected static final Logger LOGSTATS = LogManager.getLogger((String)"org.exist.statistics");
    public static final String FILE_NAME = "dom.dbx";
    public static final String CONFIG_KEY_FOR_FILE = "db-connection.dom";
    public static final int LENGTH_TID = 2;
    public static final int LENGTH_DATA_LENGTH = 2;
    public static final int LENGTH_LINK = 8;
    public static final int LENGTH_ORIGINAL_LOCATION = 8;
    public static final int LENGTH_FORWARD_LOCATION = 8;
    public static final int LENGTH_OVERFLOW_LOCATION = 8;
    public static final byte LOG_CREATE_PAGE = 16;
    public static final byte LOG_ADD_VALUE = 17;
    public static final byte LOG_REMOVE_VALUE = 18;
    public static final byte LOG_REMOVE_EMPTY_PAGE = 19;
    public static final byte LOG_UPDATE_VALUE = 20;
    public static final byte LOG_REMOVE_PAGE = 21;
    public static final byte LOG_WRITE_OVERFLOW = 22;
    public static final byte LOG_REMOVE_OVERFLOW = 23;
    public static final byte LOG_INSERT_RECORD = 24;
    public static final byte LOG_SPLIT_PAGE = 25;
    public static final byte LOG_ADD_LINK = 26;
    public static final byte LOG_ADD_MOVED_REC = 27;
    public static final byte LOG_UPDATE_HEADER = 28;
    public static final byte LOG_UPDATE_LINK = 29;
    public static final short FILE_FORMAT_VERSION_ID = 9;
    public static final byte LOB = 21;
    public static final byte RECORD = 20;
    public static final short OVERFLOW = 0;
    public static final long DATA_SYNC_PERIOD = 4200L;
    private final Cache<DOMPage> dataCache;
    private final BTree.BTreeFileHeader fileHeader;
    private Object owner = null;
    private final Lock lock;
    private final Object2LongIdentityHashMap<Object> pages = new Object2LongIdentityHashMap(64);
    private DocumentImpl currentDocument = null;
    private final AddValueLoggable addValueLog = new AddValueLoggable();

    public DOMFile(BrokerPool pool, byte id, Path dataDir, Configuration config) throws DBException {
        super(pool, id, true, pool.getCacheManager());
        this.lock = new ReentrantReadWriteLock(DOMFile.getFileName());
        this.fileHeader = (BTree.BTreeFileHeader)this.getFileHeader();
        this.fileHeader.setPageCount(0L);
        this.fileHeader.setTotalCount(0L);
        this.dataCache = new LRUCache<DOMPage>(DOMFile.getFileName(), 256, 0.0, 1.0, "DATA");
        this.cacheManager.registerCache(this.dataCache);
        Path file = dataDir.resolve(DOMFile.getFileName());
        this.setFile(file);
        if (this.exists()) {
            this.open();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating data file: " + FileUtils.fileName(file));
            }
            this.create();
        }
        config.setProperty(DOMFile.getConfigKeyForFile(), this);
    }

    private final void setCurrentPage(DOMPage page) {
        long pageNum = this.pages.get(this.owner);
        if (pageNum == page.page.getPageNum()) {
            return;
        }
        this.pages.put(this.owner, page.page.getPageNum());
    }

    private final DOMPage getCurrentPage(Txn transaction) {
        long pageNum = this.pages.get(this.owner);
        if (pageNum == -1L) {
            DOMPage page = new DOMPage();
            this.pages.put(this.owner, page.page.getPageNum());
            this.dataCache.add(page);
            if (transaction != null && this.isRecoveryEnabled()) {
                CreatePageLoggable loggable = new CreatePageLoggable(transaction, -1L, page.getPageNum(), -1L);
                this.writeToLog(loggable, page.page);
            }
            return page;
        }
        return this.getDOMPage(pageNum);
    }

    protected final DOMPage getDOMPage(long pointer) {
        DOMPage page = this.dataCache.get(pointer);
        if (page == null) {
            page = new DOMPage(pointer);
        }
        return page;
    }

    public boolean open() throws DBException {
        return super.open((short)9);
    }

    public void closeDocument() {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        this.pages.remove(this.owner);
    }

    public static String getFileName() {
        return FILE_NAME;
    }

    public static String getConfigKeyForFile() {
        return CONFIG_KEY_FOR_FILE;
    }

    public final synchronized void addToBuffer(DOMPage page) {
        this.dataCache.add(page);
    }

    protected final Cache getPageBuffer() {
        return this.dataCache;
    }

    @Override
    public short getFileVersion() {
        return 9;
    }

    @Override
    public boolean create() throws DBException {
        return super.create((short)-1);
    }

    @Override
    public void close() throws DBException {
        if (!this.isReadOnly()) {
            this.flush();
        }
        super.close();
    }

    @Override
    public void closeAndRemove() {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        super.closeAndRemove();
        this.cacheManager.deregisterCache(this.dataCache);
    }

    public void setCurrentDocument(DocumentImpl doc) {
        this.currentDocument = doc;
    }

    public long add(Txn transaction, byte[] value) throws ReadOnlyException {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        if (value == null || value.length == 0) {
            return -1L;
        }
        if (value.length + 2 + 2 > this.fileHeader.getWorkSize()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating overflow page");
            }
            OverflowDOMPage overflowPage = new OverflowDOMPage();
            overflowPage.write(transaction, value);
            byte[] pageNum = ByteConversion.longToByte(overflowPage.getPageNum());
            return this.add(transaction, pageNum, true);
        }
        return this.add(transaction, value, false);
    }

    private long add(Txn transaction, byte[] value, boolean overflowPage) throws ReadOnlyException {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        int valueLength = value.length;
        DOMPage currentPage = this.getCurrentPage(transaction);
        if (currentPage.len + 2 + 2 + valueLength > currentPage.data.length) {
            AbstractLoggable loggable;
            DOMPage newPage = new DOMPage();
            DOMFilePageHeader currentPageHeader = currentPage.getPageHeader();
            if (transaction != null && this.isRecoveryEnabled()) {
                loggable = new UpdateHeaderLoggable(transaction, currentPageHeader.getPreviousDataPage(), currentPage.getPageNum(), newPage.getPageNum(), currentPageHeader.getPreviousDataPage(), currentPageHeader.getNextDataPage());
                this.writeToLog(loggable, currentPage.page);
            }
            currentPageHeader.setNextDataPage(newPage.getPageNum());
            newPage.getPageHeader().setPrevDataPage(currentPage.getPageNum());
            currentPage.setDirty(true);
            this.dataCache.add(currentPage);
            if (transaction != null && this.isRecoveryEnabled()) {
                loggable = new CreatePageLoggable(transaction, currentPage == null ? -1L : currentPage.getPageNum(), newPage.getPageNum(), -1L);
                this.writeToLog(loggable, newPage.page);
            }
            currentPage = newPage;
            this.setCurrentPage(newPage);
        }
        DOMFilePageHeader currentPageHeader = currentPage.getPageHeader();
        short tupleID = currentPageHeader.getNextTupleID();
        if (transaction != null && this.isRecoveryEnabled()) {
            this.addValueLog.clear(transaction, currentPage.getPageNum(), tupleID, value);
            this.writeToLog(this.addValueLog, currentPage.page);
        }
        ByteConversion.shortToByte(tupleID, currentPage.data, currentPage.len);
        currentPage.len += 2;
        ByteConversion.shortToByte(overflowPage ? (short)0 : (short)valueLength, currentPage.data, currentPage.len);
        currentPage.len += 2;
        System.arraycopy(value, 0, currentPage.data, currentPage.len, valueLength);
        currentPage.len += valueLength;
        currentPageHeader.incRecordCount();
        currentPageHeader.setDataLength(currentPage.len);
        currentPage.setDirty(true);
        this.dataCache.add(currentPage, 2);
        return StorageAddress.createPointer((int)currentPage.getPageNum(), tupleID);
    }

    private void writeToLog(Loggable loggable, Paged.Page page) {
        if (this.logManager.isPresent()) {
            try {
                ((JournalManager)this.logManager.get()).journal(loggable);
                page.getPageHeader().setLsn(loggable.getLsn());
            }
            catch (JournalException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public long addBinary(Txn transaction, DocumentImpl doc, byte[] value) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        OverflowDOMPage overflowPage = new OverflowDOMPage();
        int pagesCount = overflowPage.write(transaction, value);
        doc.getMetadata().setPageCount(pagesCount);
        return overflowPage.getPageNum();
    }

    public long addBinary(Txn transaction, DocumentImpl doc, InputStream is) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        OverflowDOMPage overflowPage = new OverflowDOMPage();
        int pagesCount = overflowPage.write(transaction, is);
        doc.getMetadata().setPageCount(pagesCount);
        return overflowPage.getPageNum();
    }

    public byte[] getBinary(long pageNum) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        return this.getOverflowValue(pageNum);
    }

    public void readBinary(long pageNum, OutputStream os) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        try {
            OverflowDOMPage overflowPage = new OverflowDOMPage(pageNum);
            overflowPage.streamTo(os);
        }
        catch (IOException e) {
            LOG.error("IO error while loading overflow value", (Throwable)e);
        }
    }

    public long insertAfter(Txn transaction, DocumentImpl doc, Value key, byte[] value) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        try {
            long address = this.findValue(key);
            if (address == -1L) {
                LOG.warn("Couldn't find the value");
                return -1L;
            }
            return this.insertAfter(transaction, doc, address, value);
        }
        catch (BTreeException e) {
            LOG.warn("key not found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("IO error", (Throwable)e);
        }
        return -1L;
    }

    public long insertAfter(Txn transaction, DocumentImpl doc, long address, byte[] value) {
        DOMFilePageHeader newPageHeader;
        RecordPos rec;
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        boolean isOverflow = false;
        if (4 + value.length > this.fileHeader.getWorkSize()) {
            OverflowDOMPage overflowPage = new OverflowDOMPage();
            LOG.debug("Creating overflow page: " + overflowPage.getPageNum());
            overflowPage.write(transaction, value);
            value = ByteConversion.longToByte(overflowPage.getPageNum());
            isOverflow = true;
        }
        if ((rec = this.findRecord(address)) == null) {
            SanityCheck.TRACE("Page not found");
            return -1L;
        }
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTupleID())) {
            rec.offset += 8;
        }
        rec.offset = vlen == 0 ? (rec.offset += 8) : (rec.offset += vlen);
        int dataLength = rec.getPage().getPageHeader().getDataLength();
        if (rec.offset < dataLength) {
            if (dataLength + 2 + 2 + value.length <= this.fileHeader.getWorkSize() && rec.getPage().getPageHeader().hasRoom()) {
                int end = rec.offset + 2 + 2 + value.length;
                System.arraycopy(rec.getPage().data, rec.offset, rec.getPage().data, end, dataLength - rec.offset);
                rec.getPage().len = dataLength + 2 + 2 + value.length;
                rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
            } else {
                rec = this.splitDataPage(transaction, rec);
                if (rec.offset + 2 + 2 + value.length > this.fileHeader.getWorkSize() || !rec.getPage().getPageHeader().hasRoom()) {
                    AbstractLoggable loggable;
                    DOMPage newPage = new DOMPage();
                    newPageHeader = newPage.getPageHeader();
                    LOG.debug("creating additional page: " + newPage.getPageNum() + "; prev = " + rec.getPage().getPageNum() + "; next = " + rec.getPage().getPageHeader().getNextDataPage());
                    if (transaction != null && this.isRecoveryEnabled()) {
                        loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), rec.getPage().getPageHeader().getNextDataPage());
                        this.writeToLog(loggable, newPage.page);
                    }
                    newPageHeader.setNextDataPage(rec.getPage().getPageHeader().getNextDataPage());
                    newPageHeader.setPrevDataPage(rec.getPage().getPageNum());
                    if (transaction != null && this.isRecoveryEnabled()) {
                        loggable = new UpdateHeaderLoggable(transaction, rec.getPage().getPageHeader().getPreviousDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), rec.getPage().getPageHeader().getPreviousDataPage(), rec.getPage().getPageHeader().getNextDataPage());
                        this.writeToLog(loggable, rec.getPage().page);
                    }
                    rec.getPage().getPageHeader().setNextDataPage(newPage.getPageNum());
                    if (newPageHeader.getNextDataPage() != -1L) {
                        DOMPage nextPage = this.getDOMPage(newPageHeader.getNextDataPage());
                        DOMFilePageHeader nextPageHeader = nextPage.getPageHeader();
                        if (transaction != null && this.isRecoveryEnabled()) {
                            UpdateHeaderLoggable loggable2 = new UpdateHeaderLoggable(transaction, newPage.getPageNum(), nextPage.getPageNum(), nextPageHeader.getNextDataPage(), nextPageHeader.getPreviousDataPage(), nextPageHeader.getNextDataPage());
                            this.writeToLog(loggable2, nextPage.page);
                        }
                        nextPageHeader.setPrevDataPage(newPage.getPageNum());
                        nextPage.setDirty(true);
                        this.dataCache.add(nextPage);
                    }
                    rec.getPage().setDirty(true);
                    this.dataCache.add(rec.getPage());
                    rec.setPage(newPage);
                    rec.offset = 0;
                    rec.getPage().len = 4 + value.length;
                    rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
                } else {
                    rec.getPage().len = rec.offset + 2 + 2 + value.length;
                    rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
                }
            }
        } else if (dataLength + 2 + 2 + value.length > this.fileHeader.getWorkSize() || !rec.getPage().getPageHeader().hasRoom()) {
            DOMPage newPage = new DOMPage();
            newPageHeader = newPage.getPageHeader();
            LOG.debug("Creating new page: " + newPage.getPageNum());
            if (transaction != null && this.isRecoveryEnabled()) {
                CreatePageLoggable loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), rec.getPage().getPageHeader().getNextDataPage());
                this.writeToLog(loggable, newPage.page);
            }
            long nextPageNum = rec.getPage().getPageHeader().getNextDataPage();
            newPageHeader.setNextDataPage(nextPageNum);
            newPageHeader.setPrevDataPage(rec.getPage().getPageNum());
            if (transaction != null && this.isRecoveryEnabled()) {
                DOMFilePageHeader pageHeader = rec.getPage().getPageHeader();
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, pageHeader.getPreviousDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), pageHeader.getPreviousDataPage(), pageHeader.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            rec.getPage().getPageHeader().setNextDataPage(newPage.getPageNum());
            if (nextPageNum != -1L) {
                DOMPage nextPage = this.getDOMPage(nextPageNum);
                DOMFilePageHeader nextPageHeader = nextPage.getPageHeader();
                if (transaction != null && this.isRecoveryEnabled()) {
                    UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, newPage.getPageNum(), nextPage.getPageNum(), nextPageHeader.getNextDataPage(), nextPageHeader.getPreviousDataPage(), nextPageHeader.getNextDataPage());
                    this.writeToLog(loggable, nextPage.page);
                }
                nextPageHeader.setPrevDataPage(newPage.getPageNum());
                nextPage.setDirty(true);
                this.dataCache.add(nextPage);
            }
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
            rec.setPage(newPage);
            rec.offset = 0;
            rec.getPage().len = 4 + value.length;
            rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
        } else {
            rec.getPage().len = dataLength + 2 + 2 + value.length;
            rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
        }
        short tupleID = rec.getPage().getPageHeader().getNextTupleID();
        if (transaction != null && this.isRecoveryEnabled()) {
            InsertValueLoggable loggable = new InsertValueLoggable(transaction, rec.getPage().getPageNum(), isOverflow, tupleID, value, rec.offset);
            this.writeToLog(loggable, rec.getPage().page);
        }
        ByteConversion.shortToByte(tupleID, rec.getPage().data, rec.offset);
        rec.offset += 2;
        ByteConversion.shortToByte(isOverflow ? (short)0 : (short)value.length, rec.getPage().data, rec.offset);
        rec.offset += 2;
        System.arraycopy(value, 0, rec.getPage().data, rec.offset, value.length);
        rec.offset += value.length;
        rec.getPage().getPageHeader().incRecordCount();
        if (doc != null && rec.getPage().getPageHeader().getCurrentTupleID() >= 12286) {
            doc.triggerDefrag();
        }
        rec.getPage().setDirty(true);
        this.dataCache.add(rec.getPage());
        return StorageAddress.createPointer((int)rec.getPage().getPageNum(), tupleID);
    }

    private RecordPos splitDataPage(Txn transaction, RecordPos rec) {
        if (this.currentDocument != null) {
            this.currentDocument.getMetadata().incSplitCount();
        }
        boolean requireSplit = false;
        for (int pos = rec.offset; pos < rec.getPage().len; pos += 8) {
            short tupleID = ByteConversion.byteToShort(rec.getPage().data, pos);
            pos += 2;
            if (ItemId.isLink(tupleID)) continue;
            requireSplit = true;
            break;
        }
        if (!requireSplit) {
            LOG.debug("page: " + rec.getPage().getPageNum() + ": no split required. Next page:" + rec.getPage().getPageHeader().getNextDataPage() + " Previous page:" + rec.getPage().getPageHeader().getPreviousDataPage());
            rec.offset = rec.getPage().len;
            return rec;
        }
        DOMFilePageHeader pageHeader = rec.getPage().getPageHeader();
        int oldDataLen = pageHeader.getDataLength();
        byte[] oldData = rec.getPage().data;
        if (transaction != null && this.isRecoveryEnabled()) {
            SplitPageLoggable loggable = new SplitPageLoggable(transaction, rec.getPage().getPageNum(), rec.offset, oldData, oldDataLen);
            this.writeToLog(loggable, rec.getPage().page);
        }
        rec.getPage().data = new byte[this.fileHeader.getWorkSize()];
        System.arraycopy(oldData, 0, rec.getPage().data, 0, rec.offset);
        rec.getPage().len = rec.offset;
        pageHeader.setDataLength(rec.getPage().len);
        rec.getPage().setDirty(true);
        DOMPage firstSplitPage = new DOMPage();
        if (transaction != null && this.isRecoveryEnabled()) {
            CreatePageLoggable loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), firstSplitPage.getPageNum(), -1L, pageHeader.getCurrentTupleID());
            this.writeToLog(loggable, firstSplitPage.page);
        }
        DOMPage nextSplitPage = firstSplitPage;
        nextSplitPage.getPageHeader().setNextTupleID(pageHeader.getCurrentTupleID());
        short splitRecordCount = 0;
        LOG.debug("Splitting " + rec.getPage().getPageNum() + " at " + rec.offset + ": New page: " + nextSplitPage.getPageNum() + "; Next page: " + pageHeader.getNextDataPage());
        int pos = rec.offset;
        while (pos < oldDataLen) {
            short tupleID = ByteConversion.byteToShort(oldData, pos);
            pos += 2;
            if (ItemId.isLink(tupleID)) {
                AbstractLoggable loggable;
                if (rec.getPage().len + 2 + 8 > this.fileHeader.getWorkSize()) {
                    DOMPage newPage = new DOMPage();
                    DOMFilePageHeader newPageHeader = newPage.getPageHeader();
                    if (transaction != null && this.isRecoveryEnabled()) {
                        loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), pageHeader.getNextDataPage(), pageHeader.getCurrentTupleID());
                        this.writeToLog(loggable, firstSplitPage.page);
                        loggable = new UpdateHeaderLoggable(transaction, pageHeader.getPreviousDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), pageHeader.getPreviousDataPage(), pageHeader.getNextDataPage());
                        this.writeToLog(loggable, nextSplitPage.page);
                    }
                    newPageHeader.setNextTupleID(pageHeader.getCurrentTupleID());
                    newPageHeader.setPrevDataPage(rec.getPage().getPageNum());
                    newPageHeader.setNextDataPage(pageHeader.getNextDataPage());
                    LOG.debug("Appending page after split: " + newPage.getPageNum());
                    pageHeader.setNextDataPage(newPage.getPageNum());
                    pageHeader.setDataLength(rec.getPage().len);
                    pageHeader.setRecordCount(this.countRecordsInPage(rec.getPage()));
                    rec.getPage().cleanUp();
                    rec.getPage().setDirty(true);
                    this.dataCache.add(rec.getPage());
                    rec.setPage(newPage);
                    rec.getPage().len = 0;
                    this.dataCache.add(newPage);
                }
                if (transaction != null && this.isRecoveryEnabled()) {
                    long oldLink = ByteConversion.byteToLong(oldData, pos);
                    loggable = new AddLinkLoggable(transaction, rec.getPage().getPageNum(), ItemId.getId(tupleID), oldLink);
                    this.writeToLog(loggable, rec.getPage().page);
                }
                ByteConversion.shortToByte(tupleID, rec.getPage().data, rec.getPage().len);
                rec.getPage().len += 2;
                System.arraycopy(oldData, pos, rec.getPage().data, rec.getPage().len, 8);
                rec.getPage().len += 8;
                pos += 8;
            } else {
                long backLink;
                AbstractLoggable loggable;
                int realLen;
                short vlen = ByteConversion.byteToShort(oldData, pos);
                pos += 2;
                int n = realLen = vlen == 0 ? 8 : (int)vlen;
                if (nextSplitPage.len + 2 + 2 + 8 + realLen > this.fileHeader.getWorkSize()) {
                    DOMPage newPage = new DOMPage();
                    DOMFilePageHeader newPageHeader = newPage.getPageHeader();
                    if (transaction != null && this.isRecoveryEnabled()) {
                        loggable = new CreatePageLoggable(transaction, nextSplitPage.getPageNum(), newPage.getPageNum(), -1L, pageHeader.getCurrentTupleID());
                        this.writeToLog(loggable, firstSplitPage.page);
                        loggable = new UpdateHeaderLoggable(transaction, nextSplitPage.getPageHeader().getPreviousDataPage(), nextSplitPage.getPageNum(), newPage.getPageNum(), nextSplitPage.getPageHeader().getPreviousDataPage(), nextSplitPage.getPageHeader().getNextDataPage());
                        this.writeToLog(loggable, nextSplitPage.page);
                    }
                    newPageHeader.setNextTupleID(pageHeader.getCurrentTupleID());
                    newPageHeader.setPrevDataPage(nextSplitPage.getPageNum());
                    LOG.debug("Creating new split page: " + newPage.getPageNum());
                    nextSplitPage.getPageHeader().setNextDataPage(newPage.getPageNum());
                    nextSplitPage.getPageHeader().setDataLength(nextSplitPage.len);
                    nextSplitPage.getPageHeader().setRecordCount(splitRecordCount);
                    nextSplitPage.cleanUp();
                    nextSplitPage.setDirty(true);
                    this.dataCache.add(nextSplitPage);
                    this.dataCache.add(newPage);
                    nextSplitPage = newPage;
                    splitRecordCount = 0;
                }
                if (ItemId.isRelocated(tupleID)) {
                    backLink = ByteConversion.byteToLong(oldData, pos);
                    pos += 8;
                    RecordPos originalRecordPos = this.findRecord(backLink, false);
                    long oldLink = ByteConversion.byteToLong(originalRecordPos.getPage().data, originalRecordPos.offset);
                    long forwardLink = StorageAddress.createPointer((int)nextSplitPage.getPageNum(), ItemId.getId(tupleID));
                    if (transaction != null && this.isRecoveryEnabled()) {
                        UpdateLinkLoggable loggable2 = new UpdateLinkLoggable(transaction, originalRecordPos.getPage().getPageNum(), originalRecordPos.offset, forwardLink, oldLink);
                        this.writeToLog(loggable2, originalRecordPos.getPage().page);
                    }
                    ByteConversion.longToByte(forwardLink, originalRecordPos.getPage().data, originalRecordPos.offset);
                    originalRecordPos.getPage().setDirty(true);
                    this.dataCache.add(originalRecordPos.getPage());
                } else {
                    backLink = StorageAddress.createPointer((int)rec.getPage().getPageNum(), ItemId.getId(tupleID));
                }
                if (transaction != null && this.isRecoveryEnabled()) {
                    byte[] logData = new byte[realLen];
                    System.arraycopy(oldData, pos, logData, 0, realLen);
                    AddMovedValueLoggable loggable3 = new AddMovedValueLoggable(transaction, nextSplitPage.getPageNum(), tupleID, logData, backLink);
                    this.writeToLog(loggable3, nextSplitPage.page);
                }
                ByteConversion.shortToByte(ItemId.setIsRelocated(tupleID), nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 2;
                ByteConversion.shortToByte(vlen, nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 2;
                ByteConversion.longToByte(backLink, nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 8;
                try {
                    System.arraycopy(oldData, pos, nextSplitPage.data, nextSplitPage.len, realLen);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    SanityCheck.TRACE("pos = " + pos + "; len = " + nextSplitPage.len + "; currentLen = " + realLen + "; tupleID = " + tupleID + "; page = " + rec.getPage().getPageNum());
                    throw e;
                }
                nextSplitPage.len += realLen;
                pos += realLen;
                if (!ItemId.isRelocated(tupleID)) {
                    if (rec.getPage().len + 2 + 8 > this.fileHeader.getWorkSize()) {
                        DOMPage newPage = new DOMPage();
                        DOMFilePageHeader newPageHeader = newPage.getPageHeader();
                        if (transaction != null && this.isRecoveryEnabled()) {
                            loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), pageHeader.getNextDataPage(), pageHeader.getCurrentTupleID());
                            this.writeToLog(loggable, firstSplitPage.page);
                            loggable = new UpdateHeaderLoggable(transaction, pageHeader.getPreviousDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), pageHeader.getPreviousDataPage(), pageHeader.getNextDataPage());
                            this.writeToLog(loggable, nextSplitPage.page);
                        }
                        newPageHeader.setNextTupleID(pageHeader.getCurrentTupleID());
                        newPageHeader.setPrevDataPage(rec.getPage().getPageNum());
                        newPageHeader.setNextDataPage(pageHeader.getNextDataPage());
                        LOG.debug("Creating new page after split: " + newPage.getPageNum());
                        pageHeader.setNextDataPage(newPage.getPageNum());
                        pageHeader.setDataLength(rec.getPage().len);
                        pageHeader.setRecordCount(this.countRecordsInPage(rec.getPage()));
                        rec.getPage().cleanUp();
                        rec.getPage().setDirty(true);
                        this.dataCache.add(rec.getPage());
                        rec.setPage(newPage);
                        rec.getPage().len = 0;
                        this.dataCache.add(newPage);
                    }
                    long forwardLink = StorageAddress.createPointer((int)nextSplitPage.getPageNum(), ItemId.getId(tupleID));
                    if (transaction != null && this.isRecoveryEnabled()) {
                        loggable = new AddLinkLoggable(transaction, rec.getPage().getPageNum(), tupleID, forwardLink);
                        this.writeToLog(loggable, rec.getPage().page);
                    }
                    ByteConversion.shortToByte(ItemId.setIsLink(tupleID), rec.getPage().data, rec.getPage().len);
                    rec.getPage().len += 2;
                    ByteConversion.longToByte(forwardLink, rec.getPage().data, rec.getPage().len);
                    rec.getPage().len += 8;
                }
            }
            splitRecordCount = (short)(splitRecordCount + 1);
        }
        if (nextSplitPage.len == 0) {
            LOG.warn("Page " + nextSplitPage.getPageNum() + " is empty. Remove it");
            if (nextSplitPage == firstSplitPage) {
                firstSplitPage = null;
            }
            try {
                this.unlinkPages(nextSplitPage.page);
            }
            catch (IOException e) {
                LOG.warn("Failed to remove empty split page: " + e.getMessage(), (Throwable)e);
            }
            nextSplitPage.setDirty(true);
            this.dataCache.remove(nextSplitPage);
            nextSplitPage = null;
        } else {
            if (transaction != null && this.isRecoveryEnabled()) {
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, nextSplitPage.getPageHeader().getPreviousDataPage(), nextSplitPage.getPageNum(), pageHeader.getNextDataPage(), nextSplitPage.getPageHeader().getPreviousDataPage(), nextSplitPage.getPageHeader().getNextDataPage());
                this.writeToLog(loggable, nextSplitPage.page);
            }
            nextSplitPage.getPageHeader().setDataLength(nextSplitPage.len);
            nextSplitPage.getPageHeader().setNextDataPage(pageHeader.getNextDataPage());
            nextSplitPage.getPageHeader().setRecordCount(splitRecordCount);
            nextSplitPage.cleanUp();
            nextSplitPage.setDirty(true);
            this.dataCache.add(nextSplitPage);
            if (transaction != null && this.isRecoveryEnabled()) {
                DOMFilePageHeader fisrtPageHeader = firstSplitPage.getPageHeader();
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, rec.getPage().getPageNum(), firstSplitPage.getPageNum(), fisrtPageHeader.getNextDataPage(), fisrtPageHeader.getPreviousDataPage(), fisrtPageHeader.getNextDataPage());
                this.writeToLog(loggable, nextSplitPage.page);
            }
            firstSplitPage.getPageHeader().setPrevDataPage(rec.getPage().getPageNum());
            if (nextSplitPage != firstSplitPage) {
                firstSplitPage.setDirty(true);
                this.dataCache.add(firstSplitPage);
            }
        }
        long nextPageNum = pageHeader.getNextDataPage();
        if (-1L != nextPageNum) {
            DOMPage nextPage = this.getDOMPage(nextPageNum);
            if (transaction != null && this.isRecoveryEnabled()) {
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, nextSplitPage.getPageNum(), nextPage.getPageNum(), -1L, nextPage.getPageHeader().getPreviousDataPage(), nextPage.getPageHeader().getNextDataPage());
                this.writeToLog(loggable, nextPage.page);
            }
            nextPage.getPageHeader().setPrevDataPage(nextSplitPage.getPageNum());
            nextPage.setDirty(true);
            this.dataCache.add(nextPage);
        }
        rec.setPage(this.getDOMPage(rec.getPage().getPageNum()));
        if (firstSplitPage != null) {
            if (transaction != null && this.isRecoveryEnabled()) {
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, pageHeader.getPreviousDataPage(), rec.getPage().getPageNum(), firstSplitPage.getPageNum(), pageHeader.getPreviousDataPage(), pageHeader.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            pageHeader.setNextDataPage(firstSplitPage.getPageNum());
        }
        pageHeader.setDataLength(rec.getPage().len);
        pageHeader.setRecordCount(this.countRecordsInPage(rec.getPage()));
        rec.getPage().cleanUp();
        rec.offset = rec.getPage().len;
        return rec;
    }

    private short countRecordsInPage(DOMPage page) {
        short count = 0;
        int dataLength = page.getPageHeader().getDataLength();
        int pos = 0;
        while (pos < dataLength) {
            short tupleID = ByteConversion.byteToShort(page.data, pos);
            pos += 2;
            if (ItemId.isLink(tupleID)) {
                pos += 8;
            } else {
                short vlen = ByteConversion.byteToShort(page.data, pos);
                pos += 2;
                pos = ItemId.isRelocated(tupleID) ? (pos += vlen == 0 ? 16 : 8 + vlen) : (pos += vlen == 0 ? 8 : (int)vlen);
            }
            count = (short)(count + 1);
        }
        return count;
    }

    /*
     * Unable to fully structure code
     */
    public String debugPageContents(DOMPage page) {
        buf = new StringBuilder();
        buf.append("Page ").append(page.getPageNum()).append(": ");
        count = 0;
        dataLength = page.getPageHeader().getDataLength();
        pos = 0;
        while (pos < dataLength) {
            block37: {
                block39: {
                    block38: {
                        block36: {
                            buf.append(pos).append("/");
                            tupleID = ByteConversion.byteToShort(page.data, pos);
                            pos += 2;
                            buf.append(ItemId.getId(tupleID));
                            if (ItemId.isLink(tupleID)) {
                                buf.append("L");
                            } else if (ItemId.isRelocated(tupleID)) {
                                buf.append("R");
                            }
                            if (!ItemId.isLink(tupleID)) break block36;
                            forwardLink = ByteConversion.byteToLong(page.data, pos);
                            buf.append(':').append(forwardLink).append(" ");
                            pos += 8;
                            break block37;
                        }
                        valueLength = ByteConversion.byteToShort(page.data, pos);
                        pos += 2;
                        if (valueLength < 0) {
                            DOMFile.LOG.warn("Illegal length: " + valueLength);
                            return buf.append("[Illegal length : ").append(valueLength).append("] ").toString();
                        }
                        if (!ItemId.isRelocated(tupleID)) break block38;
                        pos += 8;
                        break block39;
                    }
                    buf.append("[");
                    switch (Signatures.getType(page.data[pos])) {
                        case 1: {
                            buf.append("element ");
                            readOffset = pos;
                            children = ByteConversion.byteToInt(page.data, ++readOffset);
                            dlnLen = ByteConversion.byteToShort(page.data, readOffset += 4);
                            readOffset += 2;
                            if (this.owner == null) {
                                buf.append("(Can't read data, owner is null)");
                                break;
                            }
                            try {
                                nodeId = ((NativeBroker)this.owner).getBrokerPool().getNodeFactory().createFromData(dlnLen, page.data, readOffset);
                                buf.append("(").append(nodeId.toString()).append(")");
                                attributes = ByteConversion.byteToShort(page.data, readOffset += nodeId.size());
                                buf.append(" children: ").append(children);
                                buf.append(" attributes: ").append(attributes);
                            }
                            catch (Exception e) {
                                buf.append("(Unable to read the node ID at: ").append(readOffset);
                                buf.append(" children : ").append(children);
                                buf.append(" attributes : unknown");
                            }
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (Signatures.getType(page.data[pos]) == 3) {
                                buf.append("text ");
                            } else {
                                buf.append("CDATA ");
                            }
                            readOffset = pos;
                            dlnLen = ByteConversion.byteToShort(page.data, ++readOffset);
                            readOffset += 2;
                            if (this.owner == null) {
                                buf.append("(Can't read data, owner is null)");
                                break;
                            }
                            try {
                                nodeId = ((NativeBroker)this.owner).getBrokerPool().getNodeFactory().createFromData(dlnLen, page.data, readOffset);
                                buf.append("(").append(nodeId.toString()).append(")");
                                os = new ByteArrayOutputStream();
                                os.write(page.data, readOffset += nodeId.size(), valueLength - (readOffset - pos));
                                value = new String(os.toByteArray(), StandardCharsets.UTF_8);
                                if (value.length() > 15) {
                                    value = value.substring(0, 8) + "..." + value.substring(value.length() - 8);
                                }
                                buf.append(":'").append(value).append("'");
                            }
                            catch (Exception e) {
                                buf.append("(unable to read the node ID at : ").append(readOffset);
                            }
                            break;
                        }
                        case 2: {
                            buf.append("[");
                            buf.append("attribute ");
                            readOffset = pos;
                            idSizeType = (byte)(page.data[readOffset] & 3);
                            hasNamespace = (page.data[readOffset] & 16) == 16;
                            dlnLen = ByteConversion.byteToShort(page.data, ++readOffset);
                            readOffset += 2;
                            if (this.owner != null) ** GOTO lbl113
                            buf.append("(can't read data, owner is null)");
                            ** GOTO lbl155
lbl113:
                            // 1 sources

                            try {
                                nodeId = ((NativeBroker)this.owner).getBrokerPool().getNodeFactory().createFromData(dlnLen, page.data, readOffset);
                                readOffset += nodeId.size();
                                buf.append("(").append(nodeId.toString()).append(")");
                                readOffset += Signatures.getLength(idSizeType);
                                if (hasNamespace) {
                                    NSId = ByteConversion.byteToShort(page.data, readOffset);
                                    prefixLen = ByteConversion.byteToShort(page.data, readOffset += 2);
                                    os = new ByteArrayOutputStream();
                                    os.write(page.data, readOffset += 2 + prefixLen, valueLength - (readOffset - prefixLen));
                                    prefix = new String(os.toByteArray(), StandardCharsets.UTF_8);
                                    NsURI = ((NativeBroker)this.owner).getBrokerPool().getSymbols().getNamespace(NSId);
                                    buf.append(prefix).append("{").append(NsURI).append("}");
                                }
                                os = new ByteArrayOutputStream();
                                var14_24 = null;
                                try {
                                    os.write(page.data, readOffset, valueLength - (readOffset - pos));
                                    value = new String(os.toByteArray(), StandardCharsets.UTF_8);
                                    if (value.length() > 15) {
                                        value = value.substring(0, 8) + "..." + value.substring(value.length() - 8);
                                    }
                                    buf.append(":'").append(value).append("'");
                                }
                                catch (Throwable var15_28) {
                                    var14_24 = var15_28;
                                    throw var15_28;
                                }
                                finally {
                                    if (os != null) {
                                        if (var14_24 != null) {
                                            try {
                                                os.close();
                                            }
                                            catch (Throwable var15_27) {
                                                var14_24.addSuppressed(var15_27);
                                            }
                                        } else {
                                            os.close();
                                        }
                                    }
                                }
                            }
                            catch (Exception e) {
                                buf.append("(unable to read the node ID at : ").append(readOffset);
                            }
lbl155:
                            // 3 sources

                            buf.append("] ");
                            break;
                        }
                        default: {
                            buf.append("Unknown node type !");
                        }
                    }
                    buf.append("] ");
                }
                pos += valueLength;
            }
            count = (short)(count + 1);
        }
        buf.append("; records in page: ").append(count).append(" (header says: ").append(page.getPageHeader().getRecordCount()).append(")");
        buf.append("; currentTupleID: ").append(page.getPageHeader().getCurrentTupleID());
        buf.append("; data length: ").append(page.getPageHeader().getDataLength());
        for (i = page.data.length; i > 0; --i) {
            if (page.data[i - 1] == 0) continue;
            buf.append(" (last non-zero byte: ").append(i).append(")");
            break;
        }
        return buf.toString();
    }

    @Override
    public Paged.FileHeader createFileHeader(int pageSize) {
        return new BTree.BTreeFileHeader(1024L, pageSize);
    }

    @Override
    protected void unlinkPages(Paged.Page page) throws IOException {
        super.unlinkPages(page);
    }

    @Override
    public Paged.PageHeader createPageHeader() {
        return new DOMFilePageHeader();
    }

    public List<Value> findKeys(IndexQuery query) throws IOException, BTreeException {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        FindCallback callBack = new FindCallback(1);
        try {
            this.query(query, callBack);
        }
        catch (TerminatedException e) {
            LOG.error("Method terminated");
        }
        return callBack.getValues();
    }

    protected long findValue(DBBroker broker, NodeProxy node) throws IOException, BTreeException {
        DocumentImpl doc;
        NativeBroker.NodeRef nodeRef;
        long pointer;
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        if ((pointer = this.findValue(nodeRef = new NativeBroker.NodeRef((doc = node.getOwnerDocument()).getDocId(), node.getNodeId()))) == -1L) {
            NodeId nodeID = node.getNodeId();
            long parentPointer = -1L;
            do {
                if ((nodeID = nodeID.getParentId()) == null) {
                    SanityCheck.TRACE("Node " + node.getOwnerDocument().getDocId() + ":" + nodeID + " not found.");
                    throw new BTreeException("Node not found.");
                }
                if (nodeID == NodeId.DOCUMENT_NODE) {
                    SanityCheck.TRACE("Node " + node.getOwnerDocument().getDocId() + ":" + nodeID + " not found.");
                    throw new BTreeException("Node " + nodeID + " not found.");
                }
                NativeBroker.NodeRef parentRef = new NativeBroker.NodeRef(doc.getDocId(), nodeID);
                try {
                    parentPointer = this.findValue(parentRef);
                }
                catch (BTreeException bte) {
                    LOG.error("report me", (Throwable)bte);
                }
            } while (parentPointer == -1L);
            try {
                NodeProxy parent = new NodeProxy(doc, nodeID, parentPointer);
                EmbeddedXMLStreamReader cursor = (EmbeddedXMLStreamReader)broker.getXMLStreamReader(parent, true);
                while (cursor.hasNext()) {
                    NodeId nextId;
                    int status = cursor.next();
                    if (status == 2 || !(nextId = (NodeId)cursor.getProperty("node-id")).equals(node.getNodeId())) continue;
                    return cursor.getCurrentPosition();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Node " + node.getNodeId() + " could not be found. Giving up. This is usually not an error.");
                }
                return -1L;
            }
            catch (XMLStreamException e) {
                SanityCheck.TRACE("Node " + node.getOwnerDocument().getDocId() + ":" + node.getNodeId() + " not found.");
                throw new BTreeException("Node " + node.getNodeId() + " not found.");
            }
        }
        return pointer;
    }

    public List<Value> findValues(IndexQuery query) throws IOException, BTreeException {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        FindCallback callBack = new FindCallback(0);
        try {
            this.query(query, callBack);
        }
        catch (TerminatedException e) {
            LOG.warn("Method terminated");
        }
        return callBack.getValues();
    }

    @Override
    public boolean flush() throws DBException {
        boolean flushed = false;
        if (this.isRecoveryEnabled()) {
            ((JournalManager)this.logManager.get()).flush(true, false);
        }
        if (!BrokerPool.FORCE_CORRUPTION) {
            flushed |= super.flush();
            flushed |= this.dataCache.flush();
        }
        return flushed;
    }

    @Override
    public void printStatistics() {
        super.printStatistics();
        NumberFormat nf1 = NumberFormat.getPercentInstance();
        NumberFormat nf2 = NumberFormat.getInstance();
        StringBuilder buf = new StringBuilder();
        buf.append(FileUtils.fileName(this.getFile())).append(" DATA ");
        buf.append("Buffers occupation : ");
        if (this.dataCache.getBuffers() == 0 && this.dataCache.getUsedBuffers() == 0) {
            buf.append("N/A");
        } else {
            buf.append(nf1.format((float)this.dataCache.getUsedBuffers() / (float)this.dataCache.getBuffers()));
        }
        buf.append(" (").append(nf2.format(this.dataCache.getUsedBuffers())).append(" out of ").append(nf2.format(this.dataCache.getBuffers())).append(")");
        buf.append(" Cache efficiency : ");
        if (this.dataCache.getHits() == 0 && this.dataCache.getFails() == 0) {
            buf.append("N/A");
        } else {
            buf.append(nf1.format((float)this.dataCache.getHits() / (float)(this.dataCache.getFails() + this.dataCache.getHits())));
        }
        LOGSTATS.info(buf.toString());
    }

    public BufferStats getDataBufferStats() {
        return new BufferStats(this.dataCache.getBuffers(), this.dataCache.getUsedBuffers(), this.dataCache.getHits(), this.dataCache.getFails());
    }

    public Value get(Value key) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        try {
            long pointer = this.findValue(key);
            if (pointer == -1L) {
                LOG.warn("Value not found : " + key);
                return null;
            }
            return this.get(pointer);
        }
        catch (IOException | BTreeException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public Value get(DBBroker broker, NodeProxy node) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        try {
            long pointer = this.findValue(broker, node);
            if (pointer == -1L) {
                return null;
            }
            return this.get(pointer);
        }
        catch (IOException | BTreeException e) {
            LOG.warn((Object)e);
            return null;
        }
    }

    public Value get(long pointer) {
        return this.get(pointer, true);
    }

    public Value get(long pointer, boolean warnIfMissing) {
        Value value;
        RecordPos rec;
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        if ((rec = this.findRecord(pointer)) == null) {
            if (warnIfMissing) {
                SanityCheck.TRACE("Object at " + StorageAddress.toString(pointer) + " not found.");
            }
            return null;
        }
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTupleID())) {
            rec.offset += 8;
        }
        if (vlen == 0) {
            long pageNo = ByteConversion.byteToLong(rec.getPage().data, rec.offset);
            byte[] data = this.getOverflowValue(pageNo);
            value = new Value(data);
        } else {
            value = new Value(rec.getPage().data, rec.offset, vlen);
        }
        value.setAddress(pointer);
        return value;
    }

    @Override
    protected void dumpValue(Writer writer, Value key, int status) throws IOException {
        if (status == 2) {
            super.dumpValue(writer, key, status);
            return;
        }
        if (key.getLength() == 0) {
            return;
        }
        writer.write(Integer.toString(ByteConversion.byteToInt(key.data(), key.start())));
        writer.write(58);
        try {
            int bytes = key.getLength() - 4;
            byte[] data = key.data();
            for (int i = 0; i < bytes; ++i) {
                writer.write(DLNBase.toBitString(data[key.start() + 4 + i]));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage() + ": doc: " + Integer.toString(ByteConversion.byteToInt(key.data(), key.start())), (Throwable)e);
        }
    }

    public long put(Txn transaction, Value key, byte[] value) throws ReadOnlyException {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        long pointer = this.add(transaction, value);
        try {
            this.addValue(transaction, key, pointer);
        }
        catch (IOException | BTreeException e) {
            LOG.error((Object)e);
            return -1L;
        }
        return pointer;
    }

    public void remove(Txn transaction, Value key) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        try {
            long pointer = this.findValue(key);
            if (pointer == -1L) {
                LOG.error("Value not found: " + key);
                return;
            }
            this.remove(transaction, key, pointer);
        }
        catch (IOException | BTreeException e) {
            LOG.warn((Object)e);
        }
    }

    protected byte[] getOverflowValue(long pointer) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pointer);
            return overflow.read();
        }
        catch (IOException e) {
            LOG.warn("IO error while loading overflow value", (Throwable)e);
            return null;
        }
    }

    public void removeOverflowValue(Txn transaction, long pointer) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pointer);
            overflow.delete(transaction);
        }
        catch (IOException e) {
            LOG.error("IO error while removing overflow value", (Throwable)e);
        }
    }

    private void removeLink(Txn transaction, long pointer) {
        AbstractLoggable loggable;
        RecordPos rec = this.findRecord(pointer, false);
        DOMFilePageHeader pageHeader = rec.getPage().getPageHeader();
        if (transaction != null && this.isRecoveryEnabled()) {
            byte[] data = new byte[8];
            System.arraycopy(rec.getPage().data, rec.offset, data, 0, 8);
            loggable = new RemoveValueLoggable(transaction, rec.getPage().getPageNum(), rec.getTupleID(), rec.offset - 2, data, false, 0L);
            this.writeToLog(loggable, rec.getPage().page);
        }
        int end = rec.offset + 8;
        System.arraycopy(rec.getPage().data, end, rec.getPage().data, rec.offset - 2, rec.getPage().len - end);
        rec.getPage().len -= 10;
        if (rec.getPage().len < 0) {
            LOG.warn("Page length < 0");
        }
        pageHeader.setDataLength(rec.getPage().len);
        pageHeader.decRecordCount();
        if (rec.getPage().len == 0) {
            if (pageHeader.getRecordCount() > 0) {
                LOG.warn("Empty page seems to have record!");
            }
            if (transaction != null && this.isRecoveryEnabled()) {
                loggable = new RemoveEmptyPageLoggable(transaction, rec.getPage().getPageNum(), pageHeader.getPreviousDataPage(), pageHeader.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            this.removePage(rec.getPage());
            rec.setPage(null);
        } else {
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
        }
    }

    public void removeNode(Txn transaction, long pointer) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        RecordPos rec = this.findRecord(pointer);
        int startOffset = rec.offset - 2;
        DOMFilePageHeader pageHeader = rec.getPage().getPageHeader();
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        short realLen = vlen;
        if (ItemId.isLink(rec.getTupleID())) {
            throw new RuntimeException("Cannot remove link ...");
        }
        boolean isOverflow = false;
        long backLink = 0L;
        if (ItemId.isRelocated(rec.getTupleID())) {
            backLink = ByteConversion.byteToLong(rec.getPage().data, rec.offset);
            rec.offset += 8;
            realLen = (short)(realLen + 8);
            this.removeLink(transaction, backLink);
        }
        if (vlen == 0) {
            isOverflow = true;
            long overflowLink = ByteConversion.byteToLong(rec.getPage().data, rec.offset);
            rec.offset += 8;
            try {
                OverflowDOMPage overflow = new OverflowDOMPage(overflowLink);
                overflow.delete(transaction);
            }
            catch (IOException e) {
                LOG.warn("IO error while removing overflow page", (Throwable)e);
            }
            realLen = (short)(realLen + 8);
        }
        if (transaction != null && this.isRecoveryEnabled()) {
            byte[] data = new byte[vlen == 0 ? 8 : (int)vlen];
            System.arraycopy(rec.getPage().data, rec.offset, data, 0, vlen == 0 ? 8 : (int)vlen);
            RemoveValueLoggable loggable = new RemoveValueLoggable(transaction, rec.getPage().getPageNum(), rec.getTupleID(), startOffset, data, isOverflow, backLink);
            this.writeToLog(loggable, rec.getPage().page);
        }
        int dataLength = pageHeader.getDataLength();
        int end = startOffset + 2 + 2 + realLen;
        System.arraycopy(rec.getPage().data, end, rec.getPage().data, startOffset, dataLength - end);
        rec.getPage().setDirty(true);
        rec.getPage().len = dataLength - (4 + realLen);
        if (rec.getPage().len < 0) {
            LOG.error("Page length < 0");
        }
        rec.getPage().setDirty(true);
        pageHeader.setDataLength(rec.getPage().len);
        pageHeader.decRecordCount();
        if (rec.getPage().len == 0) {
            LOG.debug("Removing page " + rec.getPage().getPageNum());
            if (pageHeader.getRecordCount() > 0) {
                LOG.warn("Empty page seems to have record !");
            }
            if (transaction != null && this.isRecoveryEnabled()) {
                RemoveEmptyPageLoggable loggable = new RemoveEmptyPageLoggable(transaction, rec.getPage().getPageNum(), rec.getPage().pageHeader.getPreviousDataPage(), rec.getPage().pageHeader.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            this.removePage(rec.getPage());
            rec.setPage(null);
        } else {
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
        }
    }

    public void remove(Txn transaction, Value key, long pointer) {
        this.removeNode(transaction, pointer);
        try {
            this.removeValue(transaction, key);
        }
        catch (IOException | BTreeException e) {
            LOG.error("BTree error while removing node", (Throwable)e);
        }
    }

    private void removePage(DOMPage page) {
        DOMFilePageHeader pageHeader;
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        if ((pageHeader = page.getPageHeader()).getNextDataPage() != -1L) {
            DOMPage nextPage = this.getDOMPage(pageHeader.getNextDataPage());
            nextPage.getPageHeader().setPrevDataPage(pageHeader.getPreviousDataPage());
            nextPage.setDirty(true);
            this.dataCache.add(nextPage);
        }
        if (pageHeader.getPreviousDataPage() != -1L) {
            DOMPage previousPage = this.getDOMPage(pageHeader.getPreviousDataPage());
            previousPage.getPageHeader().setNextDataPage(pageHeader.getNextDataPage());
            previousPage.setDirty(true);
            this.dataCache.add(previousPage);
        }
        try {
            pageHeader.setNextDataPage(-1L);
            pageHeader.setPrevDataPage(-1L);
            pageHeader.setDataLength(0);
            pageHeader.setNextTupleID((short)-1);
            pageHeader.setRecordCount((short)0);
            this.unlinkPages(page.page);
            page.setDirty(true);
            this.dataCache.remove(page);
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
        }
        if (this.currentDocument != null) {
            this.currentDocument.getMetadata().decPageCount();
        }
    }

    public void removeAll(Txn transaction, long pointer) {
        long pageNum;
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        if ((pageNum = (long)StorageAddress.pageFromPointer(pointer)) == -1L) {
            LOG.error("Tried to remove unknown page");
        }
        while (pageNum != -1L) {
            DOMPage currentPage = this.getDOMPage(pageNum);
            DOMFilePageHeader currentPageHeader = currentPage.getPageHeader();
            if (transaction != null && this.isRecoveryEnabled()) {
                RemovePageLoggable loggable = new RemovePageLoggable(transaction, pageNum, currentPageHeader.getPreviousDataPage(), currentPageHeader.getNextDataPage(), currentPage.data, currentPage.len, currentPageHeader.getCurrentTupleID(), currentPageHeader.getRecordCount());
                this.writeToLog(loggable, currentPage.page);
            }
            pageNum = currentPageHeader.getNextDataPage();
            try {
                currentPageHeader.setNextDataPage(-1L);
                currentPageHeader.setPrevDataPage(-1L);
                currentPageHeader.setDataLength(0);
                currentPageHeader.setNextTupleID((short)-1);
                currentPageHeader.setRecordCount((short)0);
                currentPage.len = 0;
                this.unlinkPages(currentPage.page);
                currentPage.setDirty(true);
                this.dataCache.remove(currentPage);
            }
            catch (IOException e) {
                LOG.error("Error while removing page: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public String debugPages(DocumentImpl doc, boolean showPageContents) {
        StringBuilder buf = new StringBuilder();
        buf.append("Pages used by ").append(doc.getURI());
        buf.append("; (docId: ").append(doc.getDocId()).append("): ");
        long pageNum = StorageAddress.pageFromPointer(((IStoredNode)doc.getFirstChild()).getInternalAddress());
        while (pageNum != -1L) {
            DOMPage page = this.getDOMPage(pageNum);
            DOMFilePageHeader pageHeader = page.getPageHeader();
            this.dataCache.add(page);
            buf.append(' ').append(pageNum);
            pageNum = pageHeader.getNextDataPage();
            if (!showPageContents) continue;
            LOG.debug(this.debugPageContents(page));
        }
        return buf.toString();
    }

    public boolean update(Txn transaction, Value key, byte[] value) throws ReadOnlyException {
        try {
            long pointer = this.findValue(key);
            if (pointer == -1L) {
                LOG.warn("Node value not found : " + key);
                return false;
            }
            this.update(transaction, pointer, value);
            return true;
        }
        catch (IOException | BTreeException e) {
            LOG.error((Object)e);
            e.printStackTrace();
            return false;
        }
    }

    public void update(Txn transaction, long pointer, byte[] value) throws ReadOnlyException {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn("The file doesn't own a write lock");
        }
        RecordPos recordPos = this.findRecord(pointer);
        short valueLength = ByteConversion.byteToShort(recordPos.getPage().data, recordPos.offset);
        recordPos.offset += 2;
        if (ItemId.isRelocated(recordPos.getTupleID())) {
            recordPos.offset += 8;
        }
        if (value.length < valueLength) {
            throw new IllegalStateException("Value too short. Expected: " + value.length + "; got: " + valueLength);
        }
        if (value.length > valueLength) {
            throw new IllegalStateException("Value too long. Expected: " + value.length + "; got: " + valueLength);
        }
        if (transaction != null && this.isRecoveryEnabled()) {
            if (ItemId.getId(recordPos.getTupleID()) < 0) {
                LOG.error("Tuple ID < 0");
            }
            UpdateValueLoggable loggable = new UpdateValueLoggable(transaction, recordPos.getPage().getPageNum(), recordPos.getTupleID(), value, recordPos.getPage().data, recordPos.offset);
            this.writeToLog(loggable, recordPos.getPage().page);
        }
        System.arraycopy(value, 0, recordPos.getPage().data, recordPos.offset, value.length);
        recordPos.getPage().setDirty(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNodeValue(DBBroker broker, IStoredNode node, boolean addWhitespace) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        try {
            long address = node.getInternalAddress();
            RecordPos recordPos = null;
            if (StorageAddress.hasAddress(address)) {
                recordPos = this.findRecord(address);
            }
            if (recordPos == null) {
                address = this.findValue(broker, new NodeProxy(node));
                if (address == -1L) {
                    LOG.error("Node value not found: " + node);
                    return null;
                }
                recordPos = this.findRecord(address);
                SanityCheck.THROW_ASSERT(recordPos != null, "Node data could not be found!");
            }
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                this.getNodeValue(broker.getBrokerPool(), (DocumentImpl)node.getOwnerDocument(), os, recordPos, true, addWhitespace);
                byte[] data = os.toByteArray();
                String string = new String(data, StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (BTreeException e) {
            LOG.error("BTree error while reading node value", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error("IO error while reading node value", (Throwable)e);
        }
        return null;
    }

    private void getNodeValue(BrokerPool pool, DocumentImpl doc, ByteArrayOutputStream os, RecordPos rec, boolean isTopNode, boolean addWhitespace) {
        int valueLength;
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        boolean foundNext = false;
        do {
            DOMFilePageHeader pageHeader;
            if (rec.offset > (pageHeader = rec.getPage().getPageHeader()).getDataLength()) {
                long nextPage = pageHeader.getNextDataPage();
                if (nextPage == -1L) {
                    SanityCheck.TRACE("Bad link to next page! Offset: " + rec.offset + ", Len: " + pageHeader.getDataLength() + ", Page info : " + rec.getPage().page.getPageInfo());
                    return;
                }
                rec.setPage(this.getDOMPage(nextPage));
                this.dataCache.add(rec.getPage());
                rec.offset = 2;
            }
            short tupleID = ByteConversion.byteToShort(rec.getPage().data, rec.offset - 2);
            rec.setTupleID(tupleID);
            if (ItemId.isLink(rec.getTupleID())) {
                rec.offset += 10;
                continue;
            }
            foundNext = true;
        } while (!foundNext);
        int realLen = valueLength = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTupleID())) {
            rec.offset += 8;
        }
        byte[] data = rec.getPage().data;
        int readOffset = rec.offset;
        boolean inOverflow = false;
        if (valueLength == 0) {
            long p = ByteConversion.byteToLong(data, rec.offset);
            data = this.getOverflowValue(p);
            rec.offset += 10;
            realLen = data.length;
            readOffset = 0;
            inOverflow = true;
        }
        short type = Signatures.getType(data[readOffset]);
        ++readOffset;
        switch (type) {
            case 1: {
                int children = ByteConversion.byteToInt(data, readOffset);
                short dlnLen = ByteConversion.byteToShort(data, readOffset += 4);
                int nodeIdLen = pool.getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                short attributes = ByteConversion.byteToShort(data, readOffset += nodeIdLen);
                rec.offset += realLen + 2;
                boolean extraWhitespace = addWhitespace && children - attributes > 1;
                for (int i = 0; i < children; ++i) {
                    this.getNodeValue(pool, doc, os, rec, false, addWhitespace);
                    if (!extraWhitespace) continue;
                    os.write(32);
                }
                return;
            }
            case 3: 
            case 4: {
                short dlnLen = ByteConversion.byteToShort(data, readOffset);
                int nodeIdLen = pool.getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                os.write(data, readOffset += nodeIdLen, realLen - (3 + nodeIdLen));
                break;
            }
            case 7: {
                short dlnLen = ByteConversion.byteToShort(data, readOffset);
                int nodeIdLen = pool.getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                int targetLen = ByteConversion.byteToInt(data, readOffset += nodeIdLen);
                os.write(data, readOffset += 4 + targetLen, realLen - (3 + nodeIdLen + targetLen + 4));
                break;
            }
            case 2: {
                if (!isTopNode) break;
                int start = readOffset - 1;
                byte idSizeType = (byte)(data[start] & 3);
                boolean hasNamespace = (data[start] & 0x10) == 16;
                short dlnLen = ByteConversion.byteToShort(data, readOffset);
                int nodeIdLen = pool.getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                readOffset += nodeIdLen;
                readOffset += Signatures.getLength(idSizeType);
                if (hasNamespace) {
                    short prefixLen = ByteConversion.byteToShort(data, readOffset += 2);
                    readOffset += 2;
                    readOffset += prefixLen;
                }
                os.write(data, readOffset, realLen - (readOffset - start));
                break;
            }
            case 8: {
                if (!isTopNode) break;
                short dlnLen = ByteConversion.byteToShort(data, readOffset);
                int nodeIdLen = pool.getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                os.write(data, readOffset += nodeIdLen, realLen - (3 + nodeIdLen));
            }
        }
        if (!inOverflow) {
            rec.offset += realLen + 2;
        }
    }

    protected RecordPos findRecord(long pointer) {
        return this.findRecord(pointer, true);
    }

    protected RecordPos findRecord(long pointer, boolean skipLinks) {
        if (!this.lock.hasLock()) {
            LOG.warn("The file doesn't own a lock");
        }
        long pageNum = StorageAddress.pageFromPointer(pointer);
        short tupleID = StorageAddress.tidFromPointer(pointer);
        while (pageNum != -1L) {
            DOMPage page = this.getDOMPage(pageNum);
            this.dataCache.add(page);
            RecordPos rec = page.findRecord(tupleID);
            if (rec == null) {
                pageNum = page.getPageHeader().getNextDataPage();
                if (pageNum != page.getPageNum()) continue;
                SanityCheck.TRACE("Circular link to next page on " + pageNum);
                return null;
            }
            if (rec.isLink()) {
                if (!skipLinks) {
                    return rec;
                }
                long forwardLink = ByteConversion.byteToLong(page.data, rec.offset);
                pageNum = StorageAddress.pageFromPointer(forwardLink);
                tupleID = StorageAddress.tidFromPointer(forwardLink);
                continue;
            }
            return rec;
        }
        return null;
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    public final synchronized void setOwnerObject(Object ownerObject) {
        if (ownerObject == null) {
            LOG.error("setOwnerObject(null)");
        }
        this.owner = ownerObject;
    }

    private boolean requiresRedo(Loggable loggable, DOMPage page) {
        return loggable.getLsn() > page.getPageHeader().getLsn();
    }

    protected void redoCreatePage(CreatePageLoggable loggable) {
        DOMPage newPage = this.getDOMPage(loggable.newPage);
        DOMFilePageHeader newPageHeader = newPage.getPageHeader();
        if (newPageHeader.getLsn() == -1L || this.requiresRedo((Loggable)loggable, newPage)) {
            try {
                this.reuseDeleted(newPage.page);
                newPageHeader.setStatus((byte)20);
                newPageHeader.setDataLength(0);
                newPageHeader.setNextTupleID((short)-1);
                newPageHeader.setRecordCount((short)0);
                newPage.len = 0;
                newPage.data = new byte[this.fileHeader.getWorkSize()];
                newPageHeader.setPrevDataPage(-1L);
                if (loggable.nextTID != -1) {
                    newPageHeader.setNextTupleID(loggable.nextTID);
                }
                newPageHeader.setLsn(loggable.getLsn());
                newPage.setDirty(true);
                if (loggable.nextPage == -1L) {
                    newPageHeader.setNextDataPage(-1L);
                } else {
                    newPageHeader.setNextDataPage(loggable.nextPage);
                }
                if (loggable.prevPage == -1L) {
                    newPageHeader.setPrevDataPage(-1L);
                } else {
                    newPageHeader.setPrevDataPage(loggable.prevPage);
                }
            }
            catch (IOException e) {
                LOG.error("Failed to redo " + loggable.dump() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        this.dataCache.add(newPage);
    }

    protected void undoCreatePage(CreatePageLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.newPage);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        try {
            pageHeader.setNextDataPage(-1L);
            pageHeader.setPrevDataPage(-1L);
            pageHeader.setDataLength(0);
            pageHeader.setNextTupleID((short)-1);
            pageHeader.setRecordCount((short)0);
            page.len = 0;
            this.unlinkPages(page.page);
            page.setDirty(true);
            this.dataCache.remove(page);
        }
        catch (IOException e) {
            LOG.warn("Error while removing page: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void redoAddValue(AddValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            try {
                ByteConversion.shortToByte(loggable.tid, page.data, page.len);
                page.len += 2;
                short vlen = (short)loggable.value.length;
                ByteConversion.shortToByte(vlen, page.data, page.len);
                page.len += 2;
                System.arraycopy(loggable.value, 0, page.data, page.len, vlen);
                page.len += vlen;
                pageHeader.incRecordCount();
                pageHeader.setDataLength(page.len);
                page.setDirty(true);
                pageHeader.setNextTupleID(loggable.tid);
                pageHeader.setLsn(loggable.getLsn());
                this.dataCache.add(page, 2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.warn("page: " + page.getPageNum() + "; len = " + page.len + "; value = " + loggable.value.length);
                throw e;
            }
        }
    }

    protected void undoAddValue(AddValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        RecordPos pos = page.findRecord(ItemId.getId(loggable.tid));
        SanityCheck.ASSERT(pos != null, "Record not found!");
        int startOffset = pos.offset - 2;
        short vlen = ByteConversion.byteToShort(page.data, pos.offset);
        int end = startOffset + 2 + 2 + vlen;
        int dlen = pageHeader.getDataLength();
        System.arraycopy(page.data, end, page.data, startOffset, dlen - end);
        page.len = dlen - (4 + vlen);
        if (page.len < 0) {
            LOG.error("page length < 0");
        }
        pageHeader.setDataLength(page.len);
        pageHeader.decRecordCount();
        page.setDirty(true);
    }

    protected void redoUpdateValue(UpdateValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            RecordPos rec = page.findRecord(ItemId.getId(loggable.tid));
            SanityCheck.THROW_ASSERT(rec != null, "tid " + ItemId.getId(loggable.tid) + " not found on page " + page.getPageNum() + "; contents: " + this.debugPageContents(page));
            rec.offset += 2;
            if (ItemId.isRelocated(rec.getTupleID())) {
                rec.offset += 8;
            }
            System.arraycopy(loggable.value, 0, rec.getPage().data, rec.offset, loggable.value.length);
            rec.getPage().getPageHeader().setLsn(loggable.getLsn());
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
        }
    }

    protected void undoUpdateValue(UpdateValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        RecordPos rec = page.findRecord(ItemId.getId(loggable.tid));
        SanityCheck.THROW_ASSERT(rec != null, "tid " + ItemId.getId(loggable.tid) + " not found on page " + page.getPageNum() + "; contents: " + this.debugPageContents(page));
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        SanityCheck.THROW_ASSERT(vlen == loggable.oldValue.length);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTupleID())) {
            rec.offset += 8;
        }
        System.arraycopy(loggable.oldValue, 0, page.data, rec.offset, loggable.oldValue.length);
        page.getPageHeader().setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoRemoveValue(RemoveValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            RecordPos pos = page.findRecord(ItemId.getId(loggable.tid));
            SanityCheck.ASSERT(pos != null, "Record not found: " + ItemId.getId(loggable.tid) + ": " + page.page.getPageInfo() + "\n" + this.debugPageContents(page));
            int startOffset = pos.offset - 2;
            if (ItemId.isLink(loggable.tid)) {
                int end = pos.offset + 8;
                System.arraycopy(page.data, end, page.data, startOffset, page.len - end);
                page.len -= 10;
            } else {
                short l = ByteConversion.byteToShort(page.data, pos.offset);
                if (ItemId.isRelocated(loggable.tid)) {
                    pos.offset += 8;
                    l = (short)(l + 8);
                }
                if (l == 0) {
                    l = (short)(l + 8);
                }
                int end = startOffset + 2 + 2 + l;
                int dlen = pageHeader.getDataLength();
                System.arraycopy(page.data, end, page.data, startOffset, dlen - end);
                page.setDirty(true);
                page.len = dlen - (4 + l);
            }
            if (page.len < 0) {
                LOG.error("page length < 0");
            }
            pageHeader.setDataLength(page.len);
            pageHeader.decRecordCount();
            pageHeader.setLsn(loggable.getLsn());
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoRemoveValue(RemoveValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        int offset = loggable.offset;
        short vlen = (short)loggable.oldData.length;
        if (offset < pageHeader.getDataLength()) {
            int required = ItemId.isLink(loggable.tid) ? 10 : 4 + vlen;
            if (ItemId.isRelocated(loggable.tid)) {
                required += 8;
            }
            int end = offset + required;
            try {
                System.arraycopy(page.data, offset, page.data, end, pageHeader.getDataLength() - offset);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error((Object)e);
                SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + ItemId.getId(loggable.tid) + "; required: " + required + "; offset: " + offset + "; end: " + end + "; len: " + (pageHeader.getDataLength() - offset) + "; avail: " + page.data.length + "; work: " + this.fileHeader.getWorkSize());
            }
        }
        ByteConversion.shortToByte(loggable.tid, page.data, offset);
        offset += 2;
        if (ItemId.isLink(loggable.tid)) {
            System.arraycopy(loggable.oldData, 0, page.data, offset, 8);
            page.len += 10;
        } else {
            if (loggable.isOverflow) {
                ByteConversion.shortToByte((short)0, page.data, offset);
            } else {
                ByteConversion.shortToByte(vlen, page.data, offset);
            }
            offset += 2;
            if (ItemId.isRelocated(loggable.tid)) {
                ByteConversion.longToByte(loggable.backLink, page.data, offset);
                offset += 8;
                page.len += 8;
            }
            System.arraycopy(loggable.oldData, 0, page.data, offset, vlen);
            page.len += 4 + vlen;
        }
        pageHeader.incRecordCount();
        pageHeader.setDataLength(page.len);
        page.setDirty(true);
        this.dataCache.add(page, 2);
    }

    protected void redoRemoveEmptyPage(RemoveEmptyPageLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            this.removePage(page);
        }
    }

    protected void undoRemoveEmptyPage(RemoveEmptyPageLoggable loggable) {
        try {
            DOMFilePageHeader oldPageHeader;
            DOMPage oldPage;
            DOMPage newPage = this.getDOMPage(loggable.pageNum);
            DOMFilePageHeader newPageHeader = newPage.getPageHeader();
            this.reuseDeleted(newPage.page);
            if (loggable.prevPage == -1L) {
                newPageHeader.setPrevDataPage(-1L);
            } else {
                oldPage = this.getDOMPage(loggable.prevPage);
                oldPageHeader = oldPage.getPageHeader();
                newPageHeader.setPrevDataPage(oldPage.getPageNum());
                oldPageHeader.setNextDataPage(newPage.getPageNum());
                oldPage.setDirty(true);
                this.dataCache.add(oldPage);
            }
            if (loggable.nextPage == -1L) {
                newPageHeader.setNextDataPage(-1L);
            } else {
                oldPage = this.getDOMPage(loggable.nextPage);
                oldPageHeader = oldPage.getPageHeader();
                oldPageHeader.setPrevDataPage(newPage.getPageNum());
                newPageHeader.setNextDataPage(loggable.nextPage);
                oldPage.setDirty(true);
                this.dataCache.add(oldPage);
            }
            newPageHeader.setNextTupleID((short)-1);
            newPage.setDirty(true);
            this.dataCache.add(newPage);
        }
        catch (IOException e) {
            LOG.error("Error during undo: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void redoRemovePage(RemovePageLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            try {
                pageHeader.setNextDataPage(-1L);
                pageHeader.setPrevDataPage(-1L);
                pageHeader.setDataLen(this.fileHeader.getWorkSize());
                pageHeader.setDataLength(0);
                pageHeader.setNextTupleID((short)-1);
                pageHeader.setRecordCount((short)0);
                page.len = 0;
                this.unlinkPages(page.page);
                page.setDirty(true);
                this.dataCache.remove(page);
            }
            catch (IOException e) {
                LOG.warn("Error while removing page: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void undoRemovePage(RemovePageLoggable loggable) {
        try {
            DOMPage page = this.getDOMPage(loggable.pageNum);
            DOMFilePageHeader pageHeader = page.getPageHeader();
            this.reuseDeleted(page.page);
            pageHeader.setStatus((byte)20);
            pageHeader.setNextDataPage(loggable.nextPage);
            pageHeader.setPrevDataPage(loggable.prevPage);
            pageHeader.setNextTupleID(ItemId.getId(loggable.oldTid));
            pageHeader.setRecordCount(loggable.oldRecCnt);
            pageHeader.setDataLength(loggable.oldLen);
            System.arraycopy(loggable.oldData, 0, page.data, 0, loggable.oldLen);
            page.len = loggable.oldLen;
            page.setDirty(true);
            this.dataCache.add(page);
        }
        catch (IOException e) {
            LOG.warn("Failed to undo " + loggable.dump() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void redoWriteOverflow(WriteOverflowPageLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            Paged.PageHeader pageHeader = page.getPageHeader();
            this.reuseDeleted(page);
            pageHeader.setStatus((byte)20);
            if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
                if (loggable.nextPage == -1L) {
                    pageHeader.setNextPage(-1L);
                } else {
                    pageHeader.setNextPage(loggable.nextPage);
                }
                pageHeader.setLsn(loggable.getLsn());
                this.writeValue(page, loggable.value);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to redo " + loggable.dump() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void undoWriteOverflow(WriteOverflowPageLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            this.unlinkPages(page);
        }
        catch (IOException e) {
            LOG.warn("Failed to undo " + loggable.dump() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void redoRemoveOverflow(RemoveOverflowLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            Paged.PageHeader pageHeader = page.getPageHeader();
            if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
                this.unlinkPages(page);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to undo " + loggable.dump() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void undoRemoveOverflow(RemoveOverflowLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            Paged.PageHeader pageHeader = page.getPageHeader();
            this.reuseDeleted(page);
            pageHeader.setStatus((byte)20);
            if (loggable.nextPage == -1L) {
                pageHeader.setNextPage(-1L);
            } else {
                pageHeader.setNextPage(loggable.nextPage);
            }
            this.writeValue(page, loggable.oldData);
        }
        catch (IOException e) {
            LOG.warn("Failed to redo " + loggable.dump() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    protected void redoInsertValue(InsertValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            int offset = loggable.offset;
            int dlen = pageHeader.getDataLength();
            if (offset < dlen) {
                int end = offset + 2 + 2 + loggable.value.length;
                try {
                    System.arraycopy(page.data, offset, page.data, end, dlen - offset);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOG.error((Object)e);
                    SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + loggable.tid + "; offset: " + offset + "; end: " + end + "; len: " + (dlen - offset));
                }
            }
            ByteConversion.shortToByte(loggable.tid, page.data, offset);
            page.len += 2;
            ByteConversion.shortToByte(loggable.isOverflow() ? (short)0 : (short)loggable.value.length, page.data, offset += 2);
            page.len += 2;
            System.arraycopy(loggable.value, 0, page.data, offset += 2, loggable.value.length);
            offset += loggable.value.length;
            page.len += loggable.value.length;
            pageHeader.incRecordCount();
            pageHeader.setDataLength(page.len);
            pageHeader.setNextTupleID(ItemId.getId(loggable.tid));
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoInsertValue(InsertValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (ItemId.isLink(loggable.tid)) {
            int end = loggable.offset + 8;
            System.arraycopy(page.data, end, page.data, loggable.offset - 2, page.len - end);
            page.len -= 10;
        } else {
            int offset = loggable.offset + 2;
            short l = ByteConversion.byteToShort(page.data, offset);
            if (ItemId.isRelocated(loggable.tid)) {
                l = (short)(l + 8);
            }
            if (l == 0) {
                l = (short)(l + 8);
            }
            int end = loggable.offset + (4 + l);
            int dlen = pageHeader.getDataLength();
            try {
                System.arraycopy(page.data, end, page.data, loggable.offset, dlen - end);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error((Object)e);
                SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + loggable.tid + "; offset: " + loggable.offset + "; end: " + end + "; len: " + (dlen - end) + "; dataLength: " + dlen);
            }
            page.len = dlen - (4 + l);
        }
        if (page.len < 0) {
            LOG.warn("page length < 0");
        }
        pageHeader.setDataLength(page.len);
        pageHeader.decRecordCount();
        pageHeader.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoSplitPage(SplitPageLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            byte[] oldData = page.data;
            page.data = new byte[this.fileHeader.getWorkSize()];
            System.arraycopy(oldData, 0, page.data, 0, loggable.splitOffset);
            page.len = loggable.splitOffset;
            if (page.len < 0) {
                LOG.error("page length < 0");
            }
            pageHeader.setDataLength(page.len);
            pageHeader.setRecordCount(this.countRecordsInPage(page));
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoSplitPage(SplitPageLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        page.data = loggable.oldData;
        page.len = loggable.oldLen;
        if (page.len < 0) {
            LOG.error("page length < 0");
        }
        pageHeader.setDataLength(page.len);
        pageHeader.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoAddLink(AddLinkLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            ByteConversion.shortToByte(ItemId.setIsLink(loggable.tid), page.data, page.len);
            page.len += 2;
            ByteConversion.longToByte(loggable.link, page.data, page.len);
            page.len += 8;
            pageHeader.setNextTupleID(ItemId.getId(loggable.tid));
            pageHeader.setDataLength(page.len);
            pageHeader.setLsn(loggable.getLsn());
            pageHeader.incRecordCount();
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoAddLink(AddLinkLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        RecordPos rec = page.findRecord(loggable.tid);
        int end = rec.offset + 8;
        System.arraycopy(page.data, end, page.data, rec.offset - 2, page.len - end);
        page.len -= 10;
        if (page.len < 0) {
            LOG.error("page length < 0");
        }
        pageHeader.setDataLength(page.len);
        pageHeader.decRecordCount();
        pageHeader.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoUpdateLink(UpdateLinkLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            ByteConversion.longToByte(loggable.link, page.data, loggable.offset);
            pageHeader.setLsn(loggable.getLsn());
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoUpdateLink(UpdateLinkLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        ByteConversion.longToByte(loggable.oldLink, page.data, loggable.offset);
        pageHeader.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoAddMovedValue(AddMovedValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            try {
                ByteConversion.shortToByte(ItemId.setIsRelocated(loggable.tid), page.data, page.len);
                page.len += 2;
                short vlen = (short)loggable.value.length;
                ByteConversion.shortToByte(vlen, page.data, page.len);
                page.len += 2;
                ByteConversion.longToByte(loggable.backLink, page.data, page.len);
                page.len += 8;
                System.arraycopy(loggable.value, 0, page.data, page.len, vlen);
                page.len += vlen;
                pageHeader.incRecordCount();
                pageHeader.setDataLength(page.len);
                pageHeader.setNextTupleID(ItemId.getId(loggable.tid));
                pageHeader.incRecordCount();
                pageHeader.setLsn(loggable.getLsn());
                page.setDirty(true);
                this.dataCache.add(page, 2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.error("page: " + page.getPageNum() + "; len = " + page.len + "; value = " + loggable.value.length);
                throw e;
            }
        }
    }

    protected void undoAddMovedValue(AddMovedValueLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        RecordPos rec = page.findRecord(ItemId.getId(loggable.tid));
        SanityCheck.ASSERT(rec != null, "Record with tid " + ItemId.getId(loggable.tid) + " not found: " + this.debugPageContents(page));
        short vlen = ByteConversion.byteToShort(page.data, rec.offset);
        int end = rec.offset + 2 + 8 + vlen;
        int dlen = pageHeader.getDataLength();
        try {
            System.arraycopy(page.data, end, page.data, rec.offset - 2, dlen - end);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.error((Object)e);
            SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + loggable.tid + "; offset: " + (rec.offset - 2) + "; end: " + end + "; len: " + (dlen - end));
        }
        page.len = dlen - (12 + vlen);
        if (page.len < 0) {
            LOG.error("page length < 0");
        }
        pageHeader.setDataLength(page.len);
        pageHeader.decRecordCount();
        pageHeader.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoUpdateHeader(UpdateHeaderLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        if (pageHeader.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            if (loggable.nextPage != -1L) {
                pageHeader.setNextDataPage(loggable.nextPage);
            }
            if (loggable.prevPage != -1L) {
                pageHeader.setPrevDataPage(loggable.prevPage);
            }
            pageHeader.setLsn(loggable.getLsn());
            page.setDirty(true);
            this.dataCache.add(page, 2);
        }
    }

    protected void undoUpdateHeader(UpdateHeaderLoggable loggable) {
        DOMPage page = this.getDOMPage(loggable.pageNum);
        DOMFilePageHeader pageHeader = page.getPageHeader();
        pageHeader.setPrevDataPage(loggable.oldPrev);
        pageHeader.setNextDataPage(loggable.oldNext);
        pageHeader.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page, 2);
    }

    static {
        LogEntryTypes.addEntryType((byte)16, CreatePageLoggable::new);
        LogEntryTypes.addEntryType((byte)17, AddValueLoggable::new);
        LogEntryTypes.addEntryType((byte)18, RemoveValueLoggable::new);
        LogEntryTypes.addEntryType((byte)19, RemoveEmptyPageLoggable::new);
        LogEntryTypes.addEntryType((byte)20, UpdateValueLoggable::new);
        LogEntryTypes.addEntryType((byte)21, RemovePageLoggable::new);
        LogEntryTypes.addEntryType((byte)22, WriteOverflowPageLoggable::new);
        LogEntryTypes.addEntryType((byte)23, RemoveOverflowLoggable::new);
        LogEntryTypes.addEntryType((byte)24, InsertValueLoggable::new);
        LogEntryTypes.addEntryType((byte)25, SplitPageLoggable::new);
        LogEntryTypes.addEntryType((byte)26, AddLinkLoggable::new);
        LogEntryTypes.addEntryType((byte)27, AddMovedValueLoggable::new);
        LogEntryTypes.addEntryType((byte)28, UpdateHeaderLoggable::new);
        LogEntryTypes.addEntryType((byte)29, UpdateLinkLoggable::new);
    }

    private final class FindCallback
    implements BTreeCallback {
        public static final int KEYS = 1;
        public static final int VALUES = 0;
        private final int mode;
        private List<Value> values = new ArrayList<Value>();

        public FindCallback(int mode) {
            this.mode = mode;
        }

        public List<Value> getValues() {
            return this.values;
        }

        @Override
        public boolean indexInfo(Value value, long pointer) {
            switch (this.mode) {
                case 0: {
                    RecordPos rec = DOMFile.this.findRecord(pointer);
                    short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
                    this.values.add(new Value(rec.getPage().data, rec.offset + 2, vlen));
                    return true;
                }
                case 1: {
                    this.values.add(value);
                    return true;
                }
            }
            return false;
        }
    }

    protected final class OverflowDOMPage {
        final Paged.Page firstPage;

        public OverflowDOMPage() {
            this.firstPage = this.createNewPage();
            LOG.debug("Creating overflow page: " + this.firstPage.getPageNum());
        }

        public OverflowDOMPage(long first) throws IOException {
            this.firstPage = DOMFile.this.getPage(first);
        }

        protected Paged.Page createNewPage() {
            try {
                Paged.Page page = DOMFile.this.getFreePage();
                DOMFilePageHeader pageHeader = (DOMFilePageHeader)page.getPageHeader();
                pageHeader.setStatus((byte)20);
                pageHeader.setDirty(true);
                pageHeader.setNextDataPage(-1L);
                pageHeader.setPrevDataPage(-1L);
                pageHeader.setNextPage(-1L);
                pageHeader.setNextTupleID((short)-1);
                pageHeader.setDataLength(0);
                pageHeader.setRecordCount((short)0);
                if (DOMFile.this.currentDocument != null) {
                    DOMFile.this.currentDocument.getMetadata().incPageCount();
                }
                return page;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return null;
            }
        }

        public int write(Txn transaction, InputStream is) {
            int pageCount = 0;
            Paged.Page currentPage = this.firstPage;
            try {
                Value value;
                int len;
                int chunkSize = DOMFile.this.fileHeader.getWorkSize();
                byte[] buf = new byte[chunkSize];
                byte[] altbuf = new byte[chunkSize];
                byte[] currbuf = buf;
                byte[] fullbuf = null;
                boolean isaltbuf = false;
                int basebuf = 0;
                int basemax = chunkSize;
                boolean emptyPage = true;
                while ((len = is.read(currbuf, basebuf, basemax)) != -1) {
                    emptyPage = false;
                    if (fullbuf != null) {
                        value = new Value(fullbuf, 0, chunkSize);
                        Paged.Page nextPage = this.createNewPage();
                        currentPage.getPageHeader().setNextPage(nextPage.getPageNum());
                        if (transaction != null && DOMFile.this.isRecoveryEnabled()) {
                            long nextPageNum = nextPage.getPageNum();
                            WriteOverflowPageLoggable loggable = new WriteOverflowPageLoggable(transaction, currentPage.getPageNum(), nextPageNum, value);
                            DOMFile.this.writeToLog(loggable, currentPage);
                        }
                        DOMFile.this.writeValue(currentPage, value);
                        ++pageCount;
                        currentPage = nextPage;
                        fullbuf = null;
                    }
                    if ((basebuf += len) == chunkSize) {
                        fullbuf = currbuf;
                        currbuf = isaltbuf ? buf : altbuf;
                        isaltbuf = !isaltbuf;
                        basebuf = 0;
                        basemax = chunkSize;
                        continue;
                    }
                    basemax -= len;
                }
                if (emptyPage) {
                    currentPage.setPageNum(-1L);
                    currentPage.getPageHeader().setNextPage(-1L);
                } else {
                    if (fullbuf != null) {
                        basebuf = chunkSize;
                        currbuf = fullbuf;
                    }
                    value = new Value(currbuf, 0, basebuf);
                    currentPage.getPageHeader().setNextPage(-1L);
                    if (transaction != null && DOMFile.this.isRecoveryEnabled()) {
                        long nextPageNum = -1L;
                        WriteOverflowPageLoggable loggable = new WriteOverflowPageLoggable(transaction, currentPage.getPageNum(), -1L, value);
                        DOMFile.this.writeToLog(loggable, currentPage);
                    }
                    DOMFile.this.writeValue(currentPage, value);
                    ++pageCount;
                }
            }
            catch (IOException ex) {
                LOG.error("IO error while writing overflow page", (Throwable)ex);
            }
            return pageCount;
        }

        public int write(Txn transaction, byte[] data) {
            int pageCount = 0;
            try {
                Paged.Page currentPage = this.firstPage;
                int remaining = data.length;
                int pos = 0;
                while (remaining > 0) {
                    Paged.Page nextPage;
                    int chunkSize = remaining > DOMFile.this.fileHeader.getWorkSize() ? DOMFile.this.fileHeader.getWorkSize() : remaining;
                    Value value = new Value(data, pos, chunkSize);
                    if ((remaining -= chunkSize) > 0) {
                        nextPage = this.createNewPage();
                        currentPage.getPageHeader().setNextPage(nextPage.getPageNum());
                    } else {
                        nextPage = null;
                        currentPage.getPageHeader().setNextPage(-1L);
                    }
                    if (transaction != null && DOMFile.this.isRecoveryEnabled()) {
                        WriteOverflowPageLoggable loggable = new WriteOverflowPageLoggable(transaction, currentPage.getPageNum(), remaining > 0 ? nextPage.getPageNum() : -1L, value);
                        DOMFile.this.writeToLog(loggable, currentPage);
                    }
                    DOMFile.this.writeValue(currentPage, value);
                    pos += chunkSize;
                    currentPage = nextPage;
                    ++pageCount;
                }
            }
            catch (IOException e) {
                LOG.warn("IO error while writing overflow page", (Throwable)e);
            }
            return pageCount;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] read() {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                this.streamTo((OutputStream)os);
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return null;
            }
        }

        public void streamTo(OutputStream os) {
            Paged.Page page = this.firstPage;
            int count = 0;
            while (page != null) {
                try {
                    byte[] chunk = page.read();
                    os.write(chunk);
                    long nextPageNumber = page.getPageHeader().getNextPage();
                    page = nextPageNumber == -1L ? null : DOMFile.this.getPage(nextPageNumber);
                }
                catch (IOException e) {
                    LOG.error("IO error while loading overflow page " + this.firstPage.getPageNum() + "; read: " + count, (Throwable)e);
                    break;
                }
                ++count;
            }
        }

        public void delete(Txn transaction) throws IOException {
            Paged.Page page = this.firstPage;
            while (page != null) {
                LOG.debug("Removing overflow page " + page.getPageNum());
                long nextPageNumber = page.getPageHeader().getNextPage();
                if (transaction != null && DOMFile.this.isRecoveryEnabled()) {
                    byte[] chunk = page.read();
                    RemoveOverflowLoggable loggable = new RemoveOverflowLoggable(transaction, page.getPageNum(), nextPageNumber, chunk);
                    DOMFile.this.writeToLog(loggable, page);
                }
                DOMFile.this.unlinkPages(page);
                page = nextPageNumber == -1L ? null : DOMFile.this.getPage(nextPageNumber);
            }
        }

        public long getPageNum() {
            return this.firstPage.getPageNum();
        }
    }

    protected final class DOMPage
    implements Cacheable {
        byte[] data;
        int len = 0;
        Paged.Page page;
        DOMFilePageHeader pageHeader;
        int refCount = 0;
        int timestamp = 0;
        boolean saved = true;
        boolean invalidated = false;

        public DOMPage() {
            this.page = this.createNewPage();
            this.pageHeader = (DOMFilePageHeader)this.page.getPageHeader();
            this.data = new byte[DOMFile.this.fileHeader.getWorkSize()];
            this.len = 0;
        }

        public DOMPage(long pos) {
            try {
                this.page = DOMFile.this.getPage(pos);
                this.load(this.page);
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                ioe.printStackTrace();
            }
        }

        public DOMPage(Paged.Page page) {
            this.page = page;
            this.load(page);
        }

        protected Paged.Page createNewPage() {
            try {
                Paged.Page page = DOMFile.this.getFreePage();
                DOMFilePageHeader pageHeader = (DOMFilePageHeader)page.getPageHeader();
                pageHeader.setStatus((byte)20);
                pageHeader.setDirty(true);
                pageHeader.setNextDataPage(-1L);
                pageHeader.setPrevDataPage(-1L);
                pageHeader.setNextPage(-1L);
                pageHeader.setNextTupleID((short)-1);
                pageHeader.setDataLength(0);
                pageHeader.setRecordCount((short)0);
                if (DOMFile.this.currentDocument != null) {
                    DOMFile.this.currentDocument.getMetadata().incPageCount();
                }
                return page;
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                return null;
            }
        }

        public RecordPos findRecord(short targetId) {
            int dlen = this.pageHeader.getDataLength();
            RecordPos rec = null;
            int pos = 0;
            while (pos < dlen) {
                short tupleID = ByteConversion.byteToShort(this.data, pos);
                pos += 2;
                if (ItemId.matches(tupleID, targetId)) {
                    if (ItemId.isLink(tupleID)) {
                        rec = new RecordPos(pos, this, tupleID, true);
                        break;
                    }
                    rec = new RecordPos(pos, this, tupleID);
                    break;
                }
                if (ItemId.isLink(tupleID)) {
                    pos += 8;
                    continue;
                }
                short vlen = ByteConversion.byteToShort(this.data, pos);
                pos += 2;
                if (vlen < 0) {
                    LOG.error("page = " + this.page.getPageNum() + "; pos = " + pos + "; vlen = " + vlen + "; tupleID = " + tupleID + "; target = " + targetId);
                }
                pos = ItemId.isRelocated(tupleID) ? (pos += 8 + vlen) : (pos += vlen);
                if (vlen != 0) continue;
                pos += 8;
            }
            return rec;
        }

        @Override
        public long getKey() {
            return this.page.getPageNum();
        }

        @Override
        public int getReferenceCount() {
            return this.refCount;
        }

        @Override
        public int decReferenceCount() {
            return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
        }

        @Override
        public int incReferenceCount() {
            if (this.refCount < 10000) {
                ++this.refCount;
            }
            return this.refCount;
        }

        @Override
        public void setReferenceCount(int count) {
            this.refCount = count;
        }

        @Override
        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public int getTimestamp() {
            return this.timestamp;
        }

        public DOMFilePageHeader getPageHeader() {
            return this.pageHeader;
        }

        public long getPageNum() {
            return this.page.getPageNum();
        }

        @Override
        public boolean isDirty() {
            return !this.saved;
        }

        public void setDirty(boolean dirty) {
            this.saved = !dirty;
            this.page.getPageHeader().setDirty(dirty);
        }

        private void load(Paged.Page page) {
            try {
                this.data = page.read();
                this.pageHeader = (DOMFilePageHeader)page.getPageHeader();
                this.len = this.pageHeader.getDataLength();
                if (this.data.length == 0) {
                    this.data = new byte[DOMFile.this.fileHeader.getWorkSize()];
                    this.len = 0;
                    return;
                }
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
                ioe.printStackTrace();
            }
            this.saved = true;
        }

        public void write() {
            if (this.page == null) {
                return;
            }
            try {
                if (!this.pageHeader.isDirty()) {
                    return;
                }
                this.pageHeader.setDataLength(this.len);
                DOMFile.this.writeValue(this.page, this.data);
                this.setDirty(false);
            }
            catch (IOException ioe) {
                LOG.error((Object)ioe);
            }
        }

        public String dumpPage() {
            return "Contents of page " + this.page.getPageNum() + ": " + Paged.hexDump(this.data);
        }

        @Override
        public boolean sync(boolean syncJournal) {
            if (this.isDirty()) {
                this.write();
                if (DOMFile.this.isRecoveryEnabled() && syncJournal && ((JournalManager)DOMFile.this.logManager.get()).lastWrittenLsn() < this.pageHeader.getLsn()) {
                    ((JournalManager)DOMFile.this.logManager.get()).flush(true, false);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean allowUnload() {
            return true;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof DOMPage)) {
                return false;
            }
            DOMPage other = (DOMPage)obj;
            return this.page.equals(other.page);
        }

        public void invalidate() {
            this.invalidated = true;
        }

        public boolean isInvalidated() {
            return this.invalidated;
        }

        public void cleanUp() {
            int dlen = this.pageHeader.getDataLength();
            short maxTupleID = 0;
            int recordCount = 0;
            int pos = 0;
            while (pos < dlen) {
                short tupleID = ByteConversion.byteToShort(this.data, pos);
                pos += 2;
                if (ItemId.getId(tupleID) > 16382) {
                    LOG.error(DOMFile.this.debugPageContents(this));
                    throw new RuntimeException("TupleID overflow in page " + this.getPageNum());
                }
                if (ItemId.getId(tupleID) > maxTupleID) {
                    maxTupleID = ItemId.getId(tupleID);
                }
                if (ItemId.isLink(tupleID)) {
                    pos += 8;
                } else {
                    short vlen = ByteConversion.byteToShort(this.data, pos);
                    pos += 2;
                    pos = ItemId.isRelocated(tupleID) ? (pos += vlen == 0 ? 16 : 8 + vlen) : (pos += vlen == 0 ? 8 : (int)vlen);
                }
                recordCount = (short)(recordCount + 1);
            }
            this.pageHeader.setNextTupleID(maxTupleID);
        }
    }

    protected final class DOMFilePageHeader
    extends BTree.BTreePageHeader {
        protected int dataLength;
        protected long nextDataPage;
        protected long previousDataPage;
        protected short tupleID;
        protected short records;
        public static final short LENGTH_RECORDS_COUNT = 2;
        public static final int LENGTH_DATA_LENGTH = 4;
        public static final long LENGTH_NEXT_PAGE_POINTER = 8L;
        public static final long LENGTH_PREV_PAGE_POINTER = 8L;
        public static final short LENGTH_CURRENT_TID = 2;

        public DOMFilePageHeader() {
            this.dataLength = 0;
            this.nextDataPage = -1L;
            this.previousDataPage = -1L;
            this.tupleID = (short)-1;
            this.records = 0;
        }

        public DOMFilePageHeader(byte[] data, int offset) throws IOException {
            super(data, offset);
            this.dataLength = 0;
            this.nextDataPage = -1L;
            this.previousDataPage = -1L;
            this.tupleID = (short)-1;
            this.records = 0;
        }

        public void decRecordCount() {
            this.records = (short)(this.records - 1);
        }

        public short getCurrentTupleID() {
            return this.tupleID;
        }

        public short getNextTupleID() {
            this.tupleID = (short)(this.tupleID + 1);
            if (this.tupleID == 16383) {
                throw new RuntimeException("No spare ids on page");
            }
            return this.tupleID;
        }

        public boolean hasRoom() {
            return this.tupleID < 16382;
        }

        public void setNextTupleID(short tupleID) {
            if (tupleID > 16382) {
                throw new RuntimeException("TupleID overflow! TupleID = " + tupleID);
            }
            this.tupleID = tupleID;
        }

        public int getDataLength() {
            return this.dataLength;
        }

        public long getNextDataPage() {
            return this.nextDataPage;
        }

        public long getPreviousDataPage() {
            return this.previousDataPage;
        }

        public short getRecordCount() {
            return this.records;
        }

        public void incRecordCount() {
            this.records = (short)(this.records + 1);
        }

        @Override
        public int read(byte[] data, int offset) throws IOException {
            offset = super.read(data, offset);
            this.records = ByteConversion.byteToShort(data, offset);
            this.dataLength = ByteConversion.byteToInt(data, offset += 2);
            this.nextDataPage = ByteConversion.byteToLong(data, offset += 4);
            offset = (int)((long)offset + 8L);
            this.previousDataPage = ByteConversion.byteToLong(data, offset);
            offset = (int)((long)offset + 8L);
            this.tupleID = ByteConversion.byteToShort(data, offset);
            return offset + 2;
        }

        @Override
        public int write(byte[] data, int offset) throws IOException {
            offset = super.write(data, offset);
            ByteConversion.shortToByte(this.records, data, offset);
            ByteConversion.intToByte(this.dataLength, data, offset += 2);
            ByteConversion.longToByte(this.nextDataPage, data, offset += 4);
            offset = (int)((long)offset + 8L);
            ByteConversion.longToByte(this.previousDataPage, data, offset);
            offset = (int)((long)offset + 8L);
            ByteConversion.shortToByte(this.tupleID, data, offset);
            return offset + 2;
        }

        public void setDataLength(int dataLength) {
            if (dataLength > DOMFile.this.fileHeader.getWorkSize()) {
                LOG.error("data too long for file header !");
            }
            this.dataLength = dataLength;
        }

        public void setNextDataPage(long page) {
            this.nextDataPage = page;
        }

        public void setPrevDataPage(long page) {
            this.previousDataPage = page;
        }

        public void setRecordCount(short recs) {
            this.records = recs;
        }
    }
}

