/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.lock.Lock;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.util.ReadOnlyException;

public abstract class DOMTransaction {
    private static final Logger LOG = LogManager.getLogger(DOMTransaction.class);
    private final Object ownerObject;
    private final DOMFile file;
    private final Lock.LockMode mode;
    private final DocumentImpl document;

    public DOMTransaction(Object owner, DOMFile file) {
        this(owner, file, Lock.LockMode.READ_LOCK);
    }

    public DOMTransaction(Object owner, DOMFile file, Lock.LockMode mode) {
        this(owner, file, mode, null);
    }

    public DOMTransaction(Object owner, DOMFile file, Lock.LockMode mode, DocumentImpl doc) {
        this.ownerObject = owner;
        this.file = file;
        this.mode = mode;
        this.document = doc;
    }

    public abstract Object start() throws ReadOnlyException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() {
        Lock lock = this.file.getLock();
        try {
            try {
                lock.acquire(this.mode);
            }
            catch (LockException e) {
                LOG.error("Failed to acquire read lock on " + FileUtils.fileName(this.file.getFile()), (Throwable)e);
                Object var3_5 = null;
                lock.release(this.mode);
                return var3_5;
            }
            this.file.setOwnerObject(this.ownerObject);
            this.file.setCurrentDocument(this.document);
            Object e = this.start();
            return e;
        }
        catch (ReadOnlyException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.release(this.mode);
        }
        return null;
    }
}

