/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class UpdateHeaderLoggable
extends AbstractLoggable {
    protected long pageNum;
    protected long nextPage;
    protected long prevPage;
    protected long oldNext;
    protected long oldPrev;
    private DOMFile domDb = null;

    public UpdateHeaderLoggable(Txn transaction, long prevPage, long pageNum, long nextPage, long oldPrev, long oldNext) {
        super((byte)28, transaction.getId());
        this.prevPage = prevPage;
        this.pageNum = pageNum;
        this.nextPage = nextPage;
        this.oldPrev = oldPrev;
        this.oldNext = oldNext;
    }

    public UpdateHeaderLoggable(DBBroker broker, long transactId) {
        super((byte)28, transactId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    @Override
    public void write(ByteBuffer out) {
        out.putInt((int)this.prevPage);
        out.putInt((int)this.pageNum);
        out.putInt((int)this.nextPage);
        out.putInt((int)this.oldPrev);
        out.putInt((int)this.oldNext);
    }

    @Override
    public void read(ByteBuffer in) {
        this.prevPage = in.getInt();
        this.pageNum = in.getInt();
        this.nextPage = in.getInt();
        this.oldPrev = in.getInt();
        this.oldNext = in.getInt();
    }

    @Override
    public int getLogSize() {
        return 20;
    }

    @Override
    public void redo() throws LogException {
        this.domDb.redoUpdateHeader(this);
    }

    @Override
    public void undo() throws LogException {
        this.domDb.undoUpdateHeader(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - update header of page " + this.pageNum + ": prev = " + this.prevPage + "; next = " + this.nextPage + "; oldPrev = " + this.oldPrev + "; oldNext = " + this.oldNext;
    }
}

