/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.btree.Value;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class WriteOverflowPageLoggable
extends AbstractLoggable {
    protected long pageNum;
    protected long nextPage;
    protected Value value;
    private DOMFile domDb = null;

    public WriteOverflowPageLoggable(Txn transaction, long pageNum, long nextPage, Value value) {
        super((byte)22, transaction.getId());
        this.pageNum = pageNum;
        this.nextPage = nextPage;
        this.value = value;
    }

    public WriteOverflowPageLoggable(DBBroker broker, long transactId) {
        super((byte)22, transactId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    @Override
    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putInt((int)this.nextPage);
        out.putShort((short)this.value.getLength());
        out.put(this.value.data(), this.value.start(), this.value.getLength());
    }

    @Override
    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.nextPage = in.getInt();
        short len = in.getShort();
        byte[] data = new byte[len];
        in.get(data);
        this.value = new Value(data);
    }

    @Override
    public int getLogSize() {
        return 10 + this.value.getLength();
    }

    @Override
    public void redo() throws LogException {
        this.domDb.redoWriteOverflow(this);
    }

    @Override
    public void undo() throws LogException {
        this.domDb.undoWriteOverflow(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - writing overflow page " + this.pageNum + "; next: " + this.nextPage;
    }
}

