/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.file.Path;
import org.exist.storage.BrokerPool;
import org.exist.storage.DefaultCacheManager;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.DBException;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.util.FileUtils;

public class BTreeStore
extends BTree {
    public static final short FILE_FORMAT_VERSION_ID = 2;
    protected Lock lock = null;

    public BTreeStore(BrokerPool pool, byte fileId, boolean recoverEnabled, Path file, DefaultCacheManager cacheManager) throws DBException {
        super(pool, fileId, recoverEnabled, cacheManager, file);
        this.lock = new ReentrantReadWriteLock(FileUtils.fileName(file));
        if (this.exists()) {
            this.open((short)2);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating data file: " + FileUtils.fileName(this.getFile()));
            }
            this.create((short)-1);
        }
        this.setSplitFactor(0.7);
    }

    @Override
    public Lock getLock() {
        return this.lock;
    }

    @Override
    public short getFileVersion() {
        return 2;
    }
}

