/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class CreatePageLoggable
extends AbstractBFileLoggable {
    protected long newPage;

    public CreatePageLoggable(Txn transaction, byte fileId, long newPage) {
        super((byte)48, fileId, transaction);
        this.newPage = newPage;
    }

    public CreatePageLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.newPage);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.newPage = in.getInt();
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 4;
    }

    @Override
    public void redo() throws LogException {
        this.getIndexFile().redoCreatePage(this);
    }

    @Override
    public void undo() throws LogException {
        this.getIndexFile().undoCreatePage(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - create new page " + this.newPage;
    }
}

