/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.io.IOException;
import org.exist.storage.index.FreeSpace;
import org.exist.util.ByteConversion;

public class FreeList {
    public static final int MAX_FREE_LIST_LEN = 128;
    protected FreeSpace header = null;
    protected FreeSpace last = null;
    protected int size = 0;

    public void add(FreeSpace free) {
        if (this.header == null) {
            this.header = free;
            this.last = free;
        } else {
            this.last.next = free;
            free.previous = this.last;
            this.last = free;
        }
        ++this.size;
    }

    public void remove(FreeSpace node) {
        --this.size;
        if (node.previous == null) {
            if (node.next != null) {
                node.next.previous = null;
                this.header = node.next;
            } else {
                this.header = null;
            }
        } else {
            node.previous.next = node.next;
            if (node.next != null) {
                node.next.previous = node.previous;
            } else {
                this.last = node.previous;
            }
        }
    }

    public FreeSpace retrieve(long pageNum) {
        FreeSpace next = this.header;
        while (next != null) {
            if (next.page == pageNum) {
                return next;
            }
            next = next.next;
        }
        return null;
    }

    public FreeSpace find(int requiredSize) {
        FreeSpace next = this.header;
        FreeSpace found = null;
        while (next != null) {
            if (next.free >= requiredSize && (found == null || next.free < found.free)) {
                found = next;
            }
            next = next.next;
        }
        return found;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        FreeSpace next = this.header;
        while (next != null) {
            buf.append("[").append(next.page).append(", ");
            buf.append(next.free).append("] ");
            next = next.next;
        }
        return buf.toString();
    }

    public int read(byte[] buf, int offset) throws IOException {
        int fsize = ByteConversion.byteToInt(buf, offset);
        offset += 4;
        for (int i = 0; i < fsize; ++i) {
            long page = ByteConversion.byteToLong(buf, offset);
            int space = ByteConversion.byteToInt(buf, offset += 8);
            offset += 4;
            this.add(new FreeSpace(page, space));
        }
        return offset;
    }

    public int write(byte[] buf, int offset) throws IOException {
        int skip = 0;
        if (this.size > 128) {
            skip = this.size - 128;
        }
        ByteConversion.intToByte(this.size - skip, buf, offset);
        offset += 4;
        FreeSpace next = this.header;
        while (next != null) {
            if (skip == 0) {
                ByteConversion.longToByte(next.page, buf, offset);
                ByteConversion.intToByte(next.free, buf, offset += 8);
                offset += 4;
            } else {
                --skip;
            }
            next = next.next;
        }
        return offset;
    }
}

