/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class OverflowCreateLoggable
extends AbstractBFileLoggable {
    protected long pageNum;

    public OverflowCreateLoggable(byte fileId, Txn transaction, long pageNum) {
        super((byte)54, fileId, transaction);
        this.pageNum = pageNum;
    }

    public OverflowCreateLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 4;
    }

    @Override
    public void redo() throws LogException {
        this.getIndexFile().redoCreateOverflow(this);
    }

    @Override
    public void undo() throws LogException {
        this.getIndexFile().undoCreateOverflow(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - create new overflow page " + this.pageNum;
    }
}

