/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class RemoveEmptyPageLoggable
extends AbstractBFileLoggable {
    protected long page;

    public RemoveEmptyPageLoggable(Txn transaction, byte fileId, long pageNum) {
        super((byte)51, fileId, transaction);
        this.page = pageNum;
    }

    public RemoveEmptyPageLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    @Override
    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.page);
    }

    @Override
    public void read(ByteBuffer in) {
        super.read(in);
        this.page = in.getInt();
    }

    @Override
    public int getLogSize() {
        return super.getLogSize() + 4;
    }

    @Override
    public void redo() throws LogException {
        this.getIndexFile().redoRemovePage(this);
    }

    @Override
    public void undo() throws LogException {
        this.getIndexFile().undoRemovePage(this);
    }

    @Override
    public String dump() {
        return super.dump() + " - remove page " + this.page;
    }
}

