/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.exist.storage.io.VariableByteInput;
import org.exist.storage.io.VariableByteOutputStream;

public abstract class AbstractVariableByteInput
implements VariableByteInput {
    @Override
    public byte readByte() throws IOException {
        int i = this.read();
        if (i < 0) {
            throw new EOFException();
        }
        return (byte)i;
    }

    @Override
    public short readShort() throws IOException {
        byte b = this.readByte();
        short i = (short)(b & 0x7F);
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i = (short)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    @Override
    public int readInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    @Override
    public int readFixedInt() throws IOException {
        return this.readByte() & 0xFF | (this.readByte() & 0xFF) << 8 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 24;
    }

    @Override
    public long readLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    @Override
    public String readUTF() throws IOException {
        int len = this.readInt();
        byte[] data = new byte[len];
        this.read(data);
        return new String(data, StandardCharsets.UTF_8);
    }

    @Override
    public void skip(int count) throws IOException {
        for (int i = 0; i < count && this.available() > 0; ++i) {
            while ((this.readByte() & 0x80) > 0) {
            }
        }
    }

    @Override
    public void skipBytes(long count) throws IOException {
        for (long i = 0L; i < count; ++i) {
            this.readByte();
        }
    }

    @Override
    public int read(byte[] data) throws IOException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        try {
            for (i = 1; i < len && (c = this.read()) != -1; ++i) {
                if (b == null) continue;
                b[off + i] = (byte)c;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public void copyTo(VariableByteOutputStream os) throws IOException {
        do {
            int more = this.read();
            os.write((byte)more);
        } while ((more &= 0x80) > 0);
    }

    @Override
    public void copyTo(VariableByteOutputStream os, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            do {
                int more = this.read();
                os.write((byte)more);
            } while ((more &= 0x80) > 0);
        }
    }

    @Override
    public void copyRaw(VariableByteOutputStream os, int count) throws IOException {
        int read;
        byte[] buf = new byte[count];
        int totalRead = 0;
        while ((read = this.read(buf, 0, count - totalRead)) > 0) {
            os.write(buf, 0, read);
            totalRead += read;
        }
    }

    public void release() {
    }
}

