/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.journal;

import com.evolvedbinary.j8fu.function.SupplierE;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.BrokerPoolService;
import org.exist.storage.BrokerPoolServiceException;
import org.exist.storage.journal.Journal;
import org.exist.storage.journal.JournalException;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.recovery.RecoveryManager;
import org.exist.util.Configuration;
import org.exist.util.ReadOnlyException;

public class JournalManager
implements BrokerPoolService {
    private static final Logger LOG = LogManager.getLogger(JournalManager.class);
    private Path journalDir;
    private boolean groupCommits;
    private Journal journal;
    private boolean journallingDisabled = false;
    private boolean initialized = false;

    @Override
    public void configure(Configuration configuration) {
        this.journalDir = (Path)Optional.ofNullable(configuration.getProperty("db-connection.recovery.journal-dir")).orElse(configuration.getProperty("db-connection.data-dir"));
        this.groupCommits = configuration.getProperty("db-connection.recovery.group-commit", false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("GroupCommits = " + this.groupCommits);
        }
    }

    @Override
    public void prepare(BrokerPool pool) throws BrokerPoolServiceException {
        if (!this.journallingDisabled) {
            try {
                this.journal = new Journal(pool, this.journalDir);
                this.journal.initialize();
                this.initialized = true;
            }
            catch (EXistException | ReadOnlyException e) {
                throw new BrokerPoolServiceException(e);
            }
        }
    }

    public void disableJournalling() {
        this.journallingDisabled = true;
    }

    public synchronized void journal(Loggable loggable) throws JournalException {
        if (!this.journallingDisabled) {
            this.journal.writeToLog(loggable);
        }
    }

    public synchronized void journalGroup(Loggable loggable) throws JournalException {
        if (!this.journallingDisabled) {
            this.journal.writeToLog(loggable);
            if (!this.groupCommits) {
                this.journal.flushToLog(true);
            }
        }
    }

    public synchronized void checkpoint(long transactionId, boolean switchFiles) throws JournalException {
        if (!this.journallingDisabled) {
            this.journal.checkpoint(transactionId, switchFiles);
        }
    }

    public synchronized void flush(boolean fsync, boolean forceSync) {
        this.journal.flushToLog(fsync, forceSync);
    }

    public synchronized void shutdown(long transactionId, boolean checkpoint) {
        if (this.initialized) {
            this.journal.shutdown(transactionId, checkpoint);
            this.initialized = false;
        }
    }

    public long lastWrittenLsn() {
        return this.journal.lastWrittenLsn();
    }

    public RecoveryManager.JournalRecoveryAccessor getRecoveryAccessor(RecoveryManager recoveryManager) {
        RecoveryManager recoveryManager2 = recoveryManager;
        recoveryManager2.getClass();
        return new RecoveryManager.JournalRecoveryAccessor(recoveryManager2, this.journal::setInRecovery, (SupplierE<Stream<Path>, IOException>)((SupplierE)this.journal::getFiles), this.journal::getFile, this.journal::setCurrentFileNum, (SupplierE<Void, LogException>)((SupplierE)() -> {
            this.journal.switchFiles();
            return null;
        }), () -> {
            this.journal.clearBackupFiles();
            return null;
        });
    }
}

