/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.io.IOException;
import java.util.Map;
import org.exist.scheduler.JobDescription;
import org.exist.storage.lock.FileLock;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class FileLockHeartBeat
implements JobDescription,
Job {
    private final String JOB_NAME;

    public FileLockHeartBeat() {
        this.JOB_NAME = "FileLockHeartBeat";
    }

    public FileLockHeartBeat(String lockName) {
        this.JOB_NAME = "FileLockHeartBeat: " + lockName;
    }

    @Override
    public String getName() {
        return this.JOB_NAME;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getGroup() {
        return "eXist.internal";
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Map params = (Map)jobDataMap.get((Object)"params");
        FileLock lock = (FileLock)params.get(FileLock.class.getName());
        if (lock != null) {
            try {
                lock.save();
            }
            catch (IOException e) {
                lock.message("Caught exception while trying to write lock file", e);
            }
        } else {
            JobExecutionException jat = new JobExecutionException("Unable to write heart-beat: lock was null");
            jat.setUnscheduleFiringTrigger(true);
        }
    }
}

