/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.lock.DeadlockDetection;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockInfo;
import org.exist.storage.lock.LockListener;
import org.exist.storage.lock.WaitingThread;
import org.exist.util.LockException;

public class ReentrantReadWriteLock
implements Lock {
    private static final int WAIT_CHECK_PERIOD = 200;
    private static final Logger LOG = LogManager.getLogger(ReentrantReadWriteLock.class);
    private final Object id_;
    private Thread owner_ = null;
    private final Deque<SuspendedWaiter> suspendedThreads = new ArrayDeque<SuspendedWaiter>();
    private int holds_ = 0;
    private Lock.LockMode mode_ = Lock.LockMode.NO_LOCK;
    private final Deque<Lock.LockMode> modeStack = new ArrayDeque<Lock.LockMode>();
    private int writeLocks = 0;
    private LockListener listener = null;
    private final boolean DEBUG = false;
    private final Deque<StackTraceElement[]> seStack;

    public ReentrantReadWriteLock(Object id) {
        this.id_ = id;
        this.seStack = null;
    }

    @Override
    public String getId() {
        return this.id_.toString();
    }

    @Override
    public boolean acquire() throws LockException {
        return this.acquire(Lock.LockMode.READ_LOCK);
    }

    @Override
    public boolean acquire(Lock.LockMode mode) throws LockException {
        if (mode == Lock.LockMode.NO_LOCK) {
            LOG.warn("Acquired with LockMode.NO_LOCK!");
            return true;
        }
        if (Thread.interrupted()) {
            throw new LockException();
        }
        Thread caller = Thread.currentThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                this.modeStack.push(mode);
                if (mode == Lock.LockMode.WRITE_LOCK) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(mode);
                if (mode == Lock.LockMode.WRITE_LOCK) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                return true;
            }
            WaitingThread waitingOnResource = DeadlockDetection.deadlockCheckResource(caller, this.owner_);
            if (waitingOnResource != null) {
                waitingOnResource.suspendWaiting();
                SuspendedWaiter suspended = new SuspendedWaiter(this.owner_, this.mode_, this.holds_);
                this.suspendedThreads.push(suspended);
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(mode);
                if (mode == Lock.LockMode.WRITE_LOCK) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                this.listener = waitingOnResource;
                return true;
            }
            DeadlockDetection.addCollectionWaiter(caller, this);
            try {
                do {
                    this.wait(200L);
                    waitingOnResource = DeadlockDetection.deadlockCheckResource(caller, this.owner_);
                    if (waitingOnResource != null) {
                        waitingOnResource.suspendWaiting();
                        SuspendedWaiter suspended = new SuspendedWaiter(this.owner_, this.mode_, this.holds_);
                        this.suspendedThreads.push(suspended);
                        this.owner_ = caller;
                        this.holds_ = 1;
                        this.modeStack.push(mode);
                        if (mode == Lock.LockMode.WRITE_LOCK) {
                            ++this.writeLocks;
                        }
                        this.mode_ = mode;
                        this.listener = waitingOnResource;
                        DeadlockDetection.clearCollectionWaiter(this.owner_);
                        return true;
                    }
                    if (caller != this.owner_) continue;
                    ++this.holds_;
                    this.modeStack.push(mode);
                    if (mode == Lock.LockMode.WRITE_LOCK) {
                        ++this.writeLocks;
                    }
                    this.mode_ = mode;
                    DeadlockDetection.clearCollectionWaiter(this.owner_);
                    return true;
                } while (this.owner_ != null);
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(mode);
                if (mode == Lock.LockMode.WRITE_LOCK) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                DeadlockDetection.clearCollectionWaiter(this.owner_);
                return true;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw new LockException("Interrupted while waiting for lock");
            }
        }
    }

    @Override
    public synchronized void wakeUp() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean attempt(Lock.LockMode mode) {
        if (mode == Lock.LockMode.NO_LOCK) {
            LOG.warn("Attempted acquire with LockMode.NO_LOCK!");
            return true;
        }
        Thread caller = Thread.currentThread();
        ReentrantReadWriteLock reentrantReadWriteLock = this;
        synchronized (reentrantReadWriteLock) {
            if (caller == this.owner_) {
                ++this.holds_;
                this.modeStack.push(mode);
                if (mode == Lock.LockMode.WRITE_LOCK) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                this.modeStack.push(mode);
                if (mode == Lock.LockMode.WRITE_LOCK) {
                    ++this.writeLocks;
                }
                this.mode_ = mode;
                return true;
            }
            return false;
        }
    }

    @Override
    public synchronized boolean isLockedForWrite() {
        return this.writeLocks > 0;
    }

    @Override
    public boolean isLockedForRead(Thread owner) {
        return false;
    }

    @Override
    public synchronized boolean hasLock() {
        return this.holds_ > 0;
    }

    @Override
    public boolean hasLock(Thread owner) {
        return this.owner_ == owner;
    }

    public Thread getOwner() {
        return this.owner_;
    }

    @Override
    public synchronized void release(Lock.LockMode mode) {
        Lock.LockMode top;
        if (mode == Lock.LockMode.NO_LOCK) {
            LOG.warn("Released with LockMode.NO_LOCK!");
            return;
        }
        if (Thread.currentThread() != this.owner_) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("Possible lock problem: thread " + Thread.currentThread() + " Released a lock on " + this.getId() + " it didn't hold. Either the thread was interrupted or it never acquired the lock. The lock was owned by: " + this.owner_);
            }
            return;
        }
        this.mode_ = top = this.modeStack.pop();
        top = null;
        if (this.mode_ != mode) {
            LOG.warn("Released lock of different type. Expected " + (Object)((Object)this.mode_) + " got " + (Object)((Object)mode), new Throwable());
        }
        if (this.mode_ == Lock.LockMode.WRITE_LOCK) {
            --this.writeLocks;
        }
        if (--this.holds_ == 0) {
            if (!this.suspendedThreads.isEmpty()) {
                SuspendedWaiter suspended = this.suspendedThreads.pop();
                this.owner_ = suspended.thread;
                this.mode_ = suspended.lockMode;
                this.holds_ = suspended.lockCount;
            } else {
                this.owner_ = null;
                this.mode_ = Lock.LockMode.NO_LOCK;
                this.notify();
            }
        }
        if (this.listener != null) {
            this.listener.lockReleased();
            this.listener = null;
        }
    }

    @Override
    public void release(Lock.LockMode mode, int count) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support releasing multiple locks");
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }

    @Override
    public synchronized LockInfo getLockInfo() {
        String lockType = this.mode_ == Lock.LockMode.WRITE_LOCK ? "WRITE" : "READ";
        return new LockInfo("COLLECTION", lockType, this.getId(), new String[]{this.owner_ == null ? "" : this.owner_.getName()});
    }

    @Override
    public void debug(PrintStream out) {
        this.getLockInfo().debug(out);
    }

    private static class SuspendedWaiter {
        final Thread thread;
        final Lock.LockMode lockMode;
        final int lockCount;

        public SuspendedWaiter(Thread thread, Lock.LockMode lockMode, int lockCount) {
            this.thread = thread;
            this.lockMode = lockMode;
            this.lockCount = lockCount;
        }
    }
}

