/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockListener;
import org.exist.storage.lock.MultiReadReentrantLock;
import org.exist.util.DeadlockException;
import org.exist.util.LockException;

public class WaitingThread
implements LockListener {
    private static final Logger LOG = LogManager.getLogger(WaitingThread.class);
    private final Thread thread;
    private final Object monitor;
    private final MultiReadReentrantLock lock;
    private final Lock.LockMode lockMode;
    private boolean suspended = false;
    private boolean deadlocked = false;

    public WaitingThread(Thread thread, Object monitor, MultiReadReentrantLock lock, Lock.LockMode lockMode) {
        this.monitor = monitor;
        this.lock = lock;
        this.thread = thread;
        this.lockMode = lockMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait() throws LockException {
        do {
            Object object = this.monitor;
            synchronized (object) {
                try {
                    this.monitor.wait(500L);
                }
                catch (InterruptedException e) {
                    throw new LockException("Interrupted while waiting for read lock");
                }
            }
            if (!this.deadlocked) continue;
            LOG.warn("Deadlock detected: cancelling wait...");
            throw new DeadlockException();
        } while (this.suspended);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDeadlock() {
        this.deadlocked = true;
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    public void suspendWaiting() {
        this.suspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockReleased() {
        this.suspended = false;
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Lock getLock() {
        return this.lock;
    }

    public Lock.LockMode getLockMode() {
        return this.lockMode;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WaitingThread)) {
            return false;
        }
        return this.thread == ((WaitingThread)obj).getThread();
    }
}

