/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.recovery;

import com.evolvedbinary.j8fu.function.SupplierE;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.Journal;
import org.exist.storage.journal.JournalManager;
import org.exist.storage.journal.JournalReader;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.journal.Lsn;
import org.exist.storage.sync.Sync;
import org.exist.storage.txn.Checkpoint;
import org.exist.util.FileUtils;
import org.exist.util.ProgressBar;
import org.exist.util.hashtable.Long2ObjectHashMap;
import org.exist.util.sanity.SanityCheck;

public class RecoveryManager {
    private static final Logger LOG = LogManager.getLogger(RecoveryManager.class);
    private final DBBroker broker;
    private final JournalRecoveryAccessor journalRecovery;
    private final boolean restartOnError;

    public RecoveryManager(DBBroker broker, JournalManager journalManager, boolean restartOnError) {
        this.broker = broker;
        this.journalRecovery = journalManager.getRecoveryAccessor(this);
        this.restartOnError = restartOnError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recover() throws LogException {
        int lastNum;
        boolean recoveryRun;
        block38: {
            List files;
            recoveryRun = false;
            try (Stream fileStream = (Stream)this.journalRecovery.getFiles.get();){
                files = fileStream.collect(Collectors.toList());
            }
            catch (IOException ioe) {
                throw new LogException("Unable to find journal files in data dir", ioe);
            }
            lastNum = Journal.findLastFile(files.stream());
            if (-1 < lastNum) {
                Path last = this.journalRecovery.getFile.apply(lastNum);
                JournalReader reader = new JournalReader(this.broker, last, lastNum);
                try {
                    boolean checkpointFound = false;
                    try {
                        Checkpoint checkpoint;
                        Loggable lastLog = reader.lastEntry();
                        if (lastLog != null && lastLog.getLogType() == 2 && (checkpoint = (Checkpoint)lastLog).getStoredLsn() == checkpoint.getLsn()) {
                            checkpointFound = true;
                            LOG.debug("Database is in clean state. Last checkpoint: " + checkpoint.getDateString());
                        }
                    }
                    catch (LogException e) {
                        LOG.info("Reading last journal log entry failed: " + e.getMessage() + ". Will scan the log...");
                        checkpointFound = false;
                    }
                    if (checkpointFound) break block38;
                    LOG.info("Unclean shutdown detected. Scanning journal...");
                    this.broker.getBrokerPool().reportStatus("Unclean shutdown detected. Scanning log...");
                    reader.position(1L);
                    Long2ObjectHashMap<Loggable> txnsStarted = new Long2ObjectHashMap<Loggable>();
                    AbstractLoggable lastCheckpoint = null;
                    long lastLsn = -1L;
                    try {
                        Loggable next;
                        ProgressBar progress = new ProgressBar("Scanning journal ", FileUtils.sizeQuietly(last));
                        while ((next = reader.nextEntry()) != null) {
                            progress.set(Lsn.getOffset(next.getLsn()));
                            if (next.getLogType() == 0) {
                                txnsStarted.put(next.getTransactionId(), next);
                            } else if (next.getLogType() == 3) {
                                txnsStarted.remove(next.getTransactionId());
                            } else if (next.getLogType() == 2) {
                                txnsStarted.clear();
                                lastCheckpoint = (Checkpoint)next;
                            }
                            lastLsn = next.getLsn();
                        }
                    }
                    catch (LogException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Caught exception while reading log", (Throwable)e);
                        }
                        LOG.warn("Last readable journal log entry lsn: " + Lsn.dump(lastLsn));
                    }
                    if ((lastCheckpoint == null || lastCheckpoint.getLsn() != lastLsn) && txnsStarted.size() > 0) {
                        LOG.info("Dirty transactions: " + txnsStarted.size());
                        if (lastCheckpoint == null) {
                            reader.position(1L);
                        } else {
                            reader.position(lastCheckpoint.getLsn());
                            Loggable loggable = reader.nextEntry();
                        }
                        recoveryRun = true;
                        try {
                            LOG.info("Running recovery...");
                            this.broker.getBrokerPool().reportStatus("Running recovery...");
                            this.doRecovery(txnsStarted.size(), last, reader, lastLsn);
                            break block38;
                        }
                        catch (LogException e) {
                            this.broker.getBrokerPool().reportStatus("aborted");
                            if (this.restartOnError) {
                                LOG.error("Aborting recovery. eXist-db detected an error during recovery. This may not be fatal. Database will start up, but corruptions are likely.");
                                break block38;
                            }
                            LOG.error("Aborting recovery. eXist-db detected an error during recovery. This may not be fatal. Please consider running a consistency check via the export tool and create a backup if problems are reported. The db should come up again if you restart it.");
                            throw e;
                        }
                    }
                    LOG.info("Database is in clean state. Nothing to recover from the journal.");
                }
                finally {
                    reader.close();
                    this.cleanDirectory(files.stream());
                    if (recoveryRun) {
                        this.broker.repairPrimary();
                        this.broker.sync(Sync.MAJOR);
                    }
                }
            }
        }
        this.journalRecovery.setCurrentFileNum.accept(lastNum);
        this.journalRecovery.switchFiles.get();
        this.journalRecovery.clearBackupFiles.get();
        return recoveryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRecovery(int txnCount, Path last, JournalReader reader, long lastLsn) throws LogException {
        block28: {
            if (LOG.isInfoEnabled()) {
                LOG.info("Running recovery ...");
            }
            this.journalRecovery.setInRecovery.accept(true);
            try {
                Long2ObjectHashMap<Loggable> runningTxns = new Long2ObjectHashMap<Loggable>();
                if (LOG.isInfoEnabled()) {
                    LOG.info("First pass: redoing " + txnCount + " transactions...");
                }
                ProgressBar progress = new ProgressBar("Redo ", FileUtils.sizeQuietly(last));
                Loggable next = null;
                int redoCnt = 0;
                try {
                    while ((next = reader.nextEntry()) != null) {
                        SanityCheck.ASSERT(next.getLogType() != 2, "Found a checkpoint during recovery run! This should not ever happen.");
                        if (next.getLogType() == 0) {
                            runningTxns.put(next.getTransactionId(), next);
                        } else if (next.getLogType() == 1) {
                            runningTxns.remove(next.getTransactionId());
                            ++redoCnt;
                        } else if (next.getLogType() == 3) {
                            runningTxns.remove(next.getTransactionId());
                        }
                        next.redo();
                        progress.set(Lsn.getOffset(next.getLsn()));
                        if (next.getLsn() != lastLsn) continue;
                        break;
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception caught while redoing transactions. Aborting recovery to avoid possible damage. Before starting again, make sure to run a check via the emergency export tool.", (Throwable)e);
                    if (next != null) {
                        LOG.info("Log entry that caused the exception: " + next.dump());
                    }
                    throw new LogException("Recovery aborted. ");
                }
                finally {
                    LOG.info("Redo processed " + redoCnt + " out of " + txnCount + " transactions.");
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("Second pass: undoing dirty transactions. Uncommitted transactions: " + runningTxns.size());
                }
                if (runningTxns.size() <= 0) break block28;
                try {
                    while ((next = reader.previousEntry()) != null) {
                        if (next.getLogType() == 0) {
                            if (runningTxns.get(next.getTransactionId()) != null) {
                                runningTxns.remove(next.getTransactionId());
                                if (runningTxns.size() == 0) {
                                    break;
                                }
                            }
                        } else if (next.getLogType() != 1 && next.getLogType() == 2) {
                            break;
                        }
                        if (runningTxns.get(next.getTransactionId()) == null) continue;
                        next.undo();
                    }
                }
                catch (Exception e) {
                    LOG.warn("Exception caught while undoing dirty transactions. Remaining transactions to be undone: " + runningTxns.size() + ". Aborting recovery to avoid possible damage. Before starting again, make sure to run a check via the emergency export tool.", (Throwable)e);
                    if (next != null) {
                        LOG.warn("Log entry that caused the exception: " + next.dump());
                    }
                    throw new LogException("Recovery aborted");
                }
            }
            finally {
                this.broker.sync(Sync.MAJOR);
                this.journalRecovery.setInRecovery.accept(false);
            }
        }
    }

    private void cleanDirectory(Stream<Path> files) {
        files.forEach(FileUtils::deleteQuietly);
    }

    public class JournalRecoveryAccessor {
        final Consumer<Boolean> setInRecovery;
        final SupplierE<Stream<Path>, IOException> getFiles;
        final Function<Integer, Path> getFile;
        final Consumer<Integer> setCurrentFileNum;
        final SupplierE<Void, LogException> switchFiles;
        final Supplier<Void> clearBackupFiles;

        public JournalRecoveryAccessor(Consumer<Boolean> setInRecovery, SupplierE<Stream<Path>, IOException> getFiles, Function<Integer, Path> getFile, Consumer<Integer> setCurrentFileNum, SupplierE<Void, LogException> switchFiles, Supplier<Void> clearBackupFiles) {
            this.setInRecovery = setInRecovery;
            this.getFiles = getFiles;
            this.getFile = getFile;
            this.setCurrentFileNum = setCurrentFileNum;
            this.switchFiles = switchFiles;
            this.clearBackupFiles = clearBackupFiles;
        }
    }
}

