/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.ProcessingInstructionImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.XMLUtil;
import org.exist.http.servlets.RequestWrapper;
import org.exist.http.servlets.ResponseWrapper;
import org.exist.http.servlets.SessionWrapper;
import org.exist.indexing.IndexController;
import org.exist.indexing.MatchListener;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.security.Subject;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.CustomMatchListenerFactory;
import org.exist.storage.serializers.XIncludeFilter;
import org.exist.util.Configuration;
import org.exist.util.MimeType;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.ReceiverToSAX;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xslt.TransformerFactoryAllocator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class Serializer
implements XMLReader {
    protected static final Logger LOG = LogManager.getLogger(Serializer.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "serializer";
    public static final String ENABLE_XINCLUDE_ATTRIBUTE = "enable-xinclude";
    public static final String PROPERTY_ENABLE_XINCLUDE = "serialization.enable-xinclude";
    public static final String ENABLE_XSL_ATTRIBUTE = "enable-xsl";
    public static final String PROPERTY_ENABLE_XSL = "serialization.enable-xsl";
    public static final String INDENT_ATTRIBUTE = "indent";
    public static final String PROPERTY_INDENT = "serialization.indent";
    public static final String COMPRESS_OUTPUT_ATTRIBUTE = "compress-output";
    public static final String PROPERTY_COMPRESS_OUTPUT = "serialization.compress-output";
    public static final String ADD_EXIST_ID_ATTRIBUTE = "add-exist-id";
    public static final String PROPERTY_ADD_EXIST_ID = "serialization.add-exist-id";
    public static final String TAG_MATCHING_ELEMENTS_ATTRIBUTE = "match-tagging-elements";
    public static final String PROPERTY_TAG_MATCHING_ELEMENTS = "serialization.match-tagging-elements";
    public static final String TAG_MATCHING_ATTRIBUTES_ATTRIBUTE = "match-tagging-attributes";
    public static final String PROPERTY_TAG_MATCHING_ATTRIBUTES = "serialization.match-tagging-attributes";
    public static final String PROPERTY_SESSION_ID = "serialization.session-id";
    public static final int TAG_NONE = 0;
    public static final int TAG_ELEMENT_MATCHES = 1;
    public static final int TAG_ATTRIBUTE_MATCHES = 2;
    public static final int TAG_BOTH = 3;
    public static final int EXIST_ID_NONE = 0;
    public static final int EXIST_ID_ELEMENT = 1;
    public static final int EXIST_ID_ALL = 2;
    protected int showId = 0;
    public static final String GENERATE_DOC_EVENTS = "sax-document-events";
    public static final String ENCODING = "encoding";
    protected static final QName ATTR_HITS_QNAME = new QName("hits", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_START_QNAME = new QName("start", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_COUNT_QNAME = new QName("count", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_RESULT_QNAME = new QName("result", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_SESSION_ID = new QName("session", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_COMPILATION_TIME_QNAME = new QName("compilation-time", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_EXECUTION_TIME_QNAME = new QName("execution-time", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_TYPE_QNAME = new QName("type", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_VALUE_QNAME = new QName("value", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_DOC_QNAME = new QName("document", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_ATTR_QNAME = new QName("attribute", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ELEM_TEXT_QNAME = new QName("text", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_URI_QNAME = new QName("uri", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_TNS_QNAME = new QName("target-namespace", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_LOCAL_QNAME = new QName("local", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_PREFIX_QNAME = new QName("prefix", "http://exist.sourceforge.net/NS/exist", "exist");
    protected static final QName ATTR_HAS_ELEMENT_QNAME = new QName("has-element", "http://exist.sourceforge.net/NS/exist", "exist");
    protected DBBroker broker;
    protected String encoding = "UTF-8";
    private EntityResolver entityResolver = null;
    private ErrorHandler errorHandler = null;
    protected SAXTransformerFactory factory;
    protected boolean createContainerElements = false;
    protected Properties defaultProperties = new Properties();
    protected Properties outputProperties;
    protected Templates templates = null;
    protected TransformerHandler xslHandler = null;
    protected XIncludeFilter xinclude;
    protected CustomMatchListenerFactory customMatchListeners;
    protected Receiver receiver = null;
    protected SAXSerializer xmlout = null;
    protected LexicalHandler lexicalHandler = null;
    protected Subject user = null;
    protected HttpContext httpContext = null;

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public Serializer(DBBroker broker, Configuration config) {
        this(broker, config, null);
    }

    public Serializer(DBBroker broker, Configuration config, List<String> chainOfReceivers) {
        this.broker = broker;
        this.factory = TransformerFactoryAllocator.getTransformerFactory(broker.getBrokerPool());
        this.xinclude = new XIncludeFilter(this);
        this.customMatchListeners = new CustomMatchListenerFactory(broker, config, chainOfReceivers);
        this.receiver = this.xinclude;
        String option = (String)config.getProperty(PROPERTY_ENABLE_XSL);
        if (option != null) {
            this.defaultProperties.setProperty("process-xsl-pi", option);
        } else {
            this.defaultProperties.setProperty("process-xsl-pi", "no");
        }
        option = (String)config.getProperty(PROPERTY_ENABLE_XINCLUDE);
        if (option != null) {
            this.defaultProperties.setProperty("expand-xincludes", option);
        }
        if ((option = (String)config.getProperty(PROPERTY_INDENT)) != null) {
            this.defaultProperties.setProperty(INDENT_ATTRIBUTE, option);
        }
        if ((option = (String)config.getProperty(PROPERTY_COMPRESS_OUTPUT)) != null) {
            this.defaultProperties.setProperty(COMPRESS_OUTPUT_ATTRIBUTE, option);
        }
        if ((option = (String)config.getProperty(PROPERTY_ADD_EXIST_ID)) != null) {
            this.defaultProperties.setProperty(ADD_EXIST_ID_ATTRIBUTE, option);
        }
        boolean tagElements = true;
        boolean tagAttributes = false;
        option = (String)config.getProperty(PROPERTY_TAG_MATCHING_ELEMENTS);
        if (option != null) {
            tagElements = "yes".equals(option);
        }
        if ((option = (String)config.getProperty(PROPERTY_TAG_MATCHING_ATTRIBUTES)) != null) {
            tagAttributes = "yes".equals(option);
        }
        option = tagElements && tagAttributes ? "both" : (tagElements ? "elements" : (tagAttributes ? "attributes" : "none"));
        this.defaultProperties.setProperty("highlight-matches", option);
        this.defaultProperties.setProperty(GENERATE_DOC_EVENTS, "true");
        this.outputProperties = new Properties(this.defaultProperties);
    }

    public void setProperties(Properties properties) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.equals("http://xml.org/sax/properties/lexical-handler")) {
                this.lexicalHandler = (LexicalHandler)properties.get(key);
                continue;
            }
            this.setProperty(key, properties.getProperty(key));
        }
    }

    public void setProperties(HashMap<String, Object> table) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (table == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue().toString());
        }
    }

    @Override
    public void setProperty(String prop, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        switch (prop) {
            case "http://xml.org/sax/properties/lexical-handler": {
                this.lexicalHandler = (LexicalHandler)value;
                break;
            }
            case "add-exist-id": {
                if ("element".equals(value)) {
                    this.showId = 1;
                    break;
                }
                if ("all".equals(value)) {
                    this.showId = 2;
                    break;
                }
                this.showId = 0;
                break;
            }
            default: {
                this.outputProperties.put(prop, value);
            }
        }
    }

    public String getProperty(String key, String defaultValue) {
        String value = this.outputProperties.getProperty(key, defaultValue);
        return value;
    }

    public boolean isStylesheetApplied() {
        return this.templates != null;
    }

    protected int getHighlightingMode() {
        String option = this.getProperty("highlight-matches", "elements");
        if ("both".equals(option) || "all".equals(option)) {
            return 3;
        }
        if ("elements".equals(option)) {
            return 1;
        }
        if ("attributes".equals(option)) {
            return 2;
        }
        return 0;
    }

    protected void applyXSLHandler(Writer writer) {
        StreamResult result = new StreamResult(writer);
        this.xslHandler.setResult(result);
        if ("yes".equals(this.getProperty("expand-xincludes", "yes"))) {
            this.xinclude.setReceiver(new ReceiverToSAX(this.xslHandler));
            this.receiver = this.xinclude;
        } else {
            this.receiver = new ReceiverToSAX(this.xslHandler);
        }
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setUser(Subject user) {
        this.user = user;
    }

    public Subject getUser() {
        return this.user;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            throw new SAXNotSupportedException(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(name);
    }

    public String getStylesheetProperty(String name) {
        if (this.xslHandler != null) {
            return this.xslHandler.getTransformer().getOutputProperty(name);
        }
        return null;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        String doc = input.getSystemId();
        if (doc == null) {
            throw new SAXException("source is not an eXist document");
        }
        this.parse(doc);
    }

    protected void setDocument(DocumentImpl doc) {
        this.xinclude.setDocument(doc);
    }

    protected void setXQueryContext(XQueryContext context) {
        if (context != null) {
            this.xinclude.setModuleLoadPath(context.getModuleLoadPath());
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        try {
            DocumentImpl doc = this.broker.getResource(XmldbURI.create(systemId), 4);
            if (doc == null) {
                throw new SAXException("document " + systemId + " not found in database");
            }
            LOG.debug("serializing " + doc.getFileURI());
            this.toSAX(doc);
        }
        catch (PermissionDeniedException e) {
            throw new SAXException("permission denied");
        }
    }

    public void reset() {
        this.receiver = this.xinclude;
        this.xinclude.setModuleLoadPath(null);
        this.xinclude.setReceiver(null);
        this.xslHandler = null;
        this.templates = null;
        this.outputProperties.clear();
        this.showId = 0;
        this.httpContext = null;
    }

    public String serialize(DocumentImpl doc) throws SAXException {
        StringWriter writer = new StringWriter();
        this.serialize(doc, (Writer)writer);
        return writer.toString();
    }

    public void serialize(DocumentImpl doc, Writer writer) throws SAXException {
        this.serialize(doc, writer, true);
    }

    public void serialize(DocumentImpl doc, Writer writer, boolean prepareStylesheet) throws SAXException {
        if (prepareStylesheet) {
            try {
                this.prepareStylesheets(doc);
            }
            catch (TransformerConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
        if (this.templates != null) {
            this.applyXSLHandler(writer);
        } else {
            NodeList children = doc.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String[] params;
                StoredNode node = (StoredNode)children.item(i);
                if (node.getNodeType() != 7 || !"exist-serialize".equals(node.getNodeName())) continue;
                for (String param : params = ((ProcessingInstructionImpl)node).getData().split(" ")) {
                    String[] opt = Option.parseKeyValuePair(param);
                    if (opt == null) continue;
                    this.outputProperties.setProperty(opt[0], opt[1]);
                }
            }
            this.setPrettyPrinter(writer, "no".equals(this.outputProperties.getProperty("omit-xml-declaration", "yes")), null, true);
        }
        this.serializeToReceiver(doc, true);
        this.releasePrettyPrinter();
    }

    public String serialize(NodeValue n) throws SAXException {
        StringWriter out = new StringWriter();
        this.serialize(n, (Writer)out);
        return out.toString();
    }

    public void serialize(NodeValue n, Writer out) throws SAXException {
        try {
            if (n.getItemType() == 6 && !(n instanceof NodeProxy)) {
                this.setStylesheetFromProperties((Document)((Object)n));
            } else {
                this.setStylesheetFromProperties(n.getOwnerDocument());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        if (this.templates != null) {
            this.applyXSLHandler(out);
        } else {
            this.setPrettyPrinter(out, "no".equals(this.outputProperties.getProperty("omit-xml-declaration", "yes")), n.getImplementationType() == 1 ? (NodeProxy)n : null, false);
        }
        this.serializeToReceiver(n, true);
        this.releasePrettyPrinter();
    }

    public String serialize(NodeProxy p) throws SAXException {
        StringWriter out = new StringWriter();
        this.serialize(p, (Writer)out);
        return out.toString();
    }

    public void serialize(NodeProxy p, Writer out) throws SAXException {
        try {
            this.setStylesheetFromProperties(p.getOwnerDocument());
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        if (this.templates != null) {
            this.applyXSLHandler(out);
        } else {
            this.setPrettyPrinter(out, "no".equals(this.outputProperties.getProperty("omit-xml-declaration", "yes")), p, false);
        }
        this.serializeToReceiver(p, false);
        this.releasePrettyPrinter();
    }

    public void prepareStylesheets(DocumentImpl doc) throws TransformerConfigurationException {
        String stylesheet;
        if ("yes".equals(this.outputProperties.getProperty("process-xsl-pi", "no")) && (stylesheet = this.hasXSLPi(doc)) != null) {
            this.setStylesheet(doc, stylesheet);
        }
        this.setStylesheetFromProperties(doc);
    }

    public void setSAXHandlers(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        ReceiverToSAX toSAX = new ReceiverToSAX(contentHandler);
        toSAX.setLexicalHandler(lexicalHandler);
        if ("yes".equals(this.getProperty("expand-xincludes", "yes"))) {
            this.xinclude.setReceiver(toSAX);
            this.receiver = this.xinclude;
        } else {
            this.receiver = toSAX;
        }
    }

    public void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    public void setReceiver(Receiver receiver, boolean handleIncludes) {
        if (handleIncludes && "yes".equals(this.getProperty("expand-xincludes", "yes"))) {
            this.xinclude.setReceiver(receiver);
            this.receiver = this.xinclude;
        } else {
            this.receiver = receiver;
        }
    }

    public XIncludeFilter getXIncludeFilter() {
        return this.xinclude;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.setSAXHandlers(handler, null);
    }

    @Override
    public ContentHandler getContentHandler() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces") || name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            throw new SAXNotSupportedException(name);
        }
        throw new SAXNotRecognizedException(name);
    }

    protected void setPrettyPrinter(Writer writer, boolean xmlDecl, NodeProxy root, boolean applyFilters) {
        IndexController controller;
        MatchListener listener;
        this.outputProperties.setProperty("omit-xml-declaration", xmlDecl ? "no" : "yes");
        this.xmlout = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
        this.xmlout.setOutput(writer, this.outputProperties);
        if ("yes".equals(this.getProperty("expand-xincludes", "yes"))) {
            this.xinclude.setReceiver(this.xmlout);
            this.receiver = this.xinclude;
        } else {
            this.receiver = this.xmlout;
        }
        if (root != null && this.getHighlightingMode() != 0 && (listener = (controller = this.broker.getIndexController()).getMatchListener(root)) != null) {
            MatchListener last = (MatchListener)listener.getLastInChain();
            last.setNextInChain(this.receiver);
            this.receiver = listener;
        }
        if (root == null && applyFilters && this.customMatchListeners.getFirst() != null) {
            this.customMatchListeners.getLast().setNextInChain(this.receiver);
            this.receiver = this.customMatchListeners.getFirst();
        }
    }

    protected Receiver setupMatchListeners(NodeProxy p) {
        IndexController controller;
        MatchListener listener;
        Receiver oldReceiver = this.receiver;
        if (this.getHighlightingMode() != 0 && (listener = (controller = this.broker.getIndexController()).getMatchListener(p)) != null) {
            MatchListener last = (MatchListener)listener.getLastInChain();
            last.setNextInChain(this.receiver);
            this.receiver = listener;
        }
        return oldReceiver;
    }

    protected void releasePrettyPrinter() {
        if (this.xmlout != null) {
            SerializerPool.getInstance().returnObject(this.xmlout);
        }
        this.xmlout = null;
    }

    protected void setStylesheetFromProperties(Document doc) throws TransformerConfigurationException {
        if (this.templates != null) {
            return;
        }
        String stylesheet = this.outputProperties.getProperty("stylesheet");
        if (stylesheet != null) {
            if (doc instanceof DocumentImpl) {
                this.setStylesheet((DocumentImpl)doc, stylesheet);
            } else {
                this.setStylesheet(null, stylesheet);
            }
        }
    }

    protected void checkStylesheetParams() {
        if (this.xslHandler == null) {
            return;
        }
        Enumeration<?> e = this.outputProperties.propertyNames();
        while (e.hasMoreElements()) {
            String property = (String)e.nextElement();
            if (!property.startsWith("stylesheet-param")) continue;
            String value = this.outputProperties.getProperty(property);
            property = property.substring("stylesheet-param".length() + 1);
            this.xslHandler.getTransformer().setParameter(property, value);
        }
    }

    public void setStylesheet(DocumentImpl doc, String stylesheet) throws TransformerConfigurationException {
        if (stylesheet == null) {
            this.templates = null;
            return;
        }
        long start = System.currentTimeMillis();
        this.xslHandler = null;
        XmldbURI stylesheetUri = null;
        URI externalUri = null;
        try {
            stylesheetUri = XmldbURI.xmldbUriFor(stylesheet);
            if (!stylesheetUri.toCollectionPathURI().equals(stylesheetUri)) {
                externalUri = stylesheetUri.getXmldbURI();
            }
        }
        catch (URISyntaxException e) {
            try {
                externalUri = new URI(stylesheet);
            }
            catch (URISyntaxException ee) {
                throw new IllegalArgumentException("Stylesheet URI could not be parsed: " + ee.getMessage());
            }
        }
        if (externalUri != null) {
            StreamSource source = new StreamSource(externalUri.toString());
            this.templates = this.factory.newTemplates(source);
        } else {
            if (doc != null) {
                stylesheetUri = doc.getCollection().getURI().resolveCollectionPath(stylesheetUri).normalizeCollectionPath();
            }
            DocumentImpl xsl = null;
            try {
                xsl = this.broker.getResource(stylesheetUri, 4);
            }
            catch (PermissionDeniedException e) {
                throw new TransformerConfigurationException("permission denied to read " + stylesheetUri);
            }
            if (xsl == null) {
                throw new TransformerConfigurationException("stylesheet not found: " + stylesheetUri);
            }
            if (xsl.getCollection() != null) {
                this.factory.setURIResolver(new InternalURIResolver(xsl.getCollection().getURI().toString()));
            }
            Receiver oldReceiver = this.receiver;
            this.factory.setErrorListener(new ErrorListener());
            TemplatesHandler handler = this.factory.newTemplatesHandler();
            this.receiver = new ReceiverToSAX(handler);
            try {
                this.serializeToReceiver(xsl, true);
                this.templates = handler.getTemplates();
            }
            catch (SAXException e) {
                throw new TransformerConfigurationException(e.getMessage(), e);
            }
            this.receiver = oldReceiver;
            this.factory.setURIResolver(null);
        }
        LOG.debug("compiling stylesheet took " + (System.currentTimeMillis() - start));
        if (this.templates != null) {
            this.xslHandler = this.factory.newTransformerHandler(this.templates);
        }
        this.checkStylesheetParams();
    }

    public void setStylesheetParam(String param, String value) {
        if (this.xslHandler != null) {
            this.xslHandler.getTransformer().setParameter(param, value);
        }
    }

    protected void setXSLHandler(NodeProxy root, boolean applyFilters) {
        IndexController controller;
        MatchListener listener;
        if (this.templates != null && this.xslHandler != null) {
            SAXResult result = new SAXResult();
            boolean processXInclude = "yes".equals(this.getProperty("expand-xincludes", "yes"));
            ReceiverToSAX filter = processXInclude ? (ReceiverToSAX)this.xinclude.getReceiver() : (ReceiverToSAX)this.receiver;
            result.setHandler(filter.getContentHandler());
            result.setLexicalHandler(filter.getLexicalHandler());
            filter.setLexicalHandler(this.xslHandler);
            filter.setContentHandler(this.xslHandler);
            this.xslHandler.setResult(result);
            if (processXInclude) {
                this.xinclude.setReceiver(new ReceiverToSAX(this.xslHandler));
                this.receiver = this.xinclude;
            } else {
                this.receiver = new ReceiverToSAX(this.xslHandler);
            }
        }
        if (root != null && this.getHighlightingMode() != 0 && (listener = (controller = this.broker.getIndexController()).getMatchListener(root)) != null) {
            MatchListener last = (MatchListener)listener.getLastInChain();
            last.setNextInChain(this.receiver);
            this.receiver = listener;
        }
        if (applyFilters && root == null && this.customMatchListeners.getFirst() != null) {
            this.customMatchListeners.getLast().setNextInChain(this.receiver);
            this.receiver = this.customMatchListeners.getFirst();
        }
    }

    public void toSAX(DocumentImpl doc) throws SAXException {
        String stylesheet;
        if ("yes".equals(this.outputProperties.getProperty("process-xsl-pi", "no")) && (stylesheet = this.hasXSLPi(doc)) != null) {
            try {
                this.setStylesheet(doc, stylesheet);
            }
            catch (TransformerConfigurationException e) {
                throw new SAXException(e.getMessage(), e);
            }
        }
        try {
            this.setStylesheetFromProperties(doc);
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.setXSLHandler(null, true);
        this.serializeToReceiver(doc, "true".equals(this.getProperty(GENERATE_DOC_EVENTS, "false")));
    }

    public void toSAX(NodeValue n) throws SAXException {
        try {
            if (n.getType() == 6 && !(n instanceof NodeProxy)) {
                this.setStylesheetFromProperties((Document)((Object)n));
            } else {
                this.setStylesheetFromProperties(n.getOwnerDocument());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.setXSLHandler(n.getImplementationType() == 1 ? (NodeProxy)n : null, false);
        this.serializeToReceiver(n, "true".equals(this.getProperty(GENERATE_DOC_EVENTS, "false")));
    }

    public void toSAX(NodeProxy p) throws SAXException {
        try {
            this.setStylesheetFromProperties(p.getOwnerDocument());
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.setXSLHandler(p, false);
        if (p.getNodeId() == NodeId.DOCUMENT_NODE) {
            this.serializeToReceiver(p.getOwnerDocument(), "true".equals(this.getProperty(GENERATE_DOC_EVENTS, "false")));
        } else {
            this.serializeToReceiver(p, "true".equals(this.getProperty(GENERATE_DOC_EVENTS, "false")));
        }
    }

    public void toSAX(Sequence seq, int start, int count, boolean wrap, boolean typed, long compilationTime, long executionTime) throws SAXException {
        try {
            this.setStylesheetFromProperties(null);
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.setXSLHandler(null, false);
        AttrList attrs = new AttrList();
        attrs.addAttribute(ATTR_HITS_QNAME, Integer.toString(seq.getItemCount()));
        attrs.addAttribute(ATTR_START_QNAME, Integer.toString(start));
        attrs.addAttribute(ATTR_COUNT_QNAME, Integer.toString(count));
        if (this.outputProperties.getProperty(PROPERTY_SESSION_ID) != null) {
            attrs.addAttribute(ATTR_SESSION_ID, this.outputProperties.getProperty(PROPERTY_SESSION_ID));
        }
        attrs.addAttribute(ATTR_COMPILATION_TIME_QNAME, Long.toString(compilationTime));
        attrs.addAttribute(ATTR_EXECUTION_TIME_QNAME, Long.toString(compilationTime));
        this.receiver.startDocument();
        if (wrap) {
            this.receiver.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            this.receiver.startElement(ELEM_RESULT_QNAME, attrs);
        }
        for (int i = --start; i < start + count; ++i) {
            Item item = seq.itemAt(i);
            if (item == null) {
                LOG.debug("item " + i + " not found");
                continue;
            }
            this.itemToSAX(item, typed, wrap);
        }
        if (wrap) {
            this.receiver.endElement(ELEM_RESULT_QNAME);
            this.receiver.endPrefixMapping("exist");
        }
        this.receiver.endDocument();
    }

    public void toSAX(Sequence seq) throws SAXException {
        try {
            this.setStylesheetFromProperties(null);
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.setXSLHandler(null, false);
        this.receiver.startDocument();
        try {
            SequenceIterator itSeq = seq.iterate();
            while (itSeq.hasNext()) {
                Item item = itSeq.nextItem();
                this.itemToSAX(item, false, false);
            }
        }
        catch (XPathException xpe) {
            throw new SAXException(xpe.getMessage(), xpe);
        }
        this.receiver.endDocument();
    }

    public void toSAX(Item item, boolean wrap, boolean typed) throws SAXException {
        try {
            this.setStylesheetFromProperties(null);
        }
        catch (TransformerConfigurationException e) {
            throw new SAXException(e.getMessage(), e);
        }
        this.setXSLHandler(null, false);
        AttrList attrs = new AttrList();
        attrs.addAttribute(ATTR_HITS_QNAME, "1");
        attrs.addAttribute(ATTR_START_QNAME, "1");
        attrs.addAttribute(ATTR_COUNT_QNAME, "1");
        if (this.outputProperties.getProperty(PROPERTY_SESSION_ID) != null) {
            attrs.addAttribute(ATTR_SESSION_ID, this.outputProperties.getProperty(PROPERTY_SESSION_ID));
        }
        this.receiver.startDocument();
        if (wrap) {
            this.receiver.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            this.receiver.startElement(ELEM_RESULT_QNAME, attrs);
        }
        this.itemToSAX(item, typed, wrap);
        if (wrap) {
            this.receiver.endElement(ELEM_RESULT_QNAME);
            this.receiver.endPrefixMapping("exist");
        }
        this.receiver.endDocument();
    }

    private void itemToSAX(Item item, boolean typed, boolean wrap) throws SAXException {
        if (Type.subTypeOf(item.getType(), -1)) {
            NodeValue node = (NodeValue)item;
            if (typed) {
                this.serializeTypePreNode(node);
                if (node.getType() == 2) {
                    this.serializeTypeAttributeValue(node);
                } else {
                    this.serializeToReceiver(node, false);
                }
                this.serializeTypePostNode(node);
            } else {
                this.serializeToReceiver(node, false);
            }
        } else {
            if (wrap) {
                AttrList attrs = new AttrList();
                attrs.addAttribute(ATTR_TYPE_QNAME, Type.getTypeName(item.getType()));
                this.receiver.startElement(ELEM_VALUE_QNAME, attrs);
            }
            try {
                this.receiver.characters(item.getStringValue());
            }
            catch (XPathException e) {
                throw new SAXException(e.getMessage(), e);
            }
            if (wrap) {
                this.receiver.endElement(ELEM_VALUE_QNAME);
            }
        }
    }

    public void toReceiver(NodeProxy p, boolean highlightMatches) throws SAXException {
        this.toReceiver(p, highlightMatches, true);
    }

    public void toReceiver(NodeProxy p, boolean highlightMatches, boolean checkAttributes) throws SAXException {
        Receiver oldReceiver = highlightMatches ? this.setupMatchListeners(p) : this.receiver;
        this.serializeToReceiver(p, false, checkAttributes);
        this.receiver = oldReceiver;
    }

    protected abstract void serializeToReceiver(NodeProxy var1, boolean var2, boolean var3) throws SAXException;

    protected abstract void serializeToReceiver(DocumentImpl var1, boolean var2) throws SAXException;

    protected void serializeToReceiver(NodeValue v, boolean generateDocEvents) throws SAXException {
        if (v.getImplementationType() == 1) {
            this.serializeToReceiver((NodeProxy)v, generateDocEvents, true);
        } else {
            this.serializeToReceiver((NodeImpl)v, generateDocEvents);
        }
    }

    protected void serializeToReceiver(NodeImpl n, boolean generateDocEvents) throws SAXException {
        if (generateDocEvents) {
            this.receiver.startDocument();
        }
        this.setDocument(null);
        if (n.getNodeType() == 9) {
            this.setXQueryContext(((org.exist.dom.memtree.DocumentImpl)n).getContext());
        } else {
            this.setXQueryContext(n.getOwnerDocument().getContext());
        }
        n.streamTo(this, this.receiver);
        if (generateDocEvents) {
            this.receiver.endDocument();
        }
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    public String hasXSLPi(Document doc) {
        boolean applyXSLPI = this.outputProperties.getProperty("process-xsl-pi", "no").equalsIgnoreCase("yes");
        if (!applyXSLPI) {
            return null;
        }
        NodeList docChildren = doc.getChildNodes();
        for (int i = 0; i < docChildren.getLength(); ++i) {
            String href;
            String xsl;
            String type;
            Node node = docChildren.item(i);
            if (node.getNodeType() != 7 || !"xml-stylesheet".equals(((ProcessingInstruction)node).getTarget()) || (type = XMLUtil.parseValue(xsl = ((ProcessingInstruction)node).getData(), "type")) == null || !type.equals(MimeType.XML_TYPE.getName()) && !type.equals(MimeType.XSL_TYPE.getName()) && !type.equals(MimeType.XSLT_TYPE.getName()) || (href = XMLUtil.parseValue(xsl, "href")) == null) continue;
            return href;
        }
        return null;
    }

    protected void serializeTypeAttributeValue(NodeValue item) throws SAXException {
        try {
            this.receiver.characters(item.getStringValue());
        }
        catch (XPathException e) {
            LOG.error("XPath error trying to retrieve attribute value. " + e.getMessage(), (Throwable)e);
        }
    }

    protected void serializeTypePreNode(NodeValue item) throws SAXException {
        AttrList attrs = null;
        switch (item.getType()) {
            case 6: {
                String baseUri = ((Document)((Object)item)).getBaseURI();
                attrs = new AttrList();
                if (baseUri != null && baseUri.length() > 0) {
                    attrs.addAttribute(ATTR_URI_QNAME, baseUri);
                }
                if (((Document)((Object)item)).getDocumentElement() == null) {
                    attrs.addAttribute(ATTR_HAS_ELEMENT_QNAME, "false");
                }
                this.receiver.startElement(ELEM_DOC_QNAME, attrs);
                break;
            }
            case 2: {
                attrs = new AttrList();
                String attributeValue = item.getNode().getLocalName();
                if (attributeValue != null && attributeValue.length() > 0) {
                    attrs.addAttribute(ATTR_LOCAL_QNAME, attributeValue);
                }
                if ((attributeValue = item.getNode().getNamespaceURI()) != null && attributeValue.length() > 0) {
                    attrs.addAttribute(ATTR_TNS_QNAME, attributeValue);
                }
                if ((attributeValue = item.getNode().getPrefix()) != null && attributeValue.length() > 0) {
                    attrs.addAttribute(ATTR_PREFIX_QNAME, attributeValue);
                }
                this.receiver.startElement(ELEM_ATTR_QNAME, attrs);
                break;
            }
            case 3: {
                this.receiver.startElement(ELEM_TEXT_QNAME, null);
                break;
            }
        }
    }

    protected void serializeTypePostNode(NodeValue item) throws SAXException {
        switch (item.getType()) {
            case 6: {
                this.receiver.endElement(ELEM_DOC_QNAME);
                break;
            }
            case 2: {
                this.receiver.endElement(ELEM_ATTR_QNAME);
                break;
            }
            case 3: {
                this.receiver.endElement(ELEM_TEXT_QNAME);
                break;
            }
        }
    }

    private static class ErrorListener
    implements javax.xml.transform.ErrorListener {
        private ErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            LOG.warn("Warning while applying stylesheet: " + exception.getMessage(), (Throwable)exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }

    private class InternalURIResolver
    implements URIResolver {
        private String collectionId = null;

        public InternalURIResolver(String collection) {
            this.collectionId = collection;
        }

        @Override
        public Source resolve(String href, String base) throws TransformerException {
            LOG.debug("resolving stylesheet ref " + href);
            if (href.indexOf(58) != -1) {
                return null;
            }
            URI baseURI = URI.create(this.collectionId + "/");
            URI uri = URI.create(href);
            href = baseURI.resolve(uri).toString();
            Serializer serializer = Serializer.this.broker.newSerializer();
            return new SAXSource(serializer, new InputSource(href));
        }
    }

    public class HttpContext {
        private RequestWrapper request = null;
        private ResponseWrapper response = null;
        private SessionWrapper session = null;

        public RequestWrapper getRequest() {
            return this.request;
        }

        public void setRequest(RequestWrapper request) {
            this.request = request;
        }

        public ResponseWrapper getResponse() {
            return this.response;
        }

        public void setResponse(ResponseWrapper response) {
            this.response = response;
        }

        public SessionWrapper getSession() {
            return this.session;
        }

        public void setSession(SessionWrapper session) {
            this.session = session;
        }
    }
}

