/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.serializers;

import com.evolvedbinary.j8fu.Either;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.INodeHandle;
import org.exist.dom.QName;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.AbstractSource;
import org.exist.source.DBSource;
import org.exist.source.StringSource;
import org.exist.storage.XQueryPool;
import org.exist.storage.serializers.Serializer;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XIncludeFilter
implements Receiver {
    private static final Logger LOG = LogManager.getLogger(XIncludeFilter.class);
    private static final QName HREF_ATTRIB = new QName("href", "");
    private static final QName XPOINTER_ATTRIB = new QName("xpointer", "");
    private static final String XI_INCLUDE = "include";
    private static final String XI_FALLBACK = "fallback";
    private Receiver receiver;
    private Serializer serializer;
    private DocumentImpl document = null;
    private String moduleLoadPath = null;
    private Map<String, String> namespaces = new HashMap<String, String>(10);
    private boolean inFallback = false;
    private ResourceError error = null;

    public XIncludeFilter(Serializer serializer, Receiver receiver) {
        this.receiver = receiver;
        this.serializer = serializer;
    }

    public XIncludeFilter(Serializer serializer) {
        this(serializer, null);
    }

    public void setReceiver(Receiver handler) {
        this.receiver = handler;
    }

    public Receiver getReceiver() {
        return this.receiver;
    }

    public void setDocument(DocumentImpl doc) {
        this.document = doc;
        this.inFallback = false;
        this.error = null;
    }

    public void setModuleLoadPath(String path) {
        this.moduleLoadPath = path;
    }

    @Override
    public void characters(CharSequence seq) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.characters(seq);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.comment(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.receiver.endDocument();
    }

    @Override
    public void endElement(QName qname) throws SAXException {
        if ("http://www.w3.org/2001/XInclude".equals(qname.getNamespaceURI())) {
            if (XI_FALLBACK.equals(qname.getLocalPart())) {
                this.inFallback = false;
                this.error = null;
            } else if (XI_INCLUDE.equals(qname.getLocalPart()) && this.error != null) {
                SAXException e = this.error.cause.map(cause -> new SAXException(this.error.message, (Exception)cause)).orElse(new SAXException(this.error.message));
                this.error = null;
                throw e;
            }
        } else if (!this.inFallback || this.error != null) {
            this.receiver.endElement(qname);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
        this.receiver.endPrefixMapping(prefix);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.processingInstruction(target, data);
        }
    }

    @Override
    public void cdataSection(char[] ch, int start, int len) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.cdataSection(ch, start, len);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.receiver.startDocument();
    }

    @Override
    public void attribute(QName qname, String value) throws SAXException {
        if (!this.inFallback || this.error != null) {
            this.receiver.attribute(qname, value);
        }
    }

    @Override
    public void startElement(QName qname, AttrList attribs) throws SAXException {
        if (qname.getNamespaceURI() != null && qname.getNamespaceURI().equals("http://www.w3.org/2001/XInclude")) {
            if (qname.getLocalPart().equals(XI_INCLUDE)) {
                Optional<ResourceError> maybeResourceError;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("processing include ...");
                }
                if ((maybeResourceError = this.processXInclude(attribs.getValue(HREF_ATTRIB), attribs.getValue(XPOINTER_ATTRIB))).isPresent()) {
                    ResourceError resourceError = maybeResourceError.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(resourceError.message, (Object)resourceError);
                    }
                    this.error = resourceError;
                }
            } else if (qname.getLocalPart().equals(XI_FALLBACK)) {
                this.inFallback = true;
            }
        } else if (!this.inFallback || this.error != null) {
            this.receiver.startElement(qname, attribs);
        }
    }

    @Override
    public void documentType(String name, String publicId, String systemId) throws SAXException {
        this.receiver.documentType(name, publicId, systemId);
    }

    @Override
    public void highlightText(CharSequence seq) {
    }

    protected Optional<ResourceError> processXInclude(String href, String xpointer) throws SAXException {
        if (href == null) {
            throw new SAXException("No href attribute found in XInclude include element");
        }
        DocumentImpl prevDoc = this.document;
        boolean createContainerElements = this.serializer.createContainerElements;
        this.serializer.createContainerElements = false;
        XmldbURI docUri = null;
        try {
            docUri = XmldbURI.xmldbUriFor(href);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        LOG.debug("found href=\"" + href + "\"");
        Map<String, String> params = null;
        DocumentImpl doc = null;
        org.exist.dom.memtree.DocumentImpl memtreeDoc = null;
        boolean xqueryDoc = false;
        if (docUri != null) {
            String fragment = docUri.getFragment();
            if (fragment != null && fragment.length() != 0) {
                throw new SAXException("Fragment identifiers must not be used in an xinclude href attribute. To specify an xpointer, use the xpointer attribute.");
            }
            params = null;
            String paramStr = docUri.getQuery();
            if (paramStr != null) {
                params = this.processParameters(paramStr);
                docUri = XmldbURI.create(docUri.getRawCollectionPath());
            }
            if (!docUri.isAbsolute() && this.document != null) {
                String base = this.document.getCollection().getURI() + "/";
                String child = "./" + docUri.toString();
                URI baseUri = URI.create(base);
                URI childUri = URI.create(child);
                URI uRI = baseUri.resolve(childUri);
                docUri = XmldbURI.create(uRI);
            }
            try {
                doc = this.serializer.broker.getResource(docUri, 4);
            }
            catch (PermissionDeniedException e) {
                return Optional.of(new ResourceError("Permission denied to read XInclude'd resource", e));
            }
            if (doc != null && doc.getResourceType() == 1) {
                xqueryDoc = "application/xquery".equals(doc.getMetadata().getMimeType());
            }
        }
        if (docUri == null || doc == null && !docUri.isAbsolute()) {
            try {
                String path;
                Path f;
                URI externalUri = new URI(href);
                String scheme = externalUri.getScheme();
                if (scheme == null && this.moduleLoadPath != null && !(f = Paths.get(path = externalUri.getSchemeSpecificPart(), new String[0])).isAbsolute()) {
                    if (this.moduleLoadPath.startsWith("xmldb:")) {
                        XmldbURI parentUri = XmldbURI.create(this.moduleLoadPath);
                        docUri = parentUri.append(path);
                        doc = (DocumentImpl)this.serializer.broker.getXMLResource(docUri);
                        if (doc != null && !doc.getPermissions().validate(this.serializer.broker.getCurrentSubject(), 4)) {
                            throw new PermissionDeniedException("Permission denied to read XInclude'd resource");
                        }
                    } else {
                        f = Paths.get(this.moduleLoadPath, path);
                        externalUri = f.toUri();
                    }
                }
                if (doc == null) {
                    Either<ResourceError, org.exist.dom.memtree.DocumentImpl> external = this.parseExternal(externalUri);
                    if (external.isLeft()) {
                        return Optional.of(external.left().get());
                    }
                    memtreeDoc = (org.exist.dom.memtree.DocumentImpl)external.right().get();
                }
            }
            catch (PermissionDeniedException e) {
                return Optional.of(new ResourceError("Permission denied on XInclude'd resource", e));
            }
            catch (URISyntaxException | ParserConfigurationException e) {
                throw new SAXException("XInclude: failed to parse document at URI: " + href + ": " + e.getMessage(), e);
            }
        }
        if (doc == null && memtreeDoc == null && xpointer == null) {
            return Optional.of(new ResourceError("document " + docUri + " not found"));
        }
        if (xpointer == null && !xqueryDoc) {
            if (memtreeDoc == null) {
                this.serializer.serializeToReceiver(doc, false);
            } else {
                this.serializer.serializeToReceiver(memtreeDoc, false);
            }
        } else {
            try {
                Sequence sequence;
                AbstractSource source;
                if (xpointer == null) {
                    source = new DBSource(this.serializer.broker, (BinaryDocument)doc, true);
                } else {
                    xpointer = this.checkNamespaces(xpointer);
                    source = new StringSource(xpointer);
                }
                XQuery xquery = this.serializer.broker.getBrokerPool().getXQueryService();
                XQueryPool pool = this.serializer.broker.getBrokerPool().getXQueryPool();
                CompiledXQuery compiled = pool.borrowCompiledXQuery(this.serializer.broker, source);
                XQueryContext context = compiled != null ? compiled.getContext() : new XQueryContext(this.serializer.broker.getBrokerPool());
                context.declareNamespaces(this.namespaces);
                context.declareNamespace("xinclude", "http://www.w3.org/2001/XInclude");
                if (this.serializer.httpContext != null) {
                    if (this.serializer.httpContext.getRequest() != null) {
                        context.declareVariable("request:request", (Object)this.serializer.httpContext.getRequest());
                    }
                    if (this.serializer.httpContext.getResponse() != null) {
                        context.declareVariable("response:response", (Object)this.serializer.httpContext.getResponse());
                    }
                    if (this.serializer.httpContext.getSession() != null) {
                        context.declareVariable("session:session", (Object)this.serializer.httpContext.getSession());
                    }
                }
                if (this.document != null) {
                    context.declareVariable("xinclude:current-doc", (Object)this.document.getFileURI().toString());
                    context.declareVariable("xinclude:current-collection", (Object)this.document.getCollection().getURI().toString());
                }
                if (xpointer != null) {
                    if (doc != null) {
                        context.setStaticallyKnownDocuments(new XmldbURI[]{doc.getURI()});
                    } else if (docUri != null) {
                        context.setStaticallyKnownDocuments(new XmldbURI[]{docUri});
                    }
                }
                if (params != null) {
                    for (Map.Entry entry : params.entrySet()) {
                        context.declareVariable((String)entry.getKey(), entry.getValue());
                    }
                }
                if (compiled == null) {
                    try {
                        compiled = xquery.compile(this.serializer.broker, context, source, xpointer != null);
                    }
                    catch (IOException e) {
                        throw new SAXException("I/O error while reading query for xinclude: " + e.getMessage(), e);
                    }
                }
                LOG.info("xpointer query: " + ExpressionDumper.dump((Expression)((Object)compiled)));
                org.exist.dom.memtree.DocumentImpl contextSeq = null;
                if (memtreeDoc != null) {
                    contextSeq = memtreeDoc;
                }
                if (Type.subTypeOf((sequence = xquery.execute(this.serializer.broker, compiled, (Sequence)contextSeq)).getItemType(), -1)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("xpointer found: " + sequence.getItemCount());
                    }
                    SequenceIterator i = sequence.iterate();
                    while (i.hasNext()) {
                        NodeValue node = (NodeValue)i.nextItem();
                        this.serializer.serializeToReceiver(node, false);
                    }
                } else {
                    for (int i = 0; i < sequence.getItemCount(); ++i) {
                        String val = sequence.itemAt(i).getStringValue();
                        this.characters(val);
                    }
                }
            }
            catch (PermissionDeniedException | XPathException e) {
                LOG.warn("xpointer error", (Throwable)e);
                throw new SAXException("Error while processing XInclude expression: " + e.getMessage(), e);
            }
        }
        this.document = prevDoc;
        this.serializer.createContainerElements = createContainerElements;
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Either<ResourceError, org.exist.dom.memtree.DocumentImpl> parseExternal(URI externalUri) throws ParserConfigurationException, SAXException {
        try {
            HttpURLConnection httpConnection;
            URLConnection con = externalUri.toURL().openConnection();
            if (con instanceof HttpURLConnection && (httpConnection = (HttpURLConnection)con).getResponseCode() != 200) {
                return Either.Left((Object)new ResourceError("XInclude: unable to retrieve from URI: " + externalUri.toString() + ", server returned response code: " + httpConnection.getResponseCode()));
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            try (InputStream is = con.getInputStream();){
                InputSource src = new InputSource(is);
                SAXParser parser = factory.newSAXParser();
                XMLReader reader = parser.getXMLReader();
                SAXAdapter adapter = new SAXAdapter();
                reader.setContentHandler(adapter);
                reader.parse(src);
                org.exist.dom.memtree.DocumentImpl doc = adapter.getDocument();
                doc.setDocumentURI(externalUri.toString());
                Either either = Either.Right((Object)doc);
                return either;
            }
        }
        catch (IOException e) {
            return Either.Left((Object)new ResourceError("XInclude: unable to retrieve and parse document from URI: " + externalUri.toString(), e));
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
        this.receiver.startPrefixMapping(prefix, uri);
    }

    private String checkNamespaces(String xpointer) throws XPathException {
        int p0;
        while ((p0 = xpointer.indexOf("xmlns(")) != -1) {
            if (p0 < 0) {
                return xpointer;
            }
            int p1 = xpointer.indexOf(41, p0 + 6);
            if (p1 < 0) {
                throw new XPathException("expected ) for xmlns()");
            }
            String mapping = xpointer.substring(p0 + 6, p1);
            xpointer = xpointer.substring(0, p0) + xpointer.substring(p1 + 1);
            StringTokenizer tok = new StringTokenizer(mapping, "= \t\n");
            if (tok.countTokens() < 2) {
                throw new XPathException("expected prefix=namespace mapping in " + mapping);
            }
            String prefix = tok.nextToken();
            String namespaceURI = tok.nextToken();
            this.namespaces.put(prefix, namespaceURI);
        }
        return xpointer;
    }

    protected Map<String, String> processParameters(String args) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = 0;
        int end = 0;
        int l = args.length();
        while (start < l && end < l) {
            while (end < l && args.charAt(end++) != '=') {
            }
            if (end == l) break;
            String param = args.substring(start, end - 1);
            start = end;
            while (end < l && args.charAt(end++) != '&') {
            }
            String value = end == l ? args.substring(start) : args.substring(start, end - 1);
            start = end;
            try {
                param = URLDecoder.decode(param, "UTF-8");
                value = URLDecoder.decode(value, "UTF-8");
                LOG.debug("parameter: " + param + " = " + value);
                parameters.put(param, value);
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return parameters;
    }

    public void setCurrentNode(INodeHandle node) {
    }

    @Override
    public Document getDocument() {
        return null;
    }

    private static class ResourceError {
        private final String message;
        private final Optional<Exception> cause;

        private ResourceError(String message, Exception cause) {
            this.message = message;
            this.cause = Optional.ofNullable(cause);
        }

        private ResourceError(String message) {
            this.message = message;
            this.cause = Optional.empty();
        }
    }
}

