/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.statistics;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import org.exist.dom.QName;
import org.exist.dom.persistent.SymbolTable;
import org.exist.storage.NodePath;
import org.exist.storage.statistics.NodeStats;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DataGuide {
    private static final int BYTES_PER_NODE = 16;
    private NodeStats root = new NodeStatsRoot();

    public int getSize() {
        return this.root.getSize();
    }

    public NodeStats add(NodePath path) {
        return this.add(path, null);
    }

    protected NodeStats add(NodePath path, NodeStats mergeWith) {
        NodeStats current = this.root;
        for (int i = 0; i < path.length(); ++i) {
            QName qn = path.getComponent(i);
            if (qn.getNameType() != 0) {
                return null;
            }
            current = current.addChild(qn);
        }
        if (mergeWith != null) {
            current.mergeStats(mergeWith);
        } else {
            current.addOccurrence();
        }
        return current;
    }

    public DataGuide mergeInto(DataGuide other) {
        this.root.mergeInto(other, new NodePath());
        return other;
    }

    public int getMaxParentDepth(QName qname) {
        NodeStats temp = new NodeStats(qname);
        this.root.getMaxParentDepth(qname, temp);
        return temp.getMaxDepth();
    }

    public String toString() {
        ArrayList<StringBuilder> paths = new ArrayList<StringBuilder>();
        this.root.dump(new StringBuilder(), paths);
        StringBuilder buf = new StringBuilder();
        for (StringBuilder path : paths) {
            buf.append((CharSequence)path);
            buf.append('\n');
        }
        return buf.toString();
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        this.root.toSAX(handler);
    }

    public void write(SeekableByteChannel chan, SymbolTable symbols) throws IOException {
        int nodeCount = this.root.getSize();
        ByteBuffer buffer = ByteBuffer.allocate(nodeCount * 16 + 4);
        this.root.write(buffer, symbols);
        buffer.flip();
        chan.write(buffer);
    }

    public void read(SeekableByteChannel chan, SymbolTable symbols) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate((int)chan.size());
        chan.read(buffer);
        buffer.flip();
        this.root.read(buffer, symbols);
    }

    private static class NodeStatsRoot
    extends NodeStats {
        private NodeStatsRoot() {
            super(null);
        }

        @Override
        protected void write(ByteBuffer buffer, SymbolTable symbols) {
            if (this.children == null) {
                buffer.putInt(0);
            } else {
                buffer.putInt(this.children.length);
                for (NodeStats child : this.children) {
                    child.write(buffer, symbols);
                }
            }
        }

        @Override
        protected void read(ByteBuffer buffer, SymbolTable symbols) {
            int childCount = buffer.getInt();
            if (childCount > 0) {
                this.children = new NodeStats[childCount];
                for (int i = 0; i < childCount; ++i) {
                    this.children[i] = new NodeStats(null);
                    this.children[i].read(buffer, symbols);
                }
            }
        }

        @Override
        public void toSAX(ContentHandler handler) throws SAXException {
            handler.startElement("http://exist.sourceforge.net/NS/exist", "distribution", "distribution", new AttributesImpl());
            if (this.children != null) {
                for (NodeStats child : this.children) {
                    child.toSAX(handler);
                }
            }
            handler.endElement("http://exist.sourceforge.net/NS/exist", "distribution", "distribution");
        }
    }
}

