/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.statistics;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.dom.QName;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.storage.statistics.DataGuide;
import org.exist.storage.statistics.IndexStatisticsWorker;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class IndexStatistics
extends AbstractIndex
implements RawBackupSupport {
    public static final String ID = IndexStatistics.class.getName();
    protected static final Logger LOG = LogManager.getLogger(IndexStatistics.class);
    private Path dataFile;
    private DataGuide dataGuide = new DataGuide();

    @Override
    public String getIndexId() {
        return ID;
    }

    public int getMaxParentDepth(QName qname) {
        return this.dataGuide.getMaxParentDepth(qname);
    }

    protected void mergeStats(DataGuide other) {
        this.dataGuide = other.mergeInto(this.dataGuide);
    }

    protected void updateStats(DataGuide newGuide) {
        this.dataGuide = newGuide;
    }

    @Override
    public void configure(BrokerPool pool, Path dataDir, Element config) throws DatabaseConfigurationException {
        super.configure(pool, dataDir, config);
        String fileName = "stats.dbx";
        if (config.hasAttribute("file")) {
            fileName = config.getAttribute("file");
        }
        this.dataFile = dataDir.resolve(fileName);
    }

    @Override
    public void open() throws DatabaseConfigurationException {
        this.dataGuide = new DataGuide();
        if (Files.exists(this.dataFile, new LinkOption[0])) {
            long start = System.currentTimeMillis();
            try (SeekableByteChannel chan = Files.newByteChannel(this.dataFile, new OpenOption[0]);){
                this.dataGuide.read(chan, this.getBrokerPool().getSymbols());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reading " + FileUtils.fileName(this.dataFile) + " took " + (System.currentTimeMillis() - start) + "ms. Size of the graph: " + this.dataGuide.getSize());
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new DatabaseConfigurationException("Error while loading " + this.dataFile.toAbsolutePath() + ": " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void close() throws DBException {
    }

    @Override
    public void sync() throws DBException {
        try (SeekableByteChannel chan = Files.newByteChannel(this.dataFile, StandardOpenOption.WRITE);){
            this.dataGuide.write(chan, this.getBrokerPool().getSymbols());
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new DBException("Error while writing " + this.dataFile.toAbsolutePath().toString() + ": " + e.getMessage());
        }
    }

    @Override
    public void remove() throws DBException {
        FileUtils.deleteQuietly(this.dataFile);
    }

    @Override
    public IndexWorker getWorker(DBBroker broker) {
        return new IndexStatisticsWorker(this);
    }

    @Override
    public boolean checkIndex(DBBroker broker) {
        return true;
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        this.dataGuide.toSAX(handler);
    }

    public String toString() {
        return this.dataGuide.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupToArchive(RawDataBackup backup) throws IOException {
        try (OutputStream os = backup.newEntry(FileUtils.fileName(this.dataFile));){
            Files.copy(this.dataFile, os);
        }
        finally {
            backup.closeEntry();
        }
    }
}

