/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.statistics;

import java.nio.ByteBuffer;
import java.util.List;
import org.exist.dom.QName;
import org.exist.dom.persistent.SymbolTable;
import org.exist.storage.NodePath;
import org.exist.storage.statistics.DataGuide;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

class NodeStats {
    private QName qname;
    private int nodeCount = 0;
    private int maxDepth = 0;
    private transient int depth = 0;
    protected NodeStats parent = null;
    protected NodeStats[] children = null;

    protected NodeStats(QName qname) {
        this(null, qname);
    }

    protected NodeStats(NodeStats parent, QName qname) {
        this.parent = parent;
        this.qname = qname;
    }

    public void incDepth() {
        ++this.depth;
    }

    public void updateMaxDepth() {
        if (this.depth > this.maxDepth) {
            this.maxDepth = this.depth;
        }
        this.depth = 0;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    protected void addOccurrence() {
        ++this.nodeCount;
    }

    protected NodeStats addChild(QName qn) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                NodeStats child = this.children[i];
                if (!child.qname.equals(qn)) continue;
                return child;
            }
        }
        if (this.children == null) {
            this.children = new NodeStats[1];
        } else {
            NodeStats[] tc = new NodeStats[this.children.length + 1];
            System.arraycopy(this.children, 0, tc, 0, this.children.length);
            this.children = tc;
        }
        this.children[this.children.length - 1] = new NodeStats(this, qn);
        return this.children[this.children.length - 1];
    }

    protected void mergeInto(DataGuide other, NodePath currentPath) {
        NodePath newPath;
        if (this.qname == null) {
            newPath = currentPath;
        } else {
            newPath = new NodePath(currentPath);
            newPath.addComponent(this.qname);
            other.add(newPath, this);
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                NodeStats child = this.children[i];
                child.mergeInto(other, newPath);
            }
        }
    }

    protected void mergeStats(NodeStats other) {
        this.nodeCount += other.nodeCount;
        if (other.maxDepth > this.maxDepth) {
            this.maxDepth = other.maxDepth;
        }
    }

    protected int getSize() {
        int s;
        int n = s = this.qname == null ? 0 : 1;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                s += this.children[i].getSize();
            }
        }
        return s;
    }

    protected void getMaxParentDepth(QName name, NodeStats max) {
        if (this.parent != null && this.qname != null && this.qname.equals(name)) {
            max.maxDepth = Math.max(this.parent.maxDepth, max.maxDepth);
        }
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].getMaxParentDepth(name, max);
            }
        }
    }

    protected void write(ByteBuffer buffer, SymbolTable symbols) {
        buffer.putShort(symbols.getNSSymbol(this.qname.getNamespaceURI()));
        buffer.putShort(symbols.getSymbol(this.qname.getLocalPart()));
        buffer.putInt(this.nodeCount);
        buffer.putInt(this.maxDepth);
        buffer.putInt(this.children == null ? 0 : this.children.length);
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].write(buffer, symbols);
            }
        }
    }

    protected void read(ByteBuffer buffer, SymbolTable symbols) {
        short nsid = buffer.getShort();
        short localid = buffer.getShort();
        String namespaceURI = symbols.getNamespace(nsid);
        String localName = symbols.getName(localid);
        this.qname = symbols.getQName((short)1, namespaceURI, localName, "");
        this.nodeCount = buffer.getInt();
        this.maxDepth = buffer.getInt();
        int childCount = buffer.getInt();
        if (childCount > 0) {
            this.children = new NodeStats[childCount];
            for (int i = 0; i < childCount; ++i) {
                this.children[i] = new NodeStats(this, null);
                this.children[i].read(buffer, symbols);
            }
        }
    }

    protected void dump(StringBuilder currentPath, List<StringBuilder> paths) {
        StringBuilder newPath;
        if (this.qname == null) {
            newPath = currentPath;
        } else {
            newPath = new StringBuilder(currentPath);
            if (newPath.length() > 0) {
                newPath.append(" -> ");
            }
            newPath.append(this.qname);
            newPath.append('[').append(this.nodeCount).append(',');
            newPath.append(this.maxDepth).append(']');
        }
        paths.add(newPath);
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                NodeStats child = this.children[i];
                child.dump(newPath, paths);
            }
        }
    }

    public void toSAX(ContentHandler handler) throws SAXException {
        AttributesImpl attribs = new AttributesImpl();
        attribs.addAttribute("", "name", "name", "CDATA", this.qname.getLocalPart());
        attribs.addAttribute("", "namespace", "namespace", "CDATA", this.qname.getNamespaceURI());
        attribs.addAttribute("", "node-count", "node-count", "CDATA", Integer.toString(this.nodeCount));
        attribs.addAttribute("", "max-depth", "max-depth", "CDATA", Integer.toString(this.maxDepth));
        handler.startElement("http://exist.sourceforge.net/NS/exist", "node", "node", attribs);
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].toSAX(handler);
            }
        }
        handler.endElement("http://exist.sourceforge.net/NS/exist", "node", "node");
    }
}

