/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.sync;

import com.evolvedbinary.j8fu.function.FunctionE;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.SystemTask;
import org.exist.storage.sync.Sync;
import org.exist.util.Configuration;
import org.exist.util.FileUtils;

public class SyncTask
implements SystemTask {
    private static final Logger LOG = LogManager.getLogger(SyncTask.class);
    private static final String JOB_NAME = "Sync";
    private Path dataDir;
    private long diskSpaceMin;

    public static String getJobName() {
        return JOB_NAME;
    }

    public static String getJobGroup() {
        return "eXist.internal";
    }

    @Override
    public boolean afterCheckpoint() {
        return false;
    }

    @Override
    public String getName() {
        return SyncTask.getJobName();
    }

    @Override
    public void configure(Configuration config, Properties properties) throws EXistException {
        this.diskSpaceMin = 0x100000L * (long)config.getProperty("db-connection.diskSpaceMin", (short)64).shortValue();
        this.dataDir = (Path)config.getProperty("db-connection.data-dir");
        LOG.info("Using DATA_DIR: " + this.dataDir.toAbsolutePath().toString() + ". Minimal disk space required for database to continue operations: " + this.diskSpaceMin / 1024L / 1024L + "mb");
        long space = FileUtils.measureFileStore(this.dataDir, (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getUsableSpace));
        LOG.info("Usable space on partition containing DATA_DIR: " + this.dataDir.toAbsolutePath().toString() + ": " + space / 1024L / 1024L + "mb");
    }

    @Override
    public void execute(DBBroker broker) throws EXistException {
        BrokerPool pool = broker.getBrokerPool();
        if (!this.checkDiskSpace()) {
            LOG.fatal("Partition containing DATA_DIR: " + this.dataDir.toAbsolutePath().toString() + " is running out of disk space. Switching eXist-db to read only to prevent data loss!");
            pool.setReadOnly();
        }
        if (System.currentTimeMillis() - pool.getLastMajorSync() > pool.getMajorSyncPeriod()) {
            pool.sync(broker, Sync.MAJOR);
        } else {
            pool.sync(broker, Sync.MINOR);
        }
    }

    private boolean checkDiskSpace() {
        long space = FileUtils.measureFileStore(this.dataDir, (FunctionE<FileStore, Long, IOException>)((FunctionE)FileStore::getUsableSpace));
        return space > this.diskSpaceMin || space == -1L;
    }
}

