/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import se.softhouse.jargo.Argument;
import se.softhouse.jargo.ParsedArguments;

public class ArgumentUtil {
    public static <T> Optional<T> getOpt(ParsedArguments parsedArguments, Argument<T> argument) {
        if (parsedArguments.wasGiven(argument)) {
            return Optional.of(parsedArguments.get(argument));
        }
        return Optional.empty();
    }

    public static <T> List<T> getListOpt(ParsedArguments parsedArguments, Argument<List<T>> argument) {
        return ArgumentUtil.getOpt(parsedArguments, argument).orElseGet(() -> Collections.emptyList());
    }

    public static Optional<Path> getPathOpt(ParsedArguments parsedArguments, Argument<File> argument) {
        return ArgumentUtil.getOpt(parsedArguments, argument).map(File::toPath);
    }

    public static List<Path> getPathsOpt(ParsedArguments parsedArguments, Argument<List<File>> argument) {
        try (Stream files = ArgumentUtil.getListOpt(parsedArguments, argument).stream();){
            List<Path> list = files.map(File::toPath).collect(Collectors.toList());
            return list;
        }
    }

    public static boolean getBool(ParsedArguments parsedArguments, Argument<Boolean> argument) {
        return ArgumentUtil.getOpt(parsedArguments, argument).flatMap(Optional::ofNullable).orElse(false);
    }
}

