/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ByteArrayPool {
    private static final int POOL_SIZE = 32;
    private static final int MAX = 128;
    private static final ThreadLocal<byte[][]> pools_ = new PoolThreadLocal();
    private static AtomicInteger slot_ = new AtomicInteger();

    private ByteArrayPool() {
    }

    public static byte[] getByteArray(int size) {
        byte[][] pool = pools_.get();
        if (size < 128) {
            int i = pool.length;
            while (i-- > 0) {
                if (pool[i] == null || pool[i].length != size) continue;
                byte[] b = pool[i];
                pool[i] = null;
                return b;
            }
        }
        return new byte[size];
    }

    public static void releaseByteArray(byte[] b) {
        if (b == null || b.length > 128) {
            return;
        }
        byte[][] pool = pools_.get();
        int i = pool.length;
        while (i-- > 0) {
            if (pool[i] != null) continue;
            pool[i] = b;
            return;
        }
        int s = slot_.incrementAndGet();
        if (s < 0) {
            s = -s;
        }
        pool[s % pool.length] = b;
    }

    private static final class PoolThreadLocal
    extends ThreadLocal<byte[][]> {
        private PoolThreadLocal() {
        }

        @Override
        protected byte[][] initialValue() {
            return new byte[32][];
        }
    }
}

