/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class CharArrayPool {
    private static final int POOL_SIZE = 128;
    private static final int MAX = 128;
    private static final ThreadLocal<char[][]> pools_ = new PoolThreadLocal();
    private static final AtomicInteger slot_ = new AtomicInteger();

    private CharArrayPool() {
    }

    public static char[] getCharArray(int size) {
        if (128 > size) {
            char[][] pool = pools_.get();
            for (int i = 0; i < pool.length; ++i) {
                if (pool[i] == null || pool[i].length != size) continue;
                char[] b = pool[i];
                pool[i] = null;
                return b;
            }
        }
        return new char[size];
    }

    public static void releaseCharArray(char[] b) {
        if (b == null || b.length > 128) {
            return;
        }
        char[][] pool = pools_.get();
        for (int i = 0; i < pool.length; ++i) {
            if (pool[i] != null) continue;
            pool[i] = b;
            return;
        }
        int s = slot_.incrementAndGet();
        if (s < 0) {
            s = -s;
        }
        pool[s % pool.length] = b;
    }

    private static final class PoolThreadLocal
    extends ThreadLocal<char[][]> {
        private PoolThreadLocal() {
        }

        @Override
        protected char[][] initialValue() {
            return new char[128][];
        }
    }
}

