/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.memtree.DocumentImpl;
import org.exist.dom.memtree.SAXAdapter;
import org.exist.scheduler.JobConfig;
import org.exist.scheduler.JobException;
import org.exist.scheduler.JobType;
import org.exist.security.internal.RealmImpl;
import org.exist.storage.IndexSpec;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DatabaseConfigurationException;
import org.exist.util.FileUtils;
import org.exist.util.ParametersExtractor;
import org.exist.validation.GrammarPool;
import org.exist.validation.resolver.eXistXMLCatalogResolver;
import org.exist.xquery.Module;
import org.exist.xquery.functions.fn.FnModule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class Configuration
implements ErrorHandler {
    private static final Logger LOG = LogManager.getLogger(Configuration.class);
    protected Optional<Path> configFilePath = Optional.empty();
    protected Optional<Path> existHome = Optional.empty();
    protected DocumentBuilder builder = null;
    protected HashMap<String, Object> config = new HashMap();
    private static final String XQUERY_CONFIGURATION_ELEMENT_NAME = "xquery";
    private static final String XQUERY_BUILTIN_MODULES_CONFIGURATION_MODULES_ELEMENT_NAME = "builtin-modules";
    private static final String XQUERY_BUILTIN_MODULES_CONFIGURATION_MODULE_ELEMENT_NAME = "module";
    public static final String BINARY_CACHE_CLASS_PROPERTY = "binary.cache.class";

    public Configuration() throws DatabaseConfigurationException {
        this("conf.xml", Optional.empty());
    }

    public Configuration(String configFilename) throws DatabaseConfigurationException {
        this(configFilename, Optional.empty());
    }

    public Configuration(String configFilename, Optional<Path> existHomeDirname) throws DatabaseConfigurationException {
        InputStream is = null;
        try {
            NodeList validations;
            NodeList xquery;
            NodeList xupdates;
            NodeList serializers;
            NodeList parsers;
            NodeList transformers;
            NodeList binaryManager;
            NodeList repository;
            NodeList dbcon;
            NodeList schedulers;
            if (configFilename == null) {
                configFilename = "conf.xml";
            }
            try {
                is = Configuration.class.getClassLoader().getResourceAsStream(configFilename);
                if (is != null) {
                    LOG.info("Reading configuration from classloader");
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e);
            }
            if (is == null) {
                Path configFile;
                Path absoluteConfigFile;
                this.existHome = existHomeDirname.map(Optional::of).orElse(ConfigurationHelper.getExistHome(configFilename));
                if (!this.existHome.isPresent() && (absoluteConfigFile = Paths.get(configFilename, new String[0])).isAbsolute() && Files.exists(absoluteConfigFile, new LinkOption[0]) && Files.isReadable(absoluteConfigFile)) {
                    this.existHome = Optional.of(absoluteConfigFile.getParent());
                    configFilename = FileUtils.fileName(absoluteConfigFile);
                }
                if (!(configFile = Paths.get(configFilename, new String[0])).isAbsolute() && this.existHome.isPresent()) {
                    configFile = this.existHome.get().resolve(configFilename);
                }
                if (!Files.exists(configFile, new LinkOption[0]) || !Files.isReadable(configFile)) {
                    throw new DatabaseConfigurationException("Unable to read configuration file at " + configFile);
                }
                this.configFilePath = Optional.of(configFile.toAbsolutePath());
                is = Files.newInputStream(configFile, new OpenOption[0]);
                existHomeDirname = Optional.of(configFile.getParent());
                LOG.info("Reading configuration from file " + configFile);
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            InputSource src = new InputSource(is);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            SAXAdapter adapter = new SAXAdapter();
            reader.setContentHandler(adapter);
            reader.parse(src);
            DocumentImpl doc = adapter.getDocument();
            NodeList indexers = doc.getElementsByTagName("indexer");
            if (indexers.getLength() > 0) {
                this.configureIndexer(existHomeDirname, doc, (Element)indexers.item(0));
            }
            if ((schedulers = doc.getElementsByTagName("scheduler")).getLength() > 0) {
                this.configureScheduler((Element)schedulers.item(0));
            }
            if ((dbcon = doc.getElementsByTagName("db-connection")).getLength() > 0) {
                this.configureBackend(existHomeDirname, (Element)dbcon.item(0));
            }
            if ((repository = doc.getElementsByTagName("repository")).getLength() > 0) {
                this.configureRepository((Element)repository.item(0));
            }
            if ((binaryManager = doc.getElementsByTagName("binary-manager")).getLength() > 0) {
                this.configureBinaryManager((Element)binaryManager.item(0));
            }
            if ((transformers = doc.getElementsByTagName("transformer")).getLength() > 0) {
                this.configureTransformer((Element)transformers.item(0));
            }
            if ((parsers = doc.getElementsByTagName("parser")).getLength() > 0) {
                this.configureParser((Element)parsers.item(0));
            }
            if ((serializers = doc.getElementsByTagName("serializer")).getLength() > 0) {
                this.configureSerializer((Element)serializers.item(0));
            }
            if ((xupdates = doc.getElementsByTagName("xupdate")).getLength() > 0) {
                this.configureXUpdate((Element)xupdates.item(0));
            }
            if ((xquery = doc.getElementsByTagName(XQUERY_CONFIGURATION_ELEMENT_NAME)).getLength() > 0) {
                this.configureXQuery((Element)xquery.item(0));
            }
            if ((validations = doc.getElementsByTagName("validation")).getLength() > 0) {
                this.configureValidation(existHomeDirname, doc, (Element)validations.item(0));
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.warn("error while reading config file: " + configFilename, (Throwable)e);
            throw new DatabaseConfigurationException(e.getMessage(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)ioe);
                }
            }
        }
    }

    private void configureRepository(Element element) {
        String root = element.getAttribute("root");
        if (root != null && root.length() > 0) {
            if (!root.endsWith("/")) {
                root = root + "/";
            }
            this.config.put("repo.root-collection", root);
        }
    }

    private void configureBinaryManager(Element binaryManager) throws DatabaseConfigurationException {
        NodeList nlCache = binaryManager.getElementsByTagName("cache");
        if (nlCache.getLength() > 0) {
            Element cache = (Element)nlCache.item(0);
            String binaryCacheClass = cache.getAttribute("class");
            this.config.put(BINARY_CACHE_CLASS_PROPERTY, binaryCacheClass);
            LOG.debug("binary.cache.class: " + this.config.get(BINARY_CACHE_CLASS_PROPERTY));
        }
    }

    private void configureXQuery(Element xquery) throws DatabaseConfigurationException {
        String backwardCompatible;
        String enforceIndexUse;
        String javabinding = this.getConfigAttributeValue(xquery, "enable-java-binding");
        if (javabinding != null) {
            this.config.put("xquery.enable-java-binding", javabinding);
            LOG.debug("xquery.enable-java-binding: " + this.config.get("xquery.enable-java-binding"));
        }
        String disableDeprecated = this.getConfigAttributeValue(xquery, "disable-deprecated-functions");
        this.config.put("xquery.disable-deprecated-functions", Configuration.parseBoolean(disableDeprecated, false));
        LOG.debug("xquery.disable-deprecated-functions: " + this.config.get("xquery.disable-deprecated-functions"));
        String optimize = this.getConfigAttributeValue(xquery, "enable-query-rewriting");
        if (optimize != null && optimize.length() > 0) {
            this.config.put("xquery.enable-query-rewriting", optimize);
            LOG.debug("xquery.enable-query-rewriting: " + this.config.get("xquery.enable-query-rewriting"));
        }
        if ((enforceIndexUse = this.getConfigAttributeValue(xquery, "enforce-index-use")) != null) {
            this.config.put("xquery.enforce-index-use", enforceIndexUse);
        }
        if ((backwardCompatible = this.getConfigAttributeValue(xquery, "backwardCompatible")) != null && backwardCompatible.length() > 0) {
            this.config.put("xquery.backwardCompatible", backwardCompatible);
            LOG.debug("xquery.backwardCompatible: " + this.config.get("xquery.backwardCompatible"));
        }
        String raiseErrorOnFailedRetrieval = this.getConfigAttributeValue(xquery, "raise-error-on-failed-retrieval");
        this.config.put("xquery.raise-error-on-failed-retrieval", Configuration.parseBoolean(raiseErrorOnFailedRetrieval, false));
        LOG.debug("xquery.raise-error-on-failed-retrieval: " + this.config.get("xquery.raise-error-on-failed-retrieval"));
        String trace = this.getConfigAttributeValue(xquery, "trace");
        this.config.put("xquery.profiling.trace", trace);
        HashMap classMap = new HashMap();
        HashMap<String, String> knownMappings = new HashMap<String, String>();
        HashMap<String, Map<String, List<? extends Object>>> moduleParameters = new HashMap<String, Map<String, List<? extends Object>>>();
        this.loadModuleClasses(xquery, classMap, knownMappings, moduleParameters);
        this.config.put("xquery.modules", classMap);
        this.config.put("xquery.modules.static", knownMappings);
        this.config.put("xquery.modules.parameters", moduleParameters);
    }

    private void loadModuleClasses(Element xquery, Map<String, Class<?>> modulesClassMap, Map<String, String> modulesSourceMap, Map<String, Map<String, List<? extends Object>>> moduleParameters) throws DatabaseConfigurationException {
        Element elem;
        NodeList modules;
        modulesClassMap.put("http://www.w3.org/2005/xpath-functions", FnModule.class);
        NodeList builtins = xquery.getElementsByTagName(XQUERY_BUILTIN_MODULES_CONFIGURATION_MODULES_ELEMENT_NAME);
        if (builtins.getLength() > 0 && (modules = (elem = (Element)builtins.item(0)).getElementsByTagName(XQUERY_BUILTIN_MODULES_CONFIGURATION_MODULE_ELEMENT_NAME)).getLength() > 0) {
            for (int i = 0; i < modules.getLength(); ++i) {
                elem = (Element)modules.item(i);
                String uri = elem.getAttribute("uri");
                String clazz = elem.getAttribute("class");
                String source = elem.getAttribute("src");
                if (uri == null) {
                    throw new DatabaseConfigurationException("element 'module' requires an attribute 'uri'");
                }
                if (clazz == null && source == null) {
                    throw new DatabaseConfigurationException("element 'module' requires either an attribute 'class' or 'src'");
                }
                if (source != null) {
                    modulesSourceMap.put(uri, source);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Registered mapping for module '" + uri + "' to '" + source + "'");
                    }
                } else {
                    Class<?> moduleClass = this.lookupModuleClass(uri, clazz);
                    if (moduleClass != null) {
                        modulesClassMap.put(uri, moduleClass);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Configured module '" + uri + "' implemented in '" + clazz + "'");
                    }
                }
                moduleParameters.put(uri, ParametersExtractor.extract(elem.getElementsByTagName("parameter")));
            }
        }
    }

    private Class<?> lookupModuleClass(String uri, String clazz) throws DatabaseConfigurationException {
        Class<?> mClass = null;
        try {
            mClass = Class.forName(clazz);
            if (!Module.class.isAssignableFrom(mClass)) {
                throw new DatabaseConfigurationException("Failed to load module: " + uri + ". Class " + clazz + " is not an instance of org.exist.xquery.Module.");
            }
        }
        catch (ClassNotFoundException e) {
            LOG.error("Configuration problem: class not found for module '" + uri + "' (ClassNotFoundException); class:'" + clazz + "'; message:'" + e.getMessage() + "'");
        }
        catch (NoClassDefFoundError e) {
            LOG.error("Module " + uri + " could not be initialized due to a missing dependancy (NoClassDefFoundError): " + e.getMessage(), (Throwable)e);
        }
        return mClass;
    }

    private void configureXUpdate(Element xupdate) throws NumberFormatException {
        String consistencyCheck;
        String fragmentation = this.getConfigAttributeValue(xupdate, "allowed-fragmentation");
        if (fragmentation != null) {
            this.config.put("xupdate.fragmentation", Integer.valueOf(fragmentation));
            LOG.debug("xupdate.fragmentation: " + this.config.get("xupdate.fragmentation"));
        }
        if ((consistencyCheck = this.getConfigAttributeValue(xupdate, "enable-consistency-checks")) != null) {
            this.config.put("xupdate.consistency-checks", Configuration.parseBoolean(consistencyCheck, false));
            LOG.debug("xupdate.consistency-checks: " + this.config.get("xupdate.consistency-checks"));
        }
    }

    private void configureTransformer(Element transformer) {
        String cachingValue;
        String className = this.getConfigAttributeValue(transformer, "class");
        if (className != null) {
            this.config.put("transformer.class", className);
            LOG.debug("transformer.class: " + this.config.get("transformer.class"));
            NodeList attrs = transformer.getElementsByTagName("attribute");
            Properties attributes = new Properties();
            for (int a = 0; a < attrs.getLength(); ++a) {
                Element attr = (Element)attrs.item(a);
                String name = attr.getAttribute("name");
                String value = attr.getAttribute("value");
                String type = attr.getAttribute("type");
                if (name == null || name.length() == 0) {
                    LOG.warn("Discarded invalid attribute for TransformerFactory: '" + className + "', name not specified");
                    continue;
                }
                if (type == null || type.length() == 0 || type.equalsIgnoreCase("string")) {
                    ((Hashtable)attributes).put(name, value);
                    continue;
                }
                if (type.equalsIgnoreCase("boolean")) {
                    ((Hashtable)attributes).put(name, Boolean.valueOf(value));
                    continue;
                }
                if (type.equalsIgnoreCase("integer")) {
                    try {
                        ((Hashtable)attributes).put(name, Integer.valueOf(value));
                    }
                    catch (NumberFormatException nfe) {
                        LOG.warn("Discarded invalid attribute for TransformerFactory: '" + className + "', name: " + name + ", value not integer: " + value);
                    }
                    continue;
                }
                ((Hashtable)attributes).put(name, value);
            }
            this.config.put("transformer.attributes", attributes);
        }
        if ((cachingValue = this.getConfigAttributeValue(transformer, "caching")) != null) {
            this.config.put("transformer.caching", Configuration.parseBoolean(cachingValue, false));
            LOG.debug("transformer.caching: " + this.config.get("transformer.caching"));
        }
    }

    private void configureParser(Element parser) {
        NodeList nlHtmlToXml = parser.getElementsByTagName("html-to-xml");
        if (nlHtmlToXml.getLength() > 0) {
            Properties pFeatures;
            NodeList nlFeatures;
            Properties pProperties;
            Element htmlToXml = (Element)nlHtmlToXml.item(0);
            String htmlToXmlParserClass = this.getConfigAttributeValue(htmlToXml, "class");
            this.config.put("parser.html-to-xml-parser", htmlToXmlParserClass);
            NodeList nlProperties = htmlToXml.getElementsByTagName("properties");
            if (nlProperties.getLength() > 0 && (pProperties = ParametersExtractor.parseProperties(nlProperties.item(0))) != null) {
                HashMap properties = new HashMap();
                pProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.put(k.toString(), v)));
                this.config.put("parser.html-to-xml-parser.properties", properties);
            }
            if ((nlFeatures = htmlToXml.getElementsByTagName("features")).getLength() > 0 && (pFeatures = ParametersExtractor.parseFeatures(nlFeatures.item(0))) != null) {
                HashMap features = new HashMap();
                pFeatures.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> features.put(k.toString(), Boolean.valueOf(v.toString()))));
                this.config.put("parser.html-to-xml-parser.features", features);
            }
        }
    }

    private void configureSerializer(Element serializer) {
        NodeList backupFilters;
        NodeList nlFilters;
        String tagAttributeMatches;
        String tagElementMatches;
        String internalId;
        String compress;
        String indent;
        String xsl;
        String xinclude = this.getConfigAttributeValue(serializer, "enable-xinclude");
        if (xinclude != null) {
            this.config.put("serialization.enable-xinclude", xinclude);
            LOG.debug("serialization.enable-xinclude: " + this.config.get("serialization.enable-xinclude"));
        }
        if ((xsl = this.getConfigAttributeValue(serializer, "enable-xsl")) != null) {
            this.config.put("serialization.enable-xsl", xsl);
            LOG.debug("serialization.enable-xsl: " + this.config.get("serialization.enable-xsl"));
        }
        if ((indent = this.getConfigAttributeValue(serializer, "indent")) != null) {
            this.config.put("serialization.indent", indent);
            LOG.debug("serialization.indent: " + this.config.get("serialization.indent"));
        }
        if ((compress = this.getConfigAttributeValue(serializer, "compress-output")) != null) {
            this.config.put("serialization.compress-output", compress);
            LOG.debug("serialization.compress-output: " + this.config.get("serialization.compress-output"));
        }
        if ((internalId = this.getConfigAttributeValue(serializer, "add-exist-id")) != null) {
            this.config.put("serialization.add-exist-id", internalId);
            LOG.debug("serialization.add-exist-id: " + this.config.get("serialization.add-exist-id"));
        }
        if ((tagElementMatches = this.getConfigAttributeValue(serializer, "match-tagging-elements")) != null) {
            this.config.put("serialization.match-tagging-elements", tagElementMatches);
            LOG.debug("serialization.match-tagging-elements: " + this.config.get("serialization.match-tagging-elements"));
        }
        if ((tagAttributeMatches = this.getConfigAttributeValue(serializer, "match-tagging-attributes")) != null) {
            this.config.put("serialization.match-tagging-attributes", tagAttributeMatches);
            LOG.debug("serialization.match-tagging-attributes: " + this.config.get("serialization.match-tagging-attributes"));
        }
        if ((nlFilters = serializer.getElementsByTagName("custom-filter")) != null) {
            ArrayList<String> filters = new ArrayList<String>(nlFilters.getLength());
            for (int i = 0; i < nlFilters.getLength(); ++i) {
                Element filterElem = (Element)nlFilters.item(i);
                String filterClass = filterElem.getAttribute("class");
                if (filterClass != null) {
                    filters.add(filterClass);
                    LOG.debug("serialization.custom-match-listeners: " + filterClass);
                    continue;
                }
                LOG.warn("Configuration element custom-filter needs an attribute 'class'");
            }
            this.config.put("serialization.custom-match-listeners", filters);
        }
        if ((backupFilters = serializer.getElementsByTagName("backup-filter")) != null) {
            ArrayList<String> filters = new ArrayList<String>(backupFilters.getLength());
            for (int i = 0; i < backupFilters.getLength(); ++i) {
                Element filterElem = (Element)backupFilters.item(i);
                String filterClass = filterElem.getAttribute("class");
                if (filterClass != null) {
                    filters.add(filterClass);
                    LOG.debug("serialization.custom-match-listeners: " + filterClass);
                    continue;
                }
                LOG.warn("Configuration element backup-filter needs an attribute 'class'");
            }
            if (!filters.isEmpty()) {
                this.config.put("backup.serialization.filters", filters);
            }
        }
    }

    private void configureScheduler(Element scheduler) {
        NodeList nlJobs = scheduler.getElementsByTagName("job");
        if (nlJobs == null) {
            return;
        }
        ArrayList<JobConfig> jobList = new ArrayList<JobConfig>();
        for (int i = 0; i < nlJobs.getLength(); ++i) {
            String jobSchedule;
            Element job = (Element)nlJobs.item(i);
            String strJobType = this.getConfigAttributeValue(job, "type");
            JobType jobType = strJobType == null ? JobType.USER : JobType.valueOf(strJobType.toUpperCase(Locale.ENGLISH));
            String jobName = this.getConfigAttributeValue(job, "name");
            String jobResource = this.getConfigAttributeValue(job, "class");
            if (jobResource == null) {
                jobResource = this.getConfigAttributeValue(job, XQUERY_CONFIGURATION_ELEMENT_NAME);
            }
            if ((jobSchedule = this.getConfigAttributeValue(job, "cron-trigger")) == null) {
                jobSchedule = this.getConfigAttributeValue(job, "period");
            }
            String jobUnschedule = this.getConfigAttributeValue(job, "unschedule-on-exception");
            try {
                String jobRepeat;
                JobConfig jobConfig = new JobConfig(jobType, jobName, jobResource, jobSchedule, jobUnschedule);
                String jobDelay = this.getConfigAttributeValue(job, "delay");
                if (jobDelay != null && jobDelay.length() > 0) {
                    jobConfig.setDelay(Long.parseLong(jobDelay));
                }
                if ((jobRepeat = this.getConfigAttributeValue(job, "repeat")) != null && jobRepeat.length() > 0) {
                    jobConfig.setRepeat(Integer.parseInt(jobRepeat));
                }
                NodeList nlParam = job.getElementsByTagName("parameter");
                Map<String, List<? extends Object>> params = ParametersExtractor.extract(nlParam);
                for (Map.Entry<String, List<? extends Object>> param : params.entrySet()) {
                    List<? extends Object> values = param.getValue();
                    if (values == null || values.size() <= 0) continue;
                    jobConfig.addParameter(param.getKey(), values.get(0).toString());
                    if (values.size() <= 1) continue;
                    LOG.warn("Parameter '" + param.getKey() + "' for job '" + jobName + "' has more than one value, ignoring further values.");
                }
                jobList.add(jobConfig);
                LOG.debug("Configured scheduled '" + (Object)((Object)jobType) + "' job '" + jobResource + (jobSchedule == null ? "" : "' with trigger '" + jobSchedule) + (jobDelay == null ? "" : "' with delay '" + jobDelay) + (jobRepeat == null ? "" : "' repetitions '" + jobRepeat) + "'");
                continue;
            }
            catch (JobException je) {
                LOG.warn((Object)je);
            }
        }
        if (jobList.size() > 0) {
            JobConfig[] configs = new JobConfig[jobList.size()];
            for (int i = 0; i < jobList.size(); ++i) {
                configs[i] = (JobConfig)jobList.get(i);
            }
            this.config.put("scheduler.jobs", configs);
        }
    }

    private void configureBackend(Optional<Path> dbHome, Element con) throws DatabaseConfigurationException {
        NodeList recoveries;
        NodeList watchConf;
        NodeList queryPoolConf;
        String diskSpace;
        String elementBuffers;
        String wordBuffers;
        String collBuffers;
        String buffers;
        String docIds;
        String nodesBuffer;
        String collCacheSize;
        String pageSize;
        String collectionCache;
        String checkMaxCache;
        String cacheMem;
        String dataFiles;
        String mysql = this.getConfigAttributeValue(con, "database");
        if (mysql != null) {
            this.config.put("database", mysql);
            LOG.debug("database: " + this.config.get("database"));
        }
        if ((dataFiles = this.getConfigAttributeValue(con, "files")) != null) {
            Path df = ConfigurationHelper.lookup(dataFiles, dbHome);
            if (!Files.isReadable(df)) {
                try {
                    Files.createDirectories(df, new FileAttribute[0]);
                }
                catch (IOException ioe) {
                    throw new DatabaseConfigurationException("cannot read data directory: " + df.toAbsolutePath().toString(), ioe);
                }
            }
            this.config.put("db-connection.data-dir", df.toAbsolutePath());
            LOG.debug("db-connection.data-dir: " + this.config.get("db-connection.data-dir"));
        }
        if ((cacheMem = this.getConfigAttributeValue(con, "cacheSize")) != null) {
            if (cacheMem.endsWith("M") || cacheMem.endsWith("m")) {
                cacheMem = cacheMem.substring(0, cacheMem.length() - 1);
            }
            try {
                this.config.put("db-connection.cache-size", Integer.valueOf(cacheMem));
                LOG.debug("db-connection.cache-size: " + this.config.get("db-connection.cache-size") + "m");
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((checkMaxCache = this.getConfigAttributeValue(con, "checkMaxCacheSize")) == null) {
            checkMaxCache = "true";
        }
        this.config.put("db-connection.check-max-cache-size", Configuration.parseBoolean(checkMaxCache, true));
        LOG.debug("db-connection.check-max-cache-size: " + this.config.get("db-connection.check-max-cache-size"));
        String cacheShrinkThreshold = this.getConfigAttributeValue(con, "cacheShrinkThreshold");
        if (cacheShrinkThreshold == null) {
            cacheShrinkThreshold = "10000";
        }
        if (cacheShrinkThreshold != null) {
            try {
                this.config.put("db-connection.cache-shrink-threshold", Integer.valueOf(cacheShrinkThreshold));
                LOG.debug("db-connection.cache-shrink-threshold: " + this.config.get("db-connection.cache-shrink-threshold"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((collectionCache = this.getConfigAttributeValue(con, "collectionCache")) != null) {
            collectionCache = collectionCache.toLowerCase();
            try {
                int collectionCacheBytes = collectionCache.endsWith("k") ? 1024 * Integer.valueOf(collectionCache.substring(0, collectionCache.length() - 1)) : (collectionCache.endsWith("kb") ? 1024 * Integer.valueOf(collectionCache.substring(0, collectionCache.length() - 2)) : (collectionCache.endsWith("m") ? 0x100000 * Integer.valueOf(collectionCache.substring(0, collectionCache.length() - 1)) : (collectionCache.endsWith("mb") ? 0x100000 * Integer.valueOf(collectionCache.substring(0, collectionCache.length() - 2)) : (collectionCache.endsWith("g") ? 0x40000000 * Integer.valueOf(collectionCache.substring(0, collectionCache.length() - 1)) : (collectionCache.endsWith("gb") ? 0x40000000 * Integer.valueOf(collectionCache.substring(0, collectionCache.length() - 2)) : Integer.valueOf(collectionCache))))));
                this.config.put("db-connection.collection-cache-mem", collectionCacheBytes);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set config {} = {}", (Object)"db-connection.collection-cache-mem", this.config.get("db-connection.collection-cache-mem"));
                }
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((pageSize = this.getConfigAttributeValue(con, "pageSize")) != null) {
            try {
                this.config.put("db-connection.page-size", Integer.valueOf(pageSize));
                LOG.debug("db-connection.page-size: " + this.config.get("db-connection.page-size"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((collCacheSize = this.getConfigAttributeValue(con, "collectionCacheSize")) != null) {
            try {
                this.config.put("db-connection.collection-cache-size", Integer.valueOf(collCacheSize));
                LOG.debug("db-connection.collection-cache-size: " + this.config.get("db-connection.collection-cache-size"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((nodesBuffer = this.getConfigAttributeValue(con, "nodesBuffer")) != null) {
            try {
                this.config.put("db-connection.nodes-buffer", Integer.valueOf(nodesBuffer));
                LOG.debug("db-connection.nodes-buffer: " + this.config.get("db-connection.nodes-buffer"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((docIds = con.getAttribute("doc-ids")) != null) {
            this.config.put("db-connection.doc-ids.mode", docIds);
        }
        if ((buffers = this.getConfigAttributeValue(con, "buffers")) != null) {
            try {
                this.config.put("db-connection.buffers", Integer.valueOf(buffers));
                LOG.debug("db-connection.buffers: " + this.config.get("db-connection.buffers"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((collBuffers = this.getConfigAttributeValue(con, "collection_buffers")) != null) {
            try {
                this.config.put("db-connection.collections.buffers", Integer.valueOf(collBuffers));
                LOG.debug("db-connection.collections.buffers: " + this.config.get("db-connection.collections.buffers"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((wordBuffers = this.getConfigAttributeValue(con, "words_buffers")) != null) {
            try {
                this.config.put("db-connection.words.buffers", Integer.valueOf(wordBuffers));
                LOG.debug("db-connection.words.buffers: " + this.config.get("db-connection.words.buffers"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((elementBuffers = this.getConfigAttributeValue(con, "elements_buffers")) != null) {
            try {
                this.config.put("db-connection.elements.buffers", Integer.valueOf(elementBuffers));
                LOG.debug("db-connection.elements.buffers: " + this.config.get("db-connection.elements.buffers"));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        if ((diskSpace = this.getConfigAttributeValue(con, "minDiskSpace")) != null) {
            if (diskSpace.endsWith("M") || diskSpace.endsWith("m")) {
                diskSpace = diskSpace.substring(0, diskSpace.length() - 1);
            }
            try {
                this.config.put("db-connection.diskSpaceMin", Short.valueOf(diskSpace));
            }
            catch (NumberFormatException nfe) {
                LOG.warn((Object)nfe);
            }
        }
        NodeList securityConf = con.getElementsByTagName("security");
        String securityManagerClassName = "org.exist.security.internal.SecurityManagerImpl";
        if (securityConf.getLength() > 0) {
            Element security = (Element)securityConf.item(0);
            securityManagerClassName = this.getConfigAttributeValue(security, "class");
            String encoding = this.getConfigAttributeValue(security, "password-encoding");
            this.config.put("db-connection.security.password-encoding", encoding);
            String realm = this.getConfigAttributeValue(security, "password-realm");
            this.config.put("db-connection.security.password-realm", realm);
            if (realm != null) {
                LOG.info("db-connection.security.password-realm: " + this.config.get("db-connection.security.password-realm"));
                RealmImpl.setPasswordRealm(realm);
            } else {
                LOG.info("No password realm set, defaulting.");
            }
        }
        try {
            this.config.put("db-connection.security.class", Class.forName(securityManagerClassName));
            LOG.debug("db-connection.security.class: " + this.config.get("db-connection.security.class"));
        }
        catch (Throwable ex) {
            if (ex instanceof ClassNotFoundException) {
                throw new DatabaseConfigurationException("Cannot find security manager class " + securityManagerClassName, ex);
            }
            throw new DatabaseConfigurationException("Cannot load security manager class " + securityManagerClassName + " due to " + ex.getMessage(), ex);
        }
        NodeList startupConf = con.getElementsByTagName("startup");
        if (startupConf.getLength() > 0) {
            this.configureStartup((Element)startupConf.item(0));
        } else {
            ArrayList startupTriggers = new ArrayList();
            this.config.put("startup.triggers", startupTriggers);
        }
        NodeList poolConf = con.getElementsByTagName("pool");
        if (poolConf.getLength() > 0) {
            this.configurePool((Element)poolConf.item(0));
        }
        if ((queryPoolConf = con.getElementsByTagName("query-pool")).getLength() > 0) {
            this.configureXQueryPool((Element)queryPoolConf.item(0));
        }
        if ((watchConf = con.getElementsByTagName("watchdog")).getLength() > 0) {
            this.configureWatchdog((Element)watchConf.item(0));
        }
        if ((recoveries = con.getElementsByTagName("recovery")).getLength() > 0) {
            this.configureRecovery(dbHome, (Element)recoveries.item(0));
        }
    }

    private void configureRecovery(Optional<Path> dbHome, Element recovery) throws DatabaseConfigurationException {
        String option = this.getConfigAttributeValue(recovery, "enabled");
        this.setProperty("db-connection.recovery.enabled", Configuration.parseBoolean(option, true));
        LOG.debug("db-connection.recovery.enabled: " + this.config.get("db-connection.recovery.enabled"));
        option = this.getConfigAttributeValue(recovery, "sync-on-commit");
        this.setProperty("db-connection.recovery.sync-on-commit", Configuration.parseBoolean(option, true));
        LOG.debug("db-connection.recovery.sync-on-commit: " + this.config.get("db-connection.recovery.sync-on-commit"));
        option = this.getConfigAttributeValue(recovery, "group-commit");
        this.setProperty("db-connection.recovery.group-commit", Configuration.parseBoolean(option, false));
        LOG.debug("db-connection.recovery.group-commit: " + this.config.get("db-connection.recovery.group-commit"));
        option = this.getConfigAttributeValue(recovery, "journal-dir");
        if (option != null) {
            Path rf = ConfigurationHelper.lookup(option, dbHome);
            if (!Files.isReadable(rf)) {
                throw new DatabaseConfigurationException("cannot read data directory: " + rf.toAbsolutePath());
            }
            this.setProperty("db-connection.recovery.journal-dir", rf.toAbsolutePath());
            LOG.debug("db-connection.recovery.journal-dir: " + this.config.get("db-connection.recovery.journal-dir"));
        }
        if ((option = this.getConfigAttributeValue(recovery, "size")) != null) {
            if (option.endsWith("M") || option.endsWith("m")) {
                option = option.substring(0, option.length() - 1);
            }
            try {
                Integer size = Integer.valueOf(option);
                this.setProperty("db-connection.recovery.size-limit", size);
                LOG.debug("db-connection.recovery.size-limit: " + this.config.get("db-connection.recovery.size-limit") + "m");
            }
            catch (NumberFormatException e) {
                throw new DatabaseConfigurationException("size attribute in recovery section needs to be a number");
            }
        }
        option = this.getConfigAttributeValue(recovery, "force-restart");
        boolean value = false;
        if (option != null) {
            value = "yes".equals(option);
        }
        this.setProperty("db-connection.recovery.force-restart", value);
        LOG.debug("db-connection.recovery.force-restart: " + this.config.get("db-connection.recovery.force-restart"));
        option = this.getConfigAttributeValue(recovery, "consistency-check");
        value = false;
        if (option != null) {
            value = "yes".equals(option);
        }
        this.setProperty("db-connection.recovery.consistency-check", value);
        LOG.debug("db-connection.recovery.consistency-check: " + this.config.get("db-connection.recovery.consistency-check"));
    }

    private void configureWatchdog(Element watchDog) {
        String maxOutput;
        String timeout = this.getConfigAttributeValue(watchDog, "query-timeout");
        if (timeout != null) {
            try {
                this.config.put("db-connection.watchdog.query-timeout", Long.valueOf(timeout));
                LOG.debug("db-connection.watchdog.query-timeout: " + this.config.get("db-connection.watchdog.query-timeout"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((maxOutput = this.getConfigAttributeValue(watchDog, "output-size-limit")) != null) {
            try {
                this.config.put("db-connection.watchdog.output-size-limit", Integer.valueOf(maxOutput));
                LOG.debug("db-connection.watchdog.output-size-limit: " + this.config.get("db-connection.watchdog.output-size-limit"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void configureXQueryPool(Element queryPool) {
        String timeout;
        String maxPoolSize;
        String maxStackSize = this.getConfigAttributeValue(queryPool, "max-stack-size");
        if (maxStackSize != null) {
            try {
                this.config.put("db-connection.query-pool.max-stack-size", Integer.valueOf(maxStackSize));
                LOG.debug("db-connection.query-pool.max-stack-size: " + this.config.get("db-connection.query-pool.max-stack-size"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((maxPoolSize = this.getConfigAttributeValue(queryPool, "size")) != null) {
            try {
                this.config.put("db-connection.query-pool.size", Integer.valueOf(maxPoolSize));
                LOG.debug("db-connection.query-pool.size: " + this.config.get("db-connection.query-pool.size"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((timeout = this.getConfigAttributeValue(queryPool, "timeout")) != null) {
            try {
                this.config.put("db-connection.query-pool.timeout", Long.valueOf(timeout));
                LOG.debug("db-connection.query-pool.timeout: " + this.config.get("db-connection.query-pool.timeout"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void configureStartup(Element startup) {
        Element triggers;
        NodeList nlTrigger;
        NodeList nlTriggers = startup.getElementsByTagName("triggers");
        if (nlTriggers != null && nlTriggers.getLength() > 0 && (nlTrigger = (triggers = (Element)nlTriggers.item(0)).getElementsByTagName("trigger")) != null && nlTrigger.getLength() > 0) {
            ArrayList<StartupTriggerConfig> startupTriggers = (ArrayList<StartupTriggerConfig>)this.config.get("startup.triggers");
            if (startupTriggers == null) {
                startupTriggers = new ArrayList<StartupTriggerConfig>();
                this.config.put("startup.triggers", startupTriggers);
            }
            for (int i = 0; i < nlTrigger.getLength(); ++i) {
                Element trigger = (Element)nlTrigger.item(i);
                String startupTriggerClass = trigger.getAttribute("class");
                boolean isStartupTrigger = false;
                try {
                    for (Class<?> iface : Class.forName(startupTriggerClass).getInterfaces()) {
                        if (!"org.exist.storage.StartupTrigger".equals(iface.getName())) continue;
                        isStartupTrigger = true;
                        break;
                    }
                    if (isStartupTrigger) {
                        Map<String, List<? extends Object>> params = ParametersExtractor.extract(trigger.getElementsByTagName("parameter"));
                        startupTriggers.add(new StartupTriggerConfig(startupTriggerClass, params));
                        LOG.info("Registered StartupTrigger: " + startupTriggerClass);
                        continue;
                    }
                    LOG.warn("StartupTrigger: " + startupTriggerClass + " does not implement org.exist.storage.StartupTrigger. IGNORING!");
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    LOG.error("Could not find StartupTrigger class: " + startupTriggerClass + ". " + cnfe.getMessage(), (Throwable)cnfe);
                }
            }
        }
    }

    private void configurePool(Element pool) {
        String maxShutdownWait;
        String sync;
        String max;
        String min = this.getConfigAttributeValue(pool, "min");
        if (min != null) {
            try {
                this.config.put("db-connection.pool.min", Integer.valueOf(min));
                LOG.debug("db-connection.pool.min: " + this.config.get("db-connection.pool.min"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((max = this.getConfigAttributeValue(pool, "max")) != null) {
            try {
                this.config.put("db-connection.pool.max", Integer.valueOf(max));
                LOG.debug("db-connection.pool.max: " + this.config.get("db-connection.pool.max"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((sync = this.getConfigAttributeValue(pool, "sync-period")) != null) {
            try {
                this.config.put("db-connection.pool.sync-period", Long.valueOf(sync));
                LOG.debug("db-connection.pool.sync-period: " + this.config.get("db-connection.pool.sync-period"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((maxShutdownWait = this.getConfigAttributeValue(pool, "wait-before-shutdown")) != null) {
            try {
                this.config.put("wait-before-shutdown", Long.valueOf(maxShutdownWait));
                LOG.debug("wait-before-shutdown: " + this.config.get("wait-before-shutdown"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
    }

    private void configureIndexer(Optional<Path> dbHome, Document doc, Element indexer) throws DatabaseConfigurationException, MalformedURLException {
        NodeList modules;
        NodeList cl;
        String suppressWSmixed;
        String suppressWS;
        String caseSensitive = this.getConfigAttributeValue(indexer, "caseSensitive");
        if (caseSensitive != null) {
            this.config.put("indexer.case-sensitive", Configuration.parseBoolean(caseSensitive, false));
            LOG.debug("indexer.case-sensitive: " + this.config.get("indexer.case-sensitive"));
        }
        int depth = 3;
        String indexDepth = this.getConfigAttributeValue(indexer, "index-depth");
        if (indexDepth != null) {
            try {
                depth = Integer.parseInt(indexDepth);
                if (depth < 3) {
                    LOG.warn("parameter index-depth should be >= 3 or you will experience a severe performance loss for node updates (XUpdate or XQuery update extensions)");
                    depth = 3;
                }
                this.config.put("indexer.index-depth", depth);
                LOG.debug("indexer.index-depth: " + this.config.get("indexer.index-depth"));
            }
            catch (NumberFormatException e) {
                LOG.warn((Object)e);
            }
        }
        if ((suppressWS = this.getConfigAttributeValue(indexer, "suppress-whitespace")) != null) {
            this.config.put("indexer.suppress-whitespace", suppressWS);
            LOG.debug("indexer.suppress-whitespace: " + this.config.get("indexer.suppress-whitespace"));
        }
        if ((suppressWSmixed = this.getConfigAttributeValue(indexer, "preserve-whitespace-mixed-content")) != null) {
            this.config.put("indexer.preserve-whitespace-mixed-content", Configuration.parseBoolean(suppressWSmixed, false));
            LOG.debug("indexer.preserve-whitespace-mixed-content: " + this.config.get("indexer.preserve-whitespace-mixed-content"));
        }
        if ((cl = doc.getElementsByTagName("index")).getLength() > 0) {
            Element elem = (Element)cl.item(0);
            IndexSpec spec = new IndexSpec(null, elem);
            this.config.put("indexer.config", spec);
        }
        if ((modules = indexer.getElementsByTagName("modules")).getLength() > 0) {
            modules = ((Element)modules.item(0)).getElementsByTagName(XQUERY_BUILTIN_MODULES_CONFIGURATION_MODULE_ELEMENT_NAME);
            IndexModuleConfig[] modConfig = new IndexModuleConfig[modules.getLength()];
            for (int i = 0; i < modules.getLength(); ++i) {
                Element elem = (Element)modules.item(i);
                String className = elem.getAttribute("class");
                String id = elem.getAttribute("id");
                if (className == null || className.length() == 0) {
                    throw new DatabaseConfigurationException("Required attribute class is missing for module");
                }
                if (id == null || id.length() == 0) {
                    throw new DatabaseConfigurationException("Required attribute id is missing for module");
                }
                modConfig[i] = new IndexModuleConfig(id, className, elem);
            }
            this.config.put("indexer.modules", modConfig);
        }
    }

    private void configureValidation(Optional<Path> dbHome, Document doc, Element validation) throws DatabaseConfigurationException {
        String mode = this.getConfigAttributeValue(validation, "mode");
        if (mode != null) {
            this.config.put("validation.mode", mode);
            LOG.debug("validation.mode: " + this.config.get("validation.mode"));
        }
        LOG.debug("Creating eXist catalog resolver");
        eXistXMLCatalogResolver resolver = new eXistXMLCatalogResolver();
        NodeList entityResolver = validation.getElementsByTagName("entity-resolver");
        if (entityResolver.getLength() > 0) {
            Element r = (Element)entityResolver.item(0);
            NodeList catalogs = r.getElementsByTagName("catalog");
            LOG.debug("Found " + catalogs.getLength() + " catalog uri entries.");
            LOG.debug("Using dbHome=" + dbHome);
            Path webappHome = dbHome.map(h -> {
                if (FileUtils.fileName(h).endsWith("WEB-INF")) {
                    return h.getParent().toAbsolutePath();
                }
                return h.resolve("webapp").toAbsolutePath();
            }).orElse(Paths.get("webapp", new String[0]).toAbsolutePath());
            LOG.debug("using webappHome=" + webappHome.toString());
            ArrayList<String> allURIs = new ArrayList<String>();
            for (int i = 0; i < catalogs.getLength(); ++i) {
                String uri = ((Element)catalogs.item(i)).getAttribute("uri");
                if (uri == null) continue;
                if (uri.indexOf("${WEBAPP_HOME}") != -1) {
                    uri = uri.replaceAll("\\$\\{WEBAPP_HOME\\}", webappHome.toUri().toString());
                }
                if (uri.indexOf("${EXIST_HOME}") != -1) {
                    uri = uri.replaceAll("\\$\\{EXIST_HOME\\}", dbHome.toString());
                }
                LOG.info("Add catalog uri " + uri + "");
                allURIs.add(uri);
            }
            resolver.setCatalogs(allURIs);
            this.config.put("validation.catalog_uris", allURIs);
        }
        this.config.put("validation.resolver", (Object)resolver);
        GrammarPool gp = new GrammarPool();
        this.config.put("validation.grammar_pool", gp);
    }

    private String getConfigAttributeValue(Element element, String attributeName) {
        String value = null;
        if (element != null && attributeName != null) {
            String property = this.getAttributeSystemPropertyName(element, attributeName);
            value = System.getProperty(property);
            if (value != null) {
                LOG.warn("Configuration value overriden by system property: " + property + ", with value: " + value);
            } else {
                value = element.getAttribute(attributeName);
            }
        }
        return value;
    }

    private String getAttributeSystemPropertyName(Element element, String attributeName) {
        StringBuilder property = new StringBuilder(attributeName);
        property.insert(0, ".");
        property.insert(0, element.getLocalName());
        for (Node parent = element.getParentNode(); parent != null && parent instanceof Element; parent = parent.getParentNode()) {
            String parentName = ((Element)parent).getLocalName();
            property.insert(0, ".");
            property.insert(0, parentName);
        }
        property.insert(0, "org.");
        return property.toString();
    }

    public Optional<Path> getConfigFilePath() {
        return this.configFilePath;
    }

    public Optional<Path> getExistHome() {
        return this.existHome;
    }

    public Object getProperty(String name) {
        return this.config.get(name);
    }

    public <T> T getProperty(String name, T defaultValue) {
        return (T)Optional.ofNullable(this.config.get(name)).orElse(defaultValue);
    }

    public boolean hasProperty(String name) {
        return this.config.containsKey(name);
    }

    public void setProperty(String name, Object obj) {
        this.config.put(name, obj);
    }

    public void removeProperty(String name) {
        this.config.remove(name);
    }

    public static boolean parseBoolean(String value, boolean defaultValue) {
        return Optional.ofNullable(value).map(v -> v.equalsIgnoreCase("yes") || v.equalsIgnoreCase("true")).orElse(defaultValue);
    }

    public int getInteger(String name) {
        return Optional.ofNullable(this.getProperty(name)).filter(v -> v instanceof Integer).map(v -> (int)((Integer)v)).orElse(-1);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        LOG.error("error occurred while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage(), (Throwable)exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        LOG.error("error occurred while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage(), (Throwable)exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        LOG.error("error occurred while reading configuration file [line: " + exception.getLineNumber() + "]:" + exception.getMessage(), (Throwable)exception);
    }

    public static final class IndexModuleConfig {
        private final String id;
        private final String className;
        private final Element config;

        public IndexModuleConfig(String id, String className, Element config) {
            this.id = id;
            this.className = className;
            this.config = config;
        }

        public String getId() {
            return this.id;
        }

        public String getClassName() {
            return this.className;
        }

        public Element getConfig() {
            return this.config;
        }
    }

    public static class StartupTriggerConfig {
        private final String clazz;
        private final Map<String, List<? extends Object>> params;

        public StartupTriggerConfig(String clazz, Map<String, List<? extends Object>> params) {
            this.clazz = clazz;
            this.params = params;
        }

        public String getClazz() {
            return this.clazz;
        }

        public Map<String, List<? extends Object>> getParams() {
            return this.params;
        }
    }
}

